/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.nixieTube;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.equipment.clipboard.ClipboardEntry;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.redstone.nixieTube.DoubleFaceAttachedBlock;
import com.simibubi.create.content.redstone.nixieTube.NixieTubeBlockEntity;
import com.simibubi.create.content.schematics.requirement.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class NixieTubeBlock
extends DoubleFaceAttachedBlock
implements IBE<NixieTubeBlockEntity>,
IWrenchable,
SimpleWaterloggedBlock,
ISpecialBlockItemRequirement {
    protected final DyeColor color;

    public NixieTubeBlock(BlockBehaviour.Properties properties, DyeColor color) {
        super(properties);
        this.color = color;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACE, (Comparable)((Object)DoubleFaceAttachedBlock.DoubleAttachFace.FLOOR))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        List<ClipboardEntry> entries;
        int i;
        String tagElement;
        if (player.m_6144_()) {
            return InteractionResult.PASS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        NixieTubeBlockEntity nixie = (NixieTubeBlockEntity)this.getBlockEntity((BlockGetter)world, pos);
        if (nixie == null) {
            return InteractionResult.PASS;
        }
        if (heldItem.m_41619_()) {
            if (nixie.reactsToRedstone()) {
                return InteractionResult.PASS;
            }
            nixie.clearCustomText();
            this.updateDisplayedRedstoneValue(state, world, pos);
            return InteractionResult.SUCCESS;
        }
        boolean display = heldItem.m_41720_() == Items.f_42656_ && heldItem.m_41788_() || AllBlocks.CLIPBOARD.isIn(heldItem);
        DyeColor dye = DyeColor.getColor((ItemStack)heldItem);
        if (!display && dye == null) {
            return InteractionResult.PASS;
        }
        CompoundTag tag = heldItem.m_41737_("display");
        String string = tagElement = tag != null && tag.m_128425_("Name", 8) ? tag.m_128461_("Name") : null;
        if (AllBlocks.CLIPBOARD.isIn(heldItem) && (i = 0) < (entries = ClipboardEntry.getLastViewedEntries(heldItem)).size()) {
            tagElement = Component.Serializer.m_130703_((Component)entries.get((int)i).text);
        }
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        String tagUsed = tagElement;
        NixieTubeBlock.walkNixies((LevelAccessor)world, pos, (currentPos, rowPosition) -> {
            if (display) {
                this.withBlockEntityDo((BlockGetter)world, (BlockPos)currentPos, be -> be.displayCustomText(tagUsed, (int)rowPosition));
            }
            if (dye != null) {
                world.m_46597_(currentPos, NixieTubeBlock.withColor(state, dye));
            }
        });
        return InteractionResult.SUCCESS;
    }

    public static void walkNixies(LevelAccessor world, BlockPos start, BiConsumer<BlockPos, Integer> callback) {
        BlockPos nextPos;
        BlockState state = world.m_8055_(start);
        if (!(state.m_60734_() instanceof NixieTubeBlock)) {
            return;
        }
        BlockPos currentPos = start;
        Direction left = ((Direction)state.m_61143_((Property)f_54117_)).m_122424_();
        if (state.m_61143_((Property)FACE) == DoubleFaceAttachedBlock.DoubleAttachFace.WALL) {
            left = Direction.UP;
        }
        if (state.m_61143_((Property)FACE) == DoubleFaceAttachedBlock.DoubleAttachFace.WALL_REVERSED) {
            left = Direction.DOWN;
        }
        Direction right = left.m_122424_();
        while (NixieTubeBlock.areNixieBlocksEqual(world.m_8055_(nextPos = currentPos.m_121945_(left)), state)) {
            currentPos = nextPos;
        }
        int index = 0;
        while (true) {
            int rowPosition = index++;
            callback.accept(currentPos, rowPosition);
            BlockPos nextPos2 = currentPos.m_121945_(right);
            if (!NixieTubeBlock.areNixieBlocksEqual(world.m_8055_(nextPos2), state)) break;
            currentPos = nextPos2;
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{FACE, f_54117_, BlockStateProperties.f_61362_}));
    }

    public void m_6810_(BlockState p_196243_1_, Level p_196243_2_, BlockPos p_196243_3_, BlockState p_196243_4_, boolean p_196243_5_) {
        if (!(p_196243_4_.m_60734_() instanceof NixieTubeBlock)) {
            p_196243_2_.m_46747_(p_196243_3_);
        }
    }

    public ItemStack m_7397_(BlockGetter p_185473_1_, BlockPos p_185473_2_, BlockState p_185473_3_) {
        return AllBlocks.ORANGE_NIXIE_TUBE.asStack();
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state, BlockEntity be) {
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, ((NixieTubeBlock)AllBlocks.ORANGE_NIXIE_TUBE.get()).m_5456_());
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = (Direction)pState.m_61143_((Property)f_54117_);
        switch ((DoubleFaceAttachedBlock.DoubleAttachFace)((Object)pState.m_61143_((Property)FACE))) {
            case CEILING: {
                return AllShapes.NIXIE_TUBE_CEILING.get(facing.m_122427_().m_122434_());
            }
            case FLOOR: {
                return AllShapes.NIXIE_TUBE.get(facing.m_122427_().m_122434_());
            }
        }
        return AllShapes.NIXIE_TUBE_WALL.get(facing);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        if (this.color != DyeColor.ORANGE) {
            return ((NixieTubeBlock)AllBlocks.ORANGE_NIXIE_TUBE.get()).getCloneItemStack(state, target, world, pos, player);
        }
        return super.getCloneItemStack(state, target, world, pos, player);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighbourState, LevelAccessor world, BlockPos pos, BlockPos neighbourPos) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return state;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (state == null) {
            return null;
        }
        if (state.m_61143_((Property)FACE) != DoubleFaceAttachedBlock.DoubleAttachFace.WALL && state.m_61143_((Property)FACE) != DoubleFaceAttachedBlock.DoubleAttachFace.WALL_REVERSED) {
            state = (BlockState)state.m_61124_((Property)f_54117_, (Comparable)((Direction)state.m_61143_((Property)f_54117_)).m_122427_());
        }
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block p_220069_4_, BlockPos p_220069_5_, boolean p_220069_6_) {
        if (worldIn.f_46443_) {
            return;
        }
        if (!worldIn.m_183326_().m_183588_(pos, (Object)this)) {
            worldIn.m_186460_(pos, (Block)this, 0);
        }
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource r) {
        this.updateDisplayedRedstoneValue(state, (Level)worldIn, pos);
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.m_60734_() == oldState.m_60734_() || isMoving) {
            return;
        }
        this.updateDisplayedRedstoneValue(state, worldIn, pos);
    }

    private void updateDisplayedRedstoneValue(BlockState state, Level worldIn, BlockPos pos) {
        if (worldIn.f_46443_) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
            if (be.reactsToRedstone()) {
                be.updateRedstoneStrength(this.getPower(worldIn, pos));
            }
        });
    }

    static boolean isValidBlock(BlockGetter world, BlockPos pos, boolean above) {
        BlockState state = world.m_8055_(pos.m_6630_(above ? 1 : -1));
        return !state.m_60808_(world, pos).m_83281_();
    }

    private int getPower(Level worldIn, BlockPos pos) {
        int power = 0;
        for (Direction direction : Iterate.directions) {
            power = Math.max(worldIn.m_46681_(pos.m_121945_(direction), direction), power);
        }
        for (Direction direction : Iterate.directions) {
            power = Math.max(worldIn.m_46681_(pos.m_121945_(direction), Direction.UP), power);
        }
        return power;
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return side != null;
    }

    @Override
    public Class<NixieTubeBlockEntity> getBlockEntityClass() {
        return NixieTubeBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends NixieTubeBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.NIXIE_TUBE.get();
    }

    public DyeColor getColor() {
        return this.color;
    }

    public static boolean areNixieBlocksEqual(BlockState blockState, BlockState otherState) {
        if (!(blockState.m_60734_() instanceof NixieTubeBlock)) {
            return false;
        }
        if (!(otherState.m_60734_() instanceof NixieTubeBlock)) {
            return false;
        }
        return NixieTubeBlock.withColor(blockState, DyeColor.WHITE) == NixieTubeBlock.withColor(otherState, DyeColor.WHITE);
    }

    public static BlockState withColor(BlockState state, DyeColor color) {
        return (BlockState)((BlockState)((BlockState)(color == DyeColor.ORANGE ? AllBlocks.ORANGE_NIXIE_TUBE : AllBlocks.NIXIE_TUBES.get(color)).getDefaultState().m_61124_((Property)f_54117_, (Comparable)((Direction)state.m_61143_((Property)f_54117_)))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)))).m_61124_((Property)FACE, (Comparable)((Object)((DoubleFaceAttachedBlock.DoubleAttachFace)((Object)state.m_61143_((Property)FACE)))));
    }

    public static DyeColor colorOf(BlockState blockState) {
        return blockState.m_60734_() instanceof NixieTubeBlock ? ((NixieTubeBlock)blockState.m_60734_()).color : DyeColor.ORANGE;
    }

    public static Direction getFacing(BlockState sideState) {
        return NixieTubeBlock.getConnectedDirection(sideState);
    }
}

