/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.minecart;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.simibubi.create.content.contraptions.minecart.capability.CapabilityMinecartController;
import com.simibubi.create.content.contraptions.minecart.capability.MinecartController;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.MinecartFurnace;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;

public class MinecartSim2020 {
    private static final Map<RailShape, Pair<Vec3i, Vec3i>> MATRIX = (Map)Util.m_137469_((Object)Maps.newEnumMap(RailShape.class), map -> {
        Vec3i west = Direction.WEST.m_122436_();
        Vec3i east = Direction.EAST.m_122436_();
        Vec3i north = Direction.NORTH.m_122436_();
        Vec3i south = Direction.SOUTH.m_122436_();
        map.put(RailShape.NORTH_SOUTH, Pair.of((Object)north, (Object)south));
        map.put(RailShape.EAST_WEST, Pair.of((Object)west, (Object)east));
        map.put(RailShape.ASCENDING_EAST, Pair.of((Object)west.m_7495_(), (Object)east));
        map.put(RailShape.ASCENDING_WEST, Pair.of((Object)west, (Object)east.m_7495_()));
        map.put(RailShape.ASCENDING_NORTH, Pair.of((Object)north, (Object)south.m_7495_()));
        map.put(RailShape.ASCENDING_SOUTH, Pair.of((Object)north.m_7495_(), (Object)south));
        map.put(RailShape.SOUTH_EAST, Pair.of((Object)south, (Object)east));
        map.put(RailShape.SOUTH_WEST, Pair.of((Object)south, (Object)west));
        map.put(RailShape.NORTH_WEST, Pair.of((Object)north, (Object)west));
        map.put(RailShape.NORTH_EAST, Pair.of((Object)north, (Object)east));
    });

    public static Vec3 predictNextPositionOf(AbstractMinecart cart) {
        Vec3 position = cart.m_20182_();
        Vec3 motion = VecHelper.clamp(cart.m_20184_(), 1.0f);
        return position.m_82549_(motion);
    }

    public static boolean canAddMotion(AbstractMinecart c) {
        if (c instanceof MinecartFurnace) {
            return Mth.m_14082_((double)((MinecartFurnace)c).f_38545_, (double)0.0) && Mth.m_14082_((double)((MinecartFurnace)c).f_38546_, (double)0.0);
        }
        LazyOptional capability = c.getCapability(CapabilityMinecartController.MINECART_CONTROLLER_CAPABILITY);
        return !capability.isPresent() || !((MinecartController)capability.orElse(null)).isStalled();
    }

    public static void moveCartAlongTrack(AbstractMinecart cart, Vec3 forcedMovement, BlockPos cartPos, BlockState trackState) {
        double d14;
        if (forcedMovement.equals((Object)Vec3.f_82478_)) {
            return;
        }
        Vec3 previousMotion = cart.m_20184_();
        cart.f_19789_ = 0.0f;
        double x = cart.m_20185_();
        double y = cart.m_20186_();
        double z = cart.m_20189_();
        double actualX = x;
        double actualY = y;
        double actualZ = z;
        Vec3 actualVec = cart.m_38179_(actualX, actualY, actualZ);
        actualY = cartPos.m_123342_() + 1;
        BaseRailBlock abstractrailblock = (BaseRailBlock)trackState.m_60734_();
        RailShape railshape = abstractrailblock.getRailDirection(trackState, (BlockGetter)cart.f_19853_, cartPos, cart);
        switch (railshape) {
            case ASCENDING_EAST: {
                forcedMovement = forcedMovement.m_82520_(-1.0 * cart.getSlopeAdjustment(), 0.0, 0.0);
                actualY += 1.0;
                break;
            }
            case ASCENDING_WEST: {
                forcedMovement = forcedMovement.m_82520_(cart.getSlopeAdjustment(), 0.0, 0.0);
                actualY += 1.0;
                break;
            }
            case ASCENDING_NORTH: {
                forcedMovement = forcedMovement.m_82520_(0.0, 0.0, cart.getSlopeAdjustment());
                actualY += 1.0;
                break;
            }
            case ASCENDING_SOUTH: {
                forcedMovement = forcedMovement.m_82520_(0.0, 0.0, -1.0 * cart.getSlopeAdjustment());
                actualY += 1.0;
            }
        }
        Pair<Vec3i, Vec3i> pair = MATRIX.get(railshape);
        Vec3i Vector3i = (Vec3i)pair.getFirst();
        Vec3i Vector3i1 = (Vec3i)pair.getSecond();
        double d4 = Vector3i1.m_123341_() - Vector3i.m_123341_();
        double d5 = Vector3i1.m_123343_() - Vector3i.m_123343_();
        double d7 = forcedMovement.f_82479_ * d4 + forcedMovement.f_82481_ * d5;
        if (d7 < 0.0) {
            d4 = -d4;
            d5 = -d5;
        }
        double d23 = (double)cartPos.m_123341_() + 0.5 + (double)Vector3i.m_123341_() * 0.5;
        double d10 = (double)cartPos.m_123343_() + 0.5 + (double)Vector3i.m_123343_() * 0.5;
        double d12 = (double)cartPos.m_123341_() + 0.5 + (double)Vector3i1.m_123341_() * 0.5;
        double d13 = (double)cartPos.m_123343_() + 0.5 + (double)Vector3i1.m_123343_() * 0.5;
        d4 = d12 - d23;
        d5 = d13 - d10;
        if (d4 == 0.0) {
            d14 = actualZ - (double)cartPos.m_123343_();
        } else if (d5 == 0.0) {
            d14 = actualX - (double)cartPos.m_123341_();
        } else {
            double d15 = actualX - d23;
            double d16 = actualZ - d10;
            d14 = (d15 * d4 + d16 * d5) * 2.0;
        }
        actualX = d23 + d4 * d14;
        actualZ = d10 + d5 * d14;
        cart.m_6034_(actualX, actualY, actualZ);
        cart.m_20256_(forcedMovement);
        cart.moveMinecartOnRail(cartPos);
        x = cart.m_20185_();
        y = cart.m_20186_();
        z = cart.m_20189_();
        if (Vector3i.m_123342_() != 0 && Mth.m_14107_((double)x) - cartPos.m_123341_() == Vector3i.m_123341_() && Mth.m_14107_((double)z) - cartPos.m_123343_() == Vector3i.m_123343_()) {
            cart.m_6034_(x, y + (double)Vector3i.m_123342_(), z);
        } else if (Vector3i1.m_123342_() != 0 && Mth.m_14107_((double)x) - cartPos.m_123341_() == Vector3i1.m_123341_() && Mth.m_14107_((double)z) - cartPos.m_123343_() == Vector3i1.m_123343_()) {
            cart.m_6034_(x, y + (double)Vector3i1.m_123342_(), z);
        }
        x = cart.m_20185_();
        y = cart.m_20186_();
        z = cart.m_20189_();
        Vec3 Vector3d3 = cart.m_38179_(x, y, z);
        if (Vector3d3 != null && actualVec != null) {
            double d17 = (actualVec.f_82480_ - Vector3d3.f_82480_) * 0.05;
            Vec3 Vector3d4 = cart.m_20184_();
            double d18 = Math.sqrt(Vector3d4.m_165925_());
            if (d18 > 0.0) {
                cart.m_20256_(Vector3d4.m_82542_((d18 + d17) / d18, 1.0, (d18 + d17) / d18));
            }
            cart.m_6034_(x, Vector3d3.f_82480_, z);
        }
        x = cart.m_20185_();
        y = cart.m_20186_();
        z = cart.m_20189_();
        int j = Mth.m_14107_((double)x);
        int i = Mth.m_14107_((double)z);
        if (j != cartPos.m_123341_() || i != cartPos.m_123343_()) {
            Vec3 Vector3d5 = cart.m_20184_();
            double d26 = Math.sqrt(Vector3d5.m_165925_());
            cart.m_20334_(d26 * (double)(j - cartPos.m_123341_()), Vector3d5.f_82480_, d26 * (double)(i - cartPos.m_123343_()));
        }
        cart.m_20256_(previousMotion);
    }

    public static Vec3 getRailVec(RailShape shape) {
        switch (shape) {
            case ASCENDING_NORTH: 
            case ASCENDING_SOUTH: 
            case NORTH_SOUTH: {
                return new Vec3(0.0, 0.0, 1.0);
            }
            case ASCENDING_EAST: 
            case ASCENDING_WEST: 
            case EAST_WEST: {
                return new Vec3(1.0, 0.0, 0.0);
            }
            case NORTH_EAST: 
            case SOUTH_WEST: {
                return new Vec3(1.0, 0.0, 1.0).m_82541_();
            }
            case NORTH_WEST: 
            case SOUTH_EAST: {
                return new Vec3(1.0, 0.0, -1.0).m_82541_();
            }
        }
        return new Vec3(0.0, 1.0, 0.0);
    }
}

