/*
 * Decompiled with CFR 0.152.
 */
package dev.smolinacadena.sebastrnlib.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="sebastrnlib", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigHandler {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final Server SERVER;

    static {
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        Pair serverSpecPair = new ForgeConfigSpec.Builder().configure(Server::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
        SERVER_SPEC = (ForgeConfigSpec)serverSpecPair.getRight();
        SERVER = (Server)serverSpecPair.getLeft();
    }

    public static class Client {
        public ForgeConfigSpec.BooleanValue sayThanksMessage;

        Client(ForgeConfigSpec.Builder builder) {
            this.sayThanksMessage = builder.comment("Display a thank you message at spawn?").define("sayThanksMessage", true);
        }
    }

    public static class Server {
        public ForgeConfigSpec.BooleanValue disableThanksMessage;

        Server(ForgeConfigSpec.Builder builder) {
            this.disableThanksMessage = builder.comment(new String[]{"Set this to true to disable sending the thank you message that SebastrnLib shows when a player joins.", "Note, that this stops showing the message for every player, even those that want to see them."}).define("disable_thanks_message", false);
        }
    }
}

