/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.render;

import com.lothrazar.cyclic.render.LaserRenderType;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelLastEvent;

public class RenderMiningLaser {
    public static final int RANGE = 18;

    private static float calculateLaserFlickerModifier(long gameTime) {
        return 0.9f + 0.1f * Mth.m_14031_((float)((float)gameTime * 0.99f)) * Mth.m_14031_((float)((float)gameTime * 0.3f)) * Mth.m_14031_((float)((float)gameTime * 0.1f));
    }

    public static void renderLaser(RenderLevelLastEvent event, Player player, float ticks, ItemStack stack, InteractionHand hand) {
        Vec3 playerPos = player.m_20299_(ticks);
        HitResult trace = player.m_19907_(18.0, 0.0f, false);
        float speedModifier = 0.4f;
        RenderMiningLaser.drawLasers(hand, stack, event, playerPos, trace, 0.0, 0.0, 0.0, 0.39215687f, 0.0f, 0.007843138f, 0.02f, player, ticks, speedModifier);
    }

    public static void drawLasers(InteractionHand activeHand, ItemStack stack, RenderLevelLastEvent event, Vec3 from, HitResult trace, double xOffset, double yOffset, double zOffset, float r, float g, float b, float thickness, Player player, float ticks, float speedModifier) {
        double distance = Math.max(1.0, from.m_82546_(trace.m_82450_()).m_82553_());
        long gameTime = player.f_19853_.m_46467_();
        double v = (float)gameTime * speedModifier;
        float additiveThickness = thickness * 3.5f * RenderMiningLaser.calculateLaserFlickerModifier(gameTime);
        float beam2r = 0.39215687f;
        float beam2g = 0.0f;
        float beam2b = 0.039215688f;
        Vec3 view = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        PoseStack matrix = event.getPoseStack();
        matrix.m_85836_();
        matrix.m_85837_(-view.m_7096_(), -view.m_7098_(), -view.m_7094_());
        matrix.m_85837_(from.f_82479_, from.f_82480_, from.f_82481_);
        matrix.m_85845_(Vector3f.f_122225_.m_122240_(Mth.m_14179_((float)ticks, (float)(-player.m_146908_()), (float)(-player.f_19859_))));
        matrix.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14179_((float)ticks, (float)player.m_146909_(), (float)player.f_19860_)));
        PoseStack.Pose matrixstack$entry = matrix.m_85850_();
        Matrix3f matrixNormal = matrixstack$entry.m_85864_();
        Matrix4f positionMatrix = matrixstack$entry.m_85861_();
        VertexConsumer builder = buffer.m_6299_(LaserRenderType.LASER_MAIN_ADDITIVE);
        RenderMiningLaser.drawBeam(stack, xOffset, yOffset, zOffset, builder, positionMatrix, matrixNormal, additiveThickness, activeHand, distance, 0.5, 1.0, ticks, r, g, b, 0.7f);
        builder = buffer.m_6299_(LaserRenderType.LASER_MAIN_BEAM);
        RenderMiningLaser.drawBeam(stack, xOffset, yOffset, zOffset, builder, positionMatrix, matrixNormal, thickness, activeHand, distance, v, v + distance * 1.5, ticks, r, g, b, 1.0f);
        builder = buffer.m_6299_(LaserRenderType.LASER_MAIN_CORE);
        RenderMiningLaser.drawBeam(stack, xOffset, yOffset, zOffset, builder, positionMatrix, matrixNormal, thickness / 2.0f, activeHand, distance, v, v + distance * 1.5, ticks, beam2r, beam2g, beam2b, 1.0f);
        matrix.m_85849_();
        buffer.m_109911_();
    }

    private static void drawBeam(ItemStack stack, double xOffset, double yOffset, double zOffset, VertexConsumer builder, Matrix4f positionMatrix, Matrix3f matrixNormalIn, float thickness, InteractionHand hand, double distance, double v1, double v2, float ticks, float r, float g, float b, float alpha) {
        boolean isFancy = true;
        boolean isSimple = false;
        Vector3f vector3f = new Vector3f(0.0f, 1.0f, 0.0f);
        vector3f.m_122249_(matrixNormalIn);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        float startXOffset = -0.2f;
        float startYOffset = -0.108f;
        float startZOffset = 0.6f;
        if (isFancy) {
            startYOffset += 0.02f;
        }
        if (isSimple) {
            startXOffset -= 0.02f;
            startZOffset += 0.05f;
            startYOffset -= 0.005f;
        }
        startZOffset += 1.0f - player.m_108565_();
        if (hand == InteractionHand.OFF_HAND) {
            startYOffset = -0.12f;
            startXOffset = 0.25f;
        }
        float f = Mth.m_14179_((float)ticks, (float)player.f_19860_, (float)player.m_146909_()) - Mth.m_14179_((float)ticks, (float)player.f_108588_, (float)player.f_108586_);
        float f1 = Mth.m_14179_((float)ticks, (float)player.f_19859_, (float)player.m_146908_()) - Mth.m_14179_((float)ticks, (float)player.f_108587_, (float)player.f_108585_);
        Vector4f vec1 = new Vector4f(startXOffset += f1 / 750.0f, -thickness + (startYOffset += f / 750.0f), startZOffset, 1.0f);
        vec1.m_123607_(positionMatrix);
        Vector4f vec2 = new Vector4f((float)xOffset, -thickness + (float)yOffset, (float)distance + (float)zOffset, 1.0f);
        vec2.m_123607_(positionMatrix);
        Vector4f vec3 = new Vector4f((float)xOffset, thickness + (float)yOffset, (float)distance + (float)zOffset, 1.0f);
        vec3.m_123607_(positionMatrix);
        Vector4f vec4 = new Vector4f(startXOffset, thickness + startYOffset, startZOffset, 1.0f);
        vec4.m_123607_(positionMatrix);
        if (hand == InteractionHand.MAIN_HAND) {
            builder.m_5954_(vec4.m_123601_(), vec4.m_123615_(), vec4.m_123616_(), r, g, b, alpha, 0.0f, (float)v1, OverlayTexture.f_118083_, 0xF000F0, vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_());
            builder.m_5954_(vec3.m_123601_(), vec3.m_123615_(), vec3.m_123616_(), r, g, b, alpha, 0.0f, (float)v2, OverlayTexture.f_118083_, 0xF000F0, vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_());
            builder.m_5954_(vec2.m_123601_(), vec2.m_123615_(), vec2.m_123616_(), r, g, b, alpha, 1.0f, (float)v2, OverlayTexture.f_118083_, 0xF000F0, vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_());
            builder.m_5954_(vec1.m_123601_(), vec1.m_123615_(), vec1.m_123616_(), r, g, b, alpha, 1.0f, (float)v1, OverlayTexture.f_118083_, 0xF000F0, vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_());
            builder.m_5954_(vec1.m_123601_(), vec1.m_123615_(), vec1.m_123616_(), r, g, b, alpha, 1.0f, (float)v1, OverlayTexture.f_118083_, 0xF000F0, vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_());
            builder.m_5954_(vec2.m_123601_(), vec2.m_123615_(), vec2.m_123616_(), r, g, b, alpha, 1.0f, (float)v2, OverlayTexture.f_118083_, 0xF000F0, vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_());
            builder.m_5954_(vec3.m_123601_(), vec3.m_123615_(), vec3.m_123616_(), r, g, b, alpha, 0.0f, (float)v2, OverlayTexture.f_118083_, 0xF000F0, vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_());
            builder.m_5954_(vec4.m_123601_(), vec4.m_123615_(), vec4.m_123616_(), r, g, b, alpha, 0.0f, (float)v1, OverlayTexture.f_118083_, 0xF000F0, vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_());
        } else {
            builder.m_5954_(vec1.m_123601_(), vec1.m_123615_(), vec1.m_123616_(), r, g, b, alpha, 1.0f, (float)v1, OverlayTexture.f_118083_, 0xF000F0, vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_());
            builder.m_5954_(vec2.m_123601_(), vec2.m_123615_(), vec2.m_123616_(), r, g, b, alpha, 1.0f, (float)v2, OverlayTexture.f_118083_, 0xF000F0, vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_());
            builder.m_5954_(vec3.m_123601_(), vec3.m_123615_(), vec3.m_123616_(), r, g, b, alpha, 0.0f, (float)v2, OverlayTexture.f_118083_, 0xF000F0, vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_());
            builder.m_5954_(vec4.m_123601_(), vec4.m_123615_(), vec4.m_123616_(), r, g, b, alpha, 0.0f, (float)v1, OverlayTexture.f_118083_, 0xF000F0, vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_());
            builder.m_5954_(vec4.m_123601_(), vec4.m_123615_(), vec4.m_123616_(), r, g, b, alpha, 0.0f, (float)v1, OverlayTexture.f_118083_, 0xF000F0, vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_());
            builder.m_5954_(vec3.m_123601_(), vec3.m_123615_(), vec3.m_123616_(), r, g, b, alpha, 0.0f, (float)v2, OverlayTexture.f_118083_, 0xF000F0, vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_());
            builder.m_5954_(vec2.m_123601_(), vec2.m_123615_(), vec2.m_123616_(), r, g, b, alpha, 1.0f, (float)v2, OverlayTexture.f_118083_, 0xF000F0, vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_());
            builder.m_5954_(vec1.m_123601_(), vec1.m_123615_(), vec1.m_123616_(), r, g, b, alpha, 1.0f, (float)v1, OverlayTexture.f_118083_, 0xF000F0, vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_());
        }
    }
}

