/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.net;

import com.lothrazar.cyclic.net.PacketBaseCyclic;
import com.lothrazar.cyclic.util.HarvestUtil;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class PacketHarvesting
extends PacketBaseCyclic {
    BlockPos pos;
    int radius;

    public PacketHarvesting(BlockPos pos, int radius) {
        this.pos = pos;
        this.radius = radius;
    }

    public static PacketHarvesting decode(FriendlyByteBuf buf) {
        CompoundTag tags = buf.m_130260_();
        return new PacketHarvesting(new BlockPos(tags.m_128451_("x"), tags.m_128451_("y"), tags.m_128451_("z")), buf.readInt());
    }

    public static void encode(PacketHarvesting msg, FriendlyByteBuf buf) {
        CompoundTag tags = new CompoundTag();
        tags.m_128405_("x", msg.pos.m_123341_());
        tags.m_128405_("y", msg.pos.m_123342_());
        tags.m_128405_("z", msg.pos.m_123343_());
        buf.m_130079_(tags);
        buf.writeInt(msg.radius);
    }

    public static void handle(PacketHarvesting message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            HarvestUtil.harvestShape(sender.f_19853_, message.pos, message.radius);
        });
        message.done(ctx);
    }
}

