/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.lothrazar.cyclic.enchant.EnchantmentCyclic;
import com.lothrazar.cyclic.util.GrowthUtil;
import com.lothrazar.cyclic.util.ItemStackUtil;
import com.lothrazar.cyclic.util.ShapeUtil;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GrowthEnchant
extends EnchantmentCyclic {
    public static final int HEIGHT = 2;
    public static final double ODDS = 0.04;
    public static final String ID = "growth";
    public static ForgeConfigSpec.BooleanValue CFG;
    public static ForgeConfigSpec.IntValue RADIUSFACTOR;

    public GrowthEnchant(Enchantment.Rarity rarityIn, EnchantmentCategory typeIn, EquipmentSlot ... slots) {
        super(rarityIn, typeIn, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)CFG.get();
    }

    public boolean m_6594_() {
        return this.isEnabled() && super.m_6594_();
    }

    public boolean m_6592_() {
        return this.isEnabled() && super.m_6592_();
    }

    public boolean isAllowedOnBooks() {
        return this.isEnabled() && super.isAllowedOnBooks();
    }

    public boolean m_6081_(ItemStack stack) {
        return this.isEnabled() && super.m_6081_(stack) && stack.m_41720_() instanceof HoeItem;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.isEnabled() && super.canApplyAtEnchantingTable(stack);
    }

    public int m_6586_() {
        return 3;
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingTickEvent event) {
        Level level;
        Player p;
        if (!this.isEnabled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player && ((p = (Player)entity).m_5833_() || !p.m_6084_())) {
            return;
        }
        int level2 = this.getCurrentLevelTool(entity.m_21120_(InteractionHand.MAIN_HAND));
        if (level2 > 0 && (level = entity.f_19853_) instanceof ServerLevel) {
            ServerLevel sw = (ServerLevel)level;
            if (entity.f_19853_.f_46441_.m_188500_() > 0.04 / (double)level2) {
                return;
            }
            int growthLimit = level2 * 2 + (entity.f_19853_.m_46471_() ? 4 : 1);
            int grown = 0;
            List<BlockPos> shape = ShapeUtil.squareHorizontalFull(entity.m_20183_().m_7495_(), level2 + (Integer)RADIUSFACTOR.get());
            shape = ShapeUtil.repeatShapeByHeight(shape, 2);
            Collections.shuffle(shape);
            for (int i = 0; i < shape.size() && grown < growthLimit; ++i) {
                GrowthUtil.tryGrow(sw, shape.get(i), 0.4);
            }
            if (grown > 0) {
                ItemStackUtil.damageItem(entity, entity.m_21120_(InteractionHand.MAIN_HAND));
            }
        }
    }
}

