/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.lothrazar.cyclic.enchant.EnchantmentCyclic;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BeekeeperEnchant
extends EnchantmentCyclic {
    public static final String ID = "beekeeper";
    public static ForgeConfigSpec.BooleanValue CFG;

    public BeekeeperEnchant(Enchantment.Rarity rarityIn, EnchantmentCategory typeIn, EquipmentSlot ... slots) {
        super(rarityIn, typeIn, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)CFG.get();
    }

    public boolean m_6594_() {
        return this.isEnabled() && super.m_6594_();
    }

    public boolean m_6592_() {
        return this.isEnabled() && super.m_6592_();
    }

    public boolean isAllowedOnBooks() {
        return this.isEnabled() && super.isAllowedOnBooks();
    }

    public boolean m_6081_(ItemStack stack) {
        return this.isEnabled() && super.m_6081_(stack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.isEnabled() && super.canApplyAtEnchantingTable(stack);
    }

    public int m_6586_() {
        return 2;
    }

    @SubscribeEvent
    public void onLivingChangeTargetEvent(LivingChangeTargetEvent event) {
        LivingEntity livingEntity;
        if (!this.isEnabled()) {
            return;
        }
        if (event.getOriginalTarget() instanceof Player && event.getEntity().m_6095_() == EntityType.f_20550_ && (livingEntity = event.getEntity()) instanceof Bee) {
            Bee bee = (Bee)livingEntity;
            int level = this.getCurrentArmorLevel(event.getOriginalTarget());
            if (level > 0) {
                event.setCanceled(true);
                bee.m_21561_(false);
                bee.m_7870_(0);
                bee.m_6925_(null);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDamageEvent(LivingDamageEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        int level = this.getCurrentArmorLevel(event.getEntity());
        if (level >= 1 && event.getSource() != null && event.getSource().m_7640_() != null) {
            Entity esrc = event.getSource().m_7640_();
            if (esrc.m_6095_() == EntityType.f_20550_ || esrc.m_6095_() == EntityType.f_20549_ || esrc.m_6095_() == EntityType.f_20467_) {
                event.setAmount(0.0f);
            }
            if (level >= 2 && esrc.m_6095_() == EntityType.f_20509_) {
                event.setAmount(0.0f);
            }
        }
    }
}

