/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.soundmuff;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.BlockCyclic;
import com.lothrazar.cyclic.block.soundmuff.SoundVolumeControlled;
import com.lothrazar.cyclic.config.ConfigRegistry;
import com.lothrazar.cyclic.util.BlockstatesUtil;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SoundmufflerBlock
extends BlockCyclic {
    private static final int VOL_REDUCE_PER_BLOCK = 2;

    public SoundmufflerBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60978_(1.0f).m_60918_(SoundType.f_56756_));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onPlaySound(PlaySoundEvent event) {
        ClientLevel clientWorld = Minecraft.m_91087_().f_91073_;
        if (event.getSound() == null || clientWorld == null) {
            return;
        }
        SoundInstance sound = event.getSound();
        boolean isPowered = false;
        ArrayList<BlockPos> blocks = BlockstatesUtil.findBlocks((Level)clientWorld, new BlockPos(sound.m_7772_(), sound.m_7780_(), sound.m_7778_()), (Block)this, (Integer)ConfigRegistry.SOUND_RADIUS.get(), false);
        if (blocks == null || blocks.size() == 0) {
            return;
        }
        float reduce = 2.0f;
        float radius = ((Integer)ConfigRegistry.SOUND_RADIUS.get()).intValue();
        float volume = (float)(Math.min((double)(reduce / radius), 1.0) / (double)blocks.size());
        SoundmufflerBlock.rebuildSoundWithVolume(event, sound, volume);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void rebuildSoundWithVolume(PlaySoundEvent event, SoundInstance sound, float newVolume) {
        try {
            SoundVolumeControlled newSound = new SoundVolumeControlled(sound);
            newSound.setVolume(newVolume);
            event.setSound((SoundInstance)newSound);
        }
        catch (Exception e) {
            ModCyclic.LOGGER.error("Error trying to detect volume of sound " + sound, e);
        }
    }
}

