/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.miner;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.miner.ContainerMiner;
import com.lothrazar.cyclic.capabilities.block.CustomEnergyStorage;
import com.lothrazar.cyclic.data.DataTags;
import com.lothrazar.cyclic.data.PreviewOutlineType;
import com.lothrazar.cyclic.item.datacard.BlockStateMatcher;
import com.lothrazar.cyclic.item.datacard.BlockstateCard;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.ShapeUtil;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileMiner
extends TileBlockEntityCyclic
implements MenuProvider {
    public static ForgeConfigSpec.IntValue POWERCONF;
    private int shapeIndex = 0;
    static final int SLOT_TOOL = 0;
    static final int SLOT_FILTER = 1;
    static final int MAX_HEIGHT = 64;
    public static final int MAX_SIZE = 12;
    private int height = 32;
    private int radius = 5;
    static final int MAX = 64000;
    CustomEnergyStorage energy = new CustomEnergyStorage(64000, 64000);
    ItemStackHandler inventory = new ItemStackHandler(2){

        public ItemStack getStackInSlot(int slot) {
            if (slot < 0 || slot >= this.stacks.size()) {
                return ItemStack.f_41583_;
            }
            return super.getStackInSlot(slot);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return slot != 1 || stack.m_41720_() == ItemRegistry.STATECARD.get();
        }
    };
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    private WeakReference<FakePlayer> fakePlayer;
    private boolean isCurrentlyMining;
    private float curBlockDamage;
    private BlockPos targetPos = BlockPos.f_121853_;
    private boolean directionIsUp = false;

    public TileMiner(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.MINER.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileMiner e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileMiner e) {
        e.tick();
    }

    public AABB getRenderBoundingBox() {
        return BlockEntity.INFINITE_EXTENT_AABB;
    }

    public Component m_5446_() {
        return ((Block)BlockRegistry.MINER.get()).m_49954_();
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerMiner(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public void invalidateCaps() {
        this.energyCap.invalidate();
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY && (Integer)POWERCONF.get() > 0) {
            return this.energyCap.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.radius = tag.m_128451_("size");
        this.height = tag.m_128451_("height");
        this.isCurrentlyMining = tag.m_128471_("isCurrentlyMining");
        this.directionIsUp = tag.m_128471_("directionIsUp");
        this.energy.deserializeNBT((Tag)tag.m_128469_("energy"));
        this.inventory.deserializeNBT(tag.m_128469_("inv"));
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128405_("size", this.radius);
        tag.m_128405_("height", this.height);
        tag.m_128379_("isCurrentlyMining", this.isCurrentlyMining);
        tag.m_128379_("directionIsUp", this.directionIsUp);
        tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
        tag.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        super.m_183515_(tag);
    }

    public void tick() {
        this.syncEnergy();
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        if (this.f_58857_ instanceof ServerLevel && this.fakePlayer == null) {
            this.fakePlayer = this.setupBeforeTrigger((ServerLevel)this.f_58857_, "miner");
        }
        try {
            TileBlockEntityCyclic.tryEquipItem(this.inventoryCap, this.fakePlayer, 0, InteractionHand.MAIN_HAND);
            List<BlockPos> shape = this.getShape();
            if (shape.size() == 0) {
                return;
            }
            this.setLitProperty(true);
            this.updateMiningProgress(shape);
        }
        catch (Exception e) {
            ModCyclic.LOGGER.error("Miner action error", e);
        }
    }

    private boolean updateMiningProgress(List<BlockPos> shape) {
        if (this.fakePlayer == null) {
            return false;
        }
        if (this.isTargetValid()) {
            this.isCurrentlyMining = true;
        } else {
            this.updateTargetPos(shape);
            this.resetProgress();
        }
        Integer cost = (Integer)POWERCONF.get();
        if (this.energy.getEnergyStored() < cost && cost > 0) {
            return false;
        }
        if (this.isCurrentlyMining) {
            BlockState targetState = this.f_58857_.m_8055_(this.targetPos);
            float relative = targetState.m_60625_((Player)this.fakePlayer.get(), (BlockGetter)this.f_58857_, this.targetPos);
            this.curBlockDamage += relative;
            if (this.curBlockDamage >= 1.0f || relative == 0.0f) {
                boolean harvested = ((FakePlayer)this.fakePlayer.get()).f_8941_.m_9280_(this.targetPos);
                if (!harvested) {
                    harvested = this.f_58857_.m_8055_(this.targetPos).onDestroyedByPlayer(this.f_58857_, this.f_58858_, (Player)this.fakePlayer.get(), true, this.f_58857_.m_6425_(this.f_58858_));
                }
                if (harvested) {
                    this.energy.extractEnergy(cost, false);
                    this.resetProgress();
                } else {
                    this.f_58857_.m_6801_(((FakePlayer)this.fakePlayer.get()).m_20148_().hashCode(), this.targetPos, (int)(this.curBlockDamage * 10.0f) - 1);
                }
            }
        } else {
            this.f_58857_.m_6801_(((FakePlayer)this.fakePlayer.get()).m_20148_().hashCode(), this.targetPos, (int)(this.curBlockDamage * 10.0f) - 1);
        }
        return false;
    }

    private boolean isTargetValid() {
        if (this.targetPos == null || this.f_58857_.m_46859_(this.targetPos) || this.fakePlayer == null) {
            return false;
        }
        BlockState targetState = this.f_58857_.m_8055_(this.targetPos);
        if (targetState.f_60599_ < 0.0f) {
            return false;
        }
        if (targetState.m_204336_(DataTags.MINER_IGNORED)) {
            ModCyclic.LOGGER.info("miner/ignored tag skips " + this.targetPos);
            return false;
        }
        if (targetState.m_60819_() != null && !targetState.m_60819_().m_76178_() && !targetState.m_61138_((Property)BlockStateProperties.f_61362_)) {
            return false;
        }
        if (!this.isValidFromDatacard(targetState)) {
            return false;
        }
        boolean canHarvest = targetState.canHarvestBlock((BlockGetter)this.f_58857_, this.targetPos, (Player)this.fakePlayer.get());
        if (!canHarvest) {
            // empty if block
        }
        return canHarvest;
    }

    private boolean isValidFromDatacard(BlockState targetState) {
        ItemStack filter = this.inventory.getStackInSlot(1);
        if (filter.m_41619_()) {
            return true;
        }
        for (BlockStateMatcher m : BlockstateCard.getSavedStates(filter)) {
            if (!m.doesMatch(targetState)) continue;
            return true;
        }
        return false;
    }

    private void updateTargetPos(List<BlockPos> shape) {
        ++this.shapeIndex;
        if (this.shapeIndex < 0 || this.shapeIndex >= shape.size()) {
            this.shapeIndex = 0;
        }
        this.targetPos = shape.get(this.shapeIndex);
    }

    private void resetProgress() {
        this.isCurrentlyMining = false;
        this.curBlockDamage = 0.0f;
        if (this.fakePlayer != null && this.targetPos != null) {
            this.m_58904_().m_6801_(((FakePlayer)this.fakePlayer.get()).m_20148_().hashCode(), this.targetPos, -1);
        }
    }

    private int heightWithDirection() {
        int diff;
        Direction blockFacing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        int n = diff = this.directionIsUp ? 1 : -1;
        if (blockFacing.m_122434_().m_122478_()) {
            diff = blockFacing == Direction.UP ? 1 : -1;
        }
        return diff * this.height;
    }

    public List<BlockPos> getShape() {
        BlockPos center = this.getFacingShapeCenter(this.radius);
        List<BlockPos> shape = ShapeUtil.squareHorizontalFull(center, this.radius);
        int heightWithDirection = this.heightWithDirection();
        if (heightWithDirection != 0) {
            shape = ShapeUtil.repeatShapeByHeight(shape, heightWithDirection);
        }
        return shape;
    }

    public List<BlockPos> getShapeHollow() {
        BlockPos center = this.getFacingShapeCenter(this.radius);
        List<BlockPos> shape = ShapeUtil.squareHorizontalHollow(center, this.radius);
        int heightWithDirection = this.heightWithDirection();
        if (heightWithDirection != 0) {
            shape = ShapeUtil.repeatShapeByHeight(shape, heightWithDirection);
        }
        if (this.targetPos != null) {
            shape.add(this.targetPos);
        }
        return shape;
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDER: {
                return this.render;
            }
            case DIRECTION: {
                return this.directionIsUp ? 1 : 0;
            }
            case HEIGHT: {
                return this.height;
            }
            case SIZE: {
                return this.radius;
            }
        }
        return 0;
    }

    @Override
    public void setField(int id, int value) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case RENDER: {
                this.render = value % PreviewOutlineType.values().length;
                break;
            }
            case DIRECTION: {
                this.directionIsUp = value == 1;
                break;
            }
            case HEIGHT: {
                this.height = Math.min(value, 64);
                break;
            }
            case SIZE: {
                this.radius = Math.min(value, 12);
            }
        }
    }

    static enum Fields {
        REDSTONE,
        RENDER,
        SIZE,
        HEIGHT,
        DIRECTION;

    }
}

