/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.bedrock;

import com.lothrazar.cyclic.block.BlockCyclic;
import com.lothrazar.cyclic.util.ParticleUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class UnbreakableBlock
extends BlockCyclic {
    public static final BooleanProperty BREAKABLE = BooleanProperty.m_61465_((String)"breakable");

    public UnbreakableBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60913_(50.0f, 1200.0f));
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItemStack = player.m_21120_(hand);
        Item heldItem = heldItemStack.m_41720_();
        if (state.m_61138_((Property)BREAKABLE) && hand == InteractionHand.MAIN_HAND && heldItem == Items.f_42451_ || heldItem == Items.f_41978_ || heldItem == Items.f_42153_) {
            this.toggle(state, world, pos);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    private void toggle(BlockState state, Level world, BlockPos pos) {
        this.setBreakable(state, world, pos, (Boolean)state.m_61143_((Property)BREAKABLE) == false);
    }

    private void setBreakable(BlockState state, Level world, BlockPos pos, boolean isBreakable) {
        boolean oldBreakable = (Boolean)state.m_61143_((Property)BREAKABLE);
        world.m_46597_(pos, (BlockState)state.m_61124_((Property)BREAKABLE, (Comparable)Boolean.valueOf(isBreakable)));
        if (world.f_46443_ && oldBreakable != isBreakable) {
            ParticleUtil.spawnParticle(world, (ParticleOptions)DustParticleOptions.f_123656_, pos, 5);
        }
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockState neighborState = worldIn.m_8055_(fromPos);
        if (!isMoving && neighborState.m_61138_((Property)BREAKABLE) && state.m_61138_((Property)BREAKABLE)) {
            this.setBreakable(state, worldIn, pos, (Boolean)neighborState.m_61143_((Property)BREAKABLE));
        }
    }

    public float m_5880_(BlockState state, Player player, BlockGetter worldIn, BlockPos pos) {
        return state.m_61138_((Property)BREAKABLE) && (Boolean)state.m_61143_((Property)BREAKABLE) == false ? 0.0f : super.m_5880_(state, player, worldIn, pos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BREAKABLE});
    }
}

