/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.entity;

import com.mojang.math.Vector3f;
import java.util.Optional;
import java.util.UUID;
import mekanism.additions.common.registries.AdditionsEntityTypes;
import mekanism.additions.common.registries.AdditionsItems;
import mekanism.additions.common.registries.AdditionsSounds;
import mekanism.api.text.EnumColor;
import mekanism.common.network.BasePacketHandler;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityBalloon
extends Entity
implements IEntityAdditionalSpawnData {
    private static final EntityDataAccessor<Byte> IS_LATCHED = SynchedEntityData.m_135353_(EntityBalloon.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> LATCHED_X = SynchedEntityData.m_135353_(EntityBalloon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LATCHED_Y = SynchedEntityData.m_135353_(EntityBalloon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LATCHED_Z = SynchedEntityData.m_135353_(EntityBalloon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LATCHED_ID = SynchedEntityData.m_135353_(EntityBalloon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final double OFFSET = -0.275;
    private EnumColor color = EnumColor.DARK_BLUE;
    private BlockPos latched;
    public LivingEntity latchedEntity;
    private boolean hasCachedEntity;
    private UUID cachedEntityUUID;

    public EntityBalloon(EntityType<EntityBalloon> type, Level world) {
        super(type, world);
        this.f_19811_ = true;
        this.f_19850_ = true;
        this.m_6034_(this.m_20185_() + 0.5, this.m_20186_() + 3.0, this.m_20189_() + 0.5);
        this.m_20334_(this.m_20184_().m_7096_(), 0.04, this.m_20184_().m_7094_());
        this.f_19804_.m_135372_(IS_LATCHED, (Object)0);
        this.f_19804_.m_135372_(LATCHED_X, (Object)0);
        this.f_19804_.m_135372_(LATCHED_Y, (Object)0);
        this.f_19804_.m_135372_(LATCHED_Z, (Object)0);
        this.f_19804_.m_135372_(LATCHED_ID, (Object)-1);
    }

    @Nullable
    public static EntityBalloon create(Level world, double x, double y, double z, EnumColor c) {
        EntityBalloon balloon = (EntityBalloon)((EntityType)AdditionsEntityTypes.BALLOON.get()).m_20615_(world);
        if (balloon == null) {
            return null;
        }
        balloon.m_6034_(x + 0.5, y + 3.0, z + 0.5);
        balloon.f_19854_ = balloon.m_20185_();
        balloon.f_19855_ = balloon.m_20186_();
        balloon.f_19856_ = balloon.m_20189_();
        balloon.color = c;
        return balloon;
    }

    @Nullable
    public static EntityBalloon create(LivingEntity entity, EnumColor c) {
        EntityBalloon balloon = (EntityBalloon)((EntityType)AdditionsEntityTypes.BALLOON.get()).m_20615_(entity.f_19853_);
        if (balloon == null) {
            return null;
        }
        balloon.latchedEntity = entity;
        float height = balloon.latchedEntity.m_6972_((Pose)balloon.latchedEntity.m_20089_()).f_20378_;
        balloon.m_6034_(balloon.latchedEntity.m_20185_(), balloon.latchedEntity.m_20186_() + (double)height + (double)1.7f, balloon.latchedEntity.m_20189_());
        balloon.f_19854_ = balloon.m_20185_();
        balloon.f_19855_ = balloon.m_20186_();
        balloon.f_19856_ = balloon.m_20189_();
        balloon.color = c;
        balloon.f_19804_.m_135381_(IS_LATCHED, (Object)2);
        balloon.f_19804_.m_135381_(LATCHED_ID, (Object)entity.m_19879_());
        return balloon;
    }

    @Nullable
    public static EntityBalloon create(Level world, BlockPos pos, EnumColor c) {
        EntityBalloon balloon = (EntityBalloon)((EntityType)AdditionsEntityTypes.BALLOON.get()).m_20615_(world);
        if (balloon == null) {
            return null;
        }
        balloon.latched = pos;
        balloon.m_6034_((float)balloon.latched.m_123341_() + 0.5f, (float)balloon.latched.m_123342_() + 1.8f, (float)balloon.latched.m_123343_() + 0.5f);
        balloon.f_19854_ = balloon.m_20185_();
        balloon.f_19855_ = balloon.m_20186_();
        balloon.f_19856_ = balloon.m_20189_();
        balloon.color = c;
        balloon.f_19804_.m_135381_(IS_LATCHED, (Object)1);
        balloon.f_19804_.m_135381_(LATCHED_X, (Object)balloon.latched.m_123341_());
        balloon.f_19804_.m_135381_(LATCHED_Y, (Object)balloon.latched.m_123342_());
        balloon.f_19804_.m_135381_(LATCHED_Z, (Object)balloon.latched.m_123343_());
        return balloon;
    }

    public EnumColor getColor() {
        return this.color;
    }

    public void m_8119_() {
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        if (this.m_20186_() >= (double)this.f_19853_.m_151558_()) {
            this.pop();
            return;
        }
        if (this.f_19853_.f_46443_) {
            this.latched = (Byte)this.f_19804_.m_135370_(IS_LATCHED) == 1 ? new BlockPos(((Integer)this.f_19804_.m_135370_(LATCHED_X)).intValue(), ((Integer)this.f_19804_.m_135370_(LATCHED_Y)).intValue(), ((Integer)this.f_19804_.m_135370_(LATCHED_Z)).intValue()) : null;
            this.latchedEntity = (Byte)this.f_19804_.m_135370_(IS_LATCHED) == 2 ? (LivingEntity)this.f_19853_.m_6815_(((Integer)this.f_19804_.m_135370_(LATCHED_ID)).intValue()) : null;
        } else {
            if (this.hasCachedEntity) {
                ServerLevel serverLevel;
                Entity entity;
                Level level = this.f_19853_;
                if (level instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).m_8791_(this.cachedEntityUUID)) instanceof LivingEntity) {
                    this.latchedEntity = (LivingEntity)entity;
                }
                this.cachedEntityUUID = null;
                this.hasCachedEntity = false;
            }
            if (this.f_19797_ == 1) {
                byte isLatched = this.latched != null ? (byte)1 : (this.latchedEntity != null ? (byte)2 : 0);
                this.f_19804_.m_135381_(IS_LATCHED, (Object)isLatched);
                this.f_19804_.m_135381_(LATCHED_X, (Object)(this.latched == null ? 0 : this.latched.m_123341_()));
                this.f_19804_.m_135381_(LATCHED_Y, (Object)(this.latched == null ? 0 : this.latched.m_123342_()));
                this.f_19804_.m_135381_(LATCHED_Z, (Object)(this.latched == null ? 0 : this.latched.m_123343_()));
                this.f_19804_.m_135381_(LATCHED_ID, (Object)(this.latchedEntity == null ? -1 : this.latchedEntity.m_19879_()));
            }
        }
        if (!this.f_19853_.f_46443_) {
            Optional blockState;
            if (this.latched != null && (blockState = WorldUtils.getBlockState((BlockGetter)this.f_19853_, (BlockPos)this.latched)).isPresent() && ((BlockState)blockState.get()).m_60795_()) {
                this.latched = null;
                this.f_19804_.m_135381_(IS_LATCHED, (Object)0);
            }
            if (this.latchedEntity != null && !this.latchedEntity.m_6084_()) {
                this.latchedEntity = null;
                this.f_19804_.m_135381_(IS_LATCHED, (Object)0);
            }
        }
        if (!this.isLatched()) {
            Vec3 motion = this.m_20184_();
            this.m_20334_(motion.m_7096_(), Math.min(motion.m_7098_() * (double)1.02f, (double)0.2f), motion.m_7094_());
            this.m_6478_(MoverType.SELF, this.m_20184_());
            motion = this.m_20184_();
            motion = motion.m_82542_(0.98, 0.0, 0.98);
            if (this.f_19861_) {
                motion = motion.m_82542_(0.7, 0.0, 0.7);
            }
            if (motion.m_7098_() == 0.0) {
                motion = new Vec3(motion.m_7096_(), 0.04, motion.m_7094_());
            }
            this.m_20256_(motion);
        } else if (this.latched != null) {
            this.m_20334_(0.0, 0.0, 0.0);
        } else if (this.latchedEntity != null && this.latchedEntity.m_21223_() > 0.0f) {
            int floor = this.getFloor(this.latchedEntity);
            Vec3 motion = this.latchedEntity.m_20184_();
            if (this.latchedEntity.m_20186_() - (double)(floor + 1) < -0.1) {
                this.latchedEntity.m_20334_(motion.m_7096_(), Math.max(0.04, motion.m_7098_() * 1.015), motion.m_7094_());
                this.latchedEntity.f_19812_ = true;
            } else if (this.latchedEntity.m_20186_() - (double)(floor + 1) > 0.1) {
                this.latchedEntity.m_20334_(motion.m_7096_(), Math.min(-0.04, motion.m_7098_() * 1.015), motion.m_7094_());
                this.latchedEntity.f_19812_ = true;
            } else {
                this.latchedEntity.m_20334_(motion.m_7096_(), 0.0, motion.m_7094_());
            }
            this.m_6034_(this.latchedEntity.m_20185_(), this.latchedEntity.m_20186_() + this.getAddedHeight(), this.latchedEntity.m_20189_());
        }
    }

    public double getAddedHeight() {
        return (double)this.latchedEntity.m_6972_((Pose)this.latchedEntity.m_20089_()).f_20378_ + 0.8;
    }

    private int getFloor(LivingEntity entity) {
        BlockPos pos;
        BlockPos posi = pos = new BlockPos(entity.m_20182_());
        while (posi.m_123342_() > 0) {
            if (posi.m_123342_() < this.f_19853_.m_151558_() && !this.f_19853_.m_46859_(posi)) {
                return posi.m_123342_() + 1 + (entity instanceof Player ? 1 : 0);
            }
            posi = posi.m_7495_();
        }
        return -1;
    }

    private void pop() {
        this.m_5496_((SoundEvent)AdditionsSounds.POP.get(), 1.0f, 1.0f);
        if (!this.f_19853_.f_46443_) {
            Vector3f col = new Vector3f(this.color.getColor(0), this.color.getColor(1), this.color.getColor(2));
            DustParticleOptions redstoneParticleData = new DustParticleOptions(col, 1.0f);
            Vec3 center = this.m_20191_().m_82399_();
            for (int i = 0; i < 10; ++i) {
                ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)redstoneParticleData, center.m_7096_() + 0.6 * (double)this.f_19796_.m_188501_() - 0.3, center.m_7098_() + 0.6 * (double)this.f_19796_.m_188501_() - 0.3, center.m_7094_() + 0.6 * (double)this.f_19796_.m_188501_() - 0.3, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        this.m_146870_();
    }

    public boolean m_6094_() {
        return this.latched == null;
    }

    public boolean m_6087_() {
        return this.m_6084_();
    }

    @NotNull
    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(@NotNull CompoundTag nbtTags) {
        NBTUtils.setEnumIfPresent((CompoundTag)nbtTags, (String)"color", EnumColor::byIndexStatic, color -> {
            this.color = color;
        });
        NBTUtils.setBlockPosIfPresent((CompoundTag)nbtTags, (String)"latched", pos -> {
            this.latched = pos;
        });
        NBTUtils.setUUIDIfPresent((CompoundTag)nbtTags, (String)"owner", uuid -> {
            this.hasCachedEntity = true;
            this.cachedEntityUUID = uuid;
        });
    }

    protected void m_7380_(@NotNull CompoundTag nbtTags) {
        NBTUtils.writeEnum((CompoundTag)nbtTags, (String)"color", (Enum)this.color);
        if (this.latched != null) {
            nbtTags.m_128365_("latched", (Tag)NbtUtils.m_129224_((BlockPos)this.latched));
        }
        if (this.latchedEntity != null) {
            nbtTags.m_128362_("owner", this.latchedEntity.m_20148_());
        }
    }

    public boolean m_7313_(@NotNull Entity entity) {
        this.pop();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            CriteriaTriggers.f_10568_.m_48104_(player, (Entity)this, DamageSource.m_19344_((Player)player));
        }
        return true;
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf data) {
        BasePacketHandler.writeVector3d((FriendlyByteBuf)data, (Vec3)this.m_20182_());
        data.m_130068_((Enum)this.color);
        if (this.latched != null) {
            data.writeByte(1);
            data.m_130064_(this.latched);
        } else if (this.latchedEntity != null) {
            data.writeByte(2);
            data.m_130130_(this.latchedEntity.m_19879_());
        } else {
            data.writeByte(0);
        }
    }

    public void readSpawnData(FriendlyByteBuf data) {
        this.m_146884_(BasePacketHandler.readVector3d((FriendlyByteBuf)data));
        this.color = (EnumColor)data.m_130066_(EnumColor.class);
        byte type = data.readByte();
        if (type == 1) {
            this.latched = data.m_130135_();
        } else if (type == 2) {
            this.latchedEntity = (LivingEntity)this.f_19853_.m_6815_(data.m_130242_());
        } else {
            this.latched = null;
        }
    }

    public void m_142687_(@NotNull Entity.RemovalReason reason) {
        super.m_142687_(reason);
        if (this.latchedEntity != null) {
            this.latchedEntity.f_19812_ = false;
        }
    }

    public boolean m_6783_(double dist) {
        return dist <= 64.0;
    }

    public boolean m_6000_(double x, double y, double z) {
        return true;
    }

    public boolean m_6469_(@NotNull DamageSource dmgSource, float damage) {
        if (this.m_6673_(dmgSource)) {
            return false;
        }
        this.m_5834_();
        if (dmgSource != DamageSource.f_19319_ && dmgSource != DamageSource.f_19312_ && dmgSource != DamageSource.f_19315_) {
            this.pop();
            Entity entity = dmgSource.m_7639_();
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                CriteriaTriggers.f_10568_.m_48104_(player, (Entity)this, dmgSource);
            }
            return true;
        }
        return false;
    }

    public boolean isLatched() {
        if (this.f_19853_.f_46443_) {
            return (Byte)this.f_19804_.m_135370_(IS_LATCHED) > 0;
        }
        return this.latched != null || this.latchedEntity != null;
    }

    public boolean isLatchedToEntity() {
        return (Byte)this.f_19804_.m_135370_(IS_LATCHED) == 2 && this.latchedEntity != null;
    }

    protected float m_6380_(@NotNull Pose pose, @NotNull EntityDimensions size) {
        return (float)((double)size.f_20378_ - -0.275);
    }

    @NotNull
    protected AABB m_20217_(@NotNull Pose pose) {
        EntityDimensions size = this.m_6972_(pose);
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        float f = size.f_20377_ / 2.0f;
        double posY = y - -0.275;
        return new AABB(new Vec3(x - (double)f, posY, z - (double)f), new Vec3(x + (double)f, posY + (double)size.f_20378_, z + (double)f));
    }

    @NotNull
    protected AABB m_142242_() {
        return this.m_20217_(Pose.STANDING);
    }

    public void m_6210_() {
    }

    public ItemStack getPickedResult(HitResult target) {
        return AdditionsItems.BALLOONS.get(this.color).getItemStack();
    }
}

