/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.wand.undo;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.BlockHitResult;
import thetadev.constructionwand.basics.WandUtil;
import thetadev.constructionwand.basics.option.WandOptions;
import thetadev.constructionwand.wand.WandItemUseContext;
import thetadev.constructionwand.wand.undo.ISnapshot;

public class PlaceSnapshot
implements ISnapshot {
    private BlockState block;
    private final BlockPos pos;
    private final BlockItem item;
    private final BlockState supportingBlock;
    private final boolean targetMode;

    public PlaceSnapshot(BlockState block, BlockPos pos, BlockItem item, BlockState supportingBlock, boolean targetMode) {
        this.block = block;
        this.pos = pos;
        this.item = item;
        this.supportingBlock = supportingBlock;
        this.targetMode = targetMode;
    }

    public static PlaceSnapshot get(Level world, Player player, BlockHitResult rayTraceResult, BlockPos pos, BlockItem item, @Nullable BlockState supportingBlock, @Nullable WandOptions options) {
        boolean targetMode = options != null && supportingBlock != null && options.direction.get() == WandOptions.DIRECTION.TARGET;
        BlockState blockState = PlaceSnapshot.getPlaceBlockstate(world, player, rayTraceResult, pos, item, supportingBlock, targetMode);
        if (blockState == null) {
            return null;
        }
        return new PlaceSnapshot(blockState, pos, item, supportingBlock, targetMode);
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public BlockState getBlockState() {
        return this.block;
    }

    @Override
    public ItemStack getRequiredItems() {
        return new ItemStack((ItemLike)this.item);
    }

    @Override
    public boolean execute(Level world, Player player, BlockHitResult rayTraceResult) {
        this.block = PlaceSnapshot.getPlaceBlockstate(world, player, rayTraceResult, this.pos, this.item, this.supportingBlock, this.targetMode);
        if (this.block == null) {
            return false;
        }
        return WandUtil.placeBlock(world, player, this.block, this.pos, this.item);
    }

    @Override
    public boolean canRestore(Level world, Player player) {
        return true;
    }

    @Override
    public boolean restore(Level world, Player player) {
        return WandUtil.removeBlock(world, player, this.block, this.pos);
    }

    @Override
    public void forceRestore(Level world) {
        world.m_7471_(this.pos, false);
    }

    @Nullable
    private static BlockState getPlaceBlockstate(Level world, Player player, BlockHitResult rayTraceResult, BlockPos pos, BlockItem item, @Nullable BlockState supportingBlock, boolean targetMode) {
        WandItemUseContext ctx = new WandItemUseContext(world, player, rayTraceResult, pos, item);
        if (!ctx.m_7059_()) {
            return null;
        }
        BlockState blockState = item.m_40614_().m_5573_((BlockPlaceContext)ctx);
        if (blockState == null) {
            return null;
        }
        if (!WandUtil.isTEAllowed(blockState)) {
            return null;
        }
        if (WandUtil.entitiesCollidingWithBlock(world, blockState, pos)) {
            return null;
        }
        if ((blockState = Block.m_49931_((BlockState)blockState, (LevelAccessor)world, (BlockPos)pos)).m_60734_() == Blocks.f_50016_ || !blockState.m_60710_((LevelReader)world, pos)) {
            return null;
        }
        if (targetMode && supportingBlock != null) {
            SlabType slabType;
            for (Property property : new Property[]{BlockStateProperties.f_61374_, BlockStateProperties.f_61372_, BlockStateProperties.f_61373_, BlockStateProperties.f_61390_, BlockStateProperties.f_61365_, BlockStateProperties.f_61402_, BlockStateProperties.f_61398_}) {
                if (!supportingBlock.m_61138_(property) || !blockState.m_61138_(property)) continue;
                blockState = (BlockState)blockState.m_61124_(property, supportingBlock.m_61143_(property));
            }
            if (supportingBlock.m_61138_((Property)BlockStateProperties.f_61397_) && blockState.m_61138_((Property)BlockStateProperties.f_61397_) && (slabType = (SlabType)supportingBlock.m_61143_((Property)BlockStateProperties.f_61397_)) != SlabType.DOUBLE) {
                blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61397_, (Comparable)slabType);
            }
        }
        return blockState;
    }
}

