/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.customvillagertrades.mixin;

import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.WanderingTrader;
import org.apache.commons.lang3.ArrayUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import uk.co.dotcode.customvillagertrades.ConfigHandler;
import uk.co.dotcode.customvillagertrades.TradeUtil;

@Mixin(value={WanderingTrader.class}, priority=9999)
public abstract class MixinWandererTrades {
    @Inject(method={"updateTrades"}, at={@At(value="RETURN")})
    private void addWanderingTraderTrades(CallbackInfo ci) {
        boolean shouldRemoveAll;
        if (ConfigHandler.registeredCustomWandererTrades != null && ConfigHandler.registeredCustomWandererTrades.size() > 0 && (shouldRemoveAll = ConfigHandler.customWandererTrades.get((Object)"wanderer").removeOtherTrades)) {
            int maxCommonTrades = ConfigHandler.customWandererTrades.get((Object)"wanderer").maxCommonTrades;
            int maxRareTrades = ConfigHandler.customWandererTrades.get((Object)"wanderer").maxRareTrades;
            VillagerTrades.ItemListing[] commonTrades = ConfigHandler.registeredCustomWandererTrades.get(1);
            VillagerTrades.ItemListing[] rareTrades = ConfigHandler.registeredCustomWandererTrades.get(2);
            if (commonTrades != null && rareTrades != null) {
                ((WanderingTrader)this).m_6616_().clear();
                TradeUtil.addOffersFromItemListings((AbstractVillager)((WanderingTrader)this), commonTrades, maxCommonTrades);
                TradeUtil.addOffersFromItemListings((AbstractVillager)((WanderingTrader)this), rareTrades, maxRareTrades);
            }
        }
    }

    @ModifyVariable(method={"updateTrades()V"}, at=@At(value="STORE"), ordinal=0)
    private VillagerTrades.ItemListing[] injectedCommonTrades(VillagerTrades.ItemListing[] originalEntries) {
        if (ConfigHandler.registeredCustomWandererTrades != null && ConfigHandler.registeredCustomWandererTrades.size() > 0) {
            Object[] commonTrades = ConfigHandler.registeredCustomWandererTrades.get(1);
            VillagerTrades.ItemListing[] mergedTrades = (VillagerTrades.ItemListing[])ArrayUtils.addAll((Object[])originalEntries, (Object[])commonTrades);
            return mergedTrades;
        }
        return originalEntries;
    }

    @ModifyVariable(method={"updateTrades()V"}, at=@At(value="STORE"), ordinal=1)
    private VillagerTrades.ItemListing[] injectedRareTrades(VillagerTrades.ItemListing[] originalEntries) {
        if (ConfigHandler.registeredCustomWandererTrades != null && ConfigHandler.registeredCustomWandererTrades.size() > 0) {
            Object[] rareTrades = ConfigHandler.registeredCustomWandererTrades.get(2);
            VillagerTrades.ItemListing[] mergedTrades = (VillagerTrades.ItemListing[])ArrayUtils.addAll((Object[])originalEntries, (Object[])rareTrades);
            return mergedTrades;
        }
        return originalEntries;
    }
}

