/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.module;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.handler.EntityAttributeHandler;
import vazkii.quark.base.handler.advancement.QuarkAdvancementHandler;
import vazkii.quark.base.handler.advancement.mod.MonsterHunterModifier;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.type.CompoundBiomeConfig;
import vazkii.quark.base.module.config.type.CostSensitiveEntitySpawnConfig;
import vazkii.quark.base.module.config.type.EntitySpawnConfig;
import vazkii.quark.base.module.hint.Hint;
import vazkii.quark.base.world.EntitySpawnHandler;
import vazkii.quark.content.mobs.client.render.entity.SoulBeadRenderer;
import vazkii.quark.content.mobs.client.render.entity.WraithRenderer;
import vazkii.quark.content.mobs.entity.SoulBead;
import vazkii.quark.content.mobs.entity.Wraith;
import vazkii.quark.content.mobs.item.SoulBeadItem;

@LoadModule(category=ModuleCategory.MOBS)
public class WraithModule
extends QuarkModule {
    public static EntityType<Wraith> wraithType;
    public static EntityType<SoulBead> soulBeadType;
    @Config(description="List of sound sets to use with wraiths.\nThree sounds must be provided per entry, separated by | (in the format idle|hurt|death). Leave blank for no sound (i.e. if a mob has no ambient noise)")
    private static List<String> wraithSounds;
    @Config
    public static EntitySpawnConfig spawnConfig;
    public static TagKey<Block> wraithSpawnableTag;
    public static TagKey<Structure> soulBeadTargetTag;
    public static List<String> validWraithSounds;
    @Hint
    Item soul_bead;

    @Override
    public void register() {
        this.soul_bead = new SoulBeadItem(this);
        wraithType = EntityType.Builder.m_20704_(Wraith::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.95f).m_20702_(8).m_20719_().setCustomClientFactory((spawnEntity, world) -> new Wraith((EntityType<? extends Wraith>)wraithType, (Level)world)).m_20712_("wraith");
        RegistryHelper.register(wraithType, (String)"wraith", (ResourceKey)Registry.f_122903_);
        soulBeadType = EntityType.Builder.m_20704_(SoulBead::new, (MobCategory)MobCategory.MISC).m_20699_(0.0f, 0.0f).m_20702_(4).m_20717_(10).m_20719_().setCustomClientFactory((spawnEntity, world) -> new SoulBead((EntityType<? extends SoulBead>)soulBeadType, (Level)world)).m_20712_("soul_bead");
        RegistryHelper.register(soulBeadType, (String)"soul_bead", (ResourceKey)Registry.f_122903_);
        EntitySpawnHandler.registerSpawn(wraithType, MobCategory.MONSTER, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, spawnConfig);
        EntitySpawnHandler.addEgg(this, wraithType, 0xECECEC, 0xBDBDBD, spawnConfig);
        EntityAttributeHandler.put(wraithType, Wraith::registerAttributes);
        QuarkAdvancementHandler.addModifier(new MonsterHunterModifier(this, (Set<EntityType<?>>)ImmutableSet.of(wraithType)));
    }

    @Override
    public void setup() {
        wraithSpawnableTag = BlockTags.create((ResourceLocation)new ResourceLocation("quark", "wraith_spawnable"));
        soulBeadTargetTag = TagKey.m_203882_((ResourceKey)Registry.f_235725_, (ResourceLocation)new ResourceLocation("quark", "soul_bead_target"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        EntityRenderers.m_174036_(wraithType, WraithRenderer::new);
        EntityRenderers.m_174036_(soulBeadType, SoulBeadRenderer::new);
    }

    @Override
    public void configChanged() {
        validWraithSounds = wraithSounds.stream().filter(s -> s.split("\\|").length == 3).collect(Collectors.toList());
    }

    static {
        wraithSounds = Lists.newArrayList((Object[])new String[]{"entity.sheep.ambient|entity.sheep.hurt|entity.sheep.death", "entity.cow.ambient|entity.cow.hurt|entity.cow.death", "entity.pig.ambient|entity.pig.hurt|entity.pig.death", "entity.chicken.ambient|entity.chicken.hurt|entity.chicken.death", "entity.horse.ambient|entity.horse.hurt|entity.horse.death", "entity.cat.ambient|entity.cat.hurt|entity.cat.death", "entity.wolf.ambient|entity.wolf.hurt|entity.wolf.death", "entity.villager.ambient|entity.villager.hurt|entity.villager.death", "entity.polar_bear.ambient|entity.polar_bear.hurt|entity.polar_bear.death", "entity.zombie.ambient|entity.zombie.hurt|entity.zombie.death", "entity.skeleton.ambient|entity.skeleton.hurt|entity.skeleton.death", "entity.spider.ambient|entity.spider.hurt|entity.spider.death", "|entity.creeper.hurt|entity.creeper.death", "entity.endermen.ambient|entity.endermen.hurt|entity.endermen.death", "entity.zombie_pig.ambient|entity.zombie_pig.hurt|entity.zombie_pig.death", "entity.witch.ambient|entity.witch.hurt|entity.witch.death", "entity.blaze.ambient|entity.blaze.hurt|entity.blaze.death", "entity.llama.ambient|entity.llama.hurt|entity.llama.death", "|quark:entity.stoneling.cry|quark:entity.stoneling.die", "quark:entity.frog.idle|quark:entity.frog.hurt|quark:entity.frog.die"});
        spawnConfig = new CostSensitiveEntitySpawnConfig(5, 1, 3, 0.7, 0.15, CompoundBiomeConfig.fromBiomeReslocs(false, "minecraft:soul_sand_valley"));
    }
}

