/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen;

import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import wile.redstonepen.ModRedstonePen;
import wile.redstonepen.blocks.BasicButton;
import wile.redstonepen.blocks.BasicLever;
import wile.redstonepen.blocks.CircuitComponents;
import wile.redstonepen.blocks.ControlBox;
import wile.redstonepen.blocks.RedstoneTrack;
import wile.redstonepen.items.RedstonePenItem;
import wile.redstonepen.libmc.Auxiliaries;
import wile.redstonepen.libmc.ExtendedShapelessRecipe;
import wile.redstonepen.libmc.Registries;

public class ModContent {
    public static void init() {
        ModContent.initBlocks();
        ModContent.initItems();
        Registries.addRecipeSerializer("crafting_extended_shapeless", () -> ExtendedShapelessRecipe.SERIALIZER);
    }

    public static void initBlocks() {
        Registries.addBlock("track", () -> new RedstoneTrack.RedstoneTrackBlock(0L, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60966_().m_60988_().m_60977_()), RedstoneTrack.TrackBlockEntity::new);
        Registries.addBlock("relay", () -> new CircuitComponents.RelayBlock(1L, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60966_(), Auxiliaries.getPixeledAABB(5.0, 0.0, 0.0, 11.0, 1.0, 16.0)), CircuitComponents.DirectedComponentBlockItem::new);
        Registries.addBlock("inverted_relay", () -> new CircuitComponents.InvertedRelayBlock(1L, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60966_(), Auxiliaries.getPixeledAABB(5.0, 0.0, 0.0, 11.0, 1.0, 16.0)), CircuitComponents.DirectedComponentBlockItem::new);
        Registries.addBlock("bistable_relay", () -> new CircuitComponents.BistableRelayBlock(1L, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60966_(), Auxiliaries.getPixeledAABB(5.0, 0.0, 0.0, 11.0, 1.0, 16.0)), CircuitComponents.DirectedComponentBlockItem::new);
        Registries.addBlock("pulse_relay", () -> new CircuitComponents.PulseRelayBlock(1L, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60966_(), Auxiliaries.getPixeledAABB(5.0, 0.0, 0.0, 11.0, 1.0, 16.0)), CircuitComponents.DirectedComponentBlockItem::new);
        Registries.addBlock("bridge_relay", () -> new CircuitComponents.BridgeRelayBlock(1L, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60966_(), Auxiliaries.getPixeledAABB(5.0, 0.0, 0.0, 11.0, 1.0, 16.0)), CircuitComponents.DirectedComponentBlockItem::new);
        Registries.addBlock("control_box", () -> new ControlBox.ControlBoxBlock(1L, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60966_(), new AABB[]{Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 2.0, 16.0), Auxiliaries.getPixeledAABB(3.0, 1.0, 3.0, 13.0, 3.9, 13.0)}), CircuitComponents.DirectedComponentBlockItem::new, ControlBox.ControlBoxBlockEntity::new, ControlBox.ControlBoxUiContainer::new);
        Registries.addBlock("basic_lever", () -> new BasicLever.BasicLeverBlock(new BasicLever.BasicLeverBlock.Config(0.8f, 0.9f), BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60922_((s, w, p, b) -> false).m_60978_(0.3f).m_60918_(SoundType.f_56743_)));
        Registries.addBlock("basic_button", () -> new BasicButton.BasicButtonBlock(new BasicButton.BasicButtonBlock.Config(0.8f, 0.9f, 20), BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60922_((s, w, p, b) -> false).m_60978_(0.3f).m_60918_(SoundType.f_56743_)));
        Registries.addBlock("basic_pulse_button", () -> new BasicButton.BasicButtonBlock(new BasicButton.BasicButtonBlock.Config(0.8f, 0.9f, 2), BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60922_((s, w, p, b) -> false).m_60978_(0.3f).m_60918_(SoundType.f_56743_)));
    }

    public static void initItems() {
        Registries.addItem("quill", () -> new RedstonePenItem(new Item.Properties().m_41491_(ModRedstonePen.CREATIVE_MODE_TAB).m_41497_(Rarity.UNCOMMON).m_41487_(64).m_41499_(0)));
        Registries.addItem("pen", () -> new RedstonePenItem(new Item.Properties().m_41491_(ModRedstonePen.CREATIVE_MODE_TAB).m_41497_(Rarity.UNCOMMON).m_41487_(1).m_41499_(256)));
    }

    public static void initReferences(String registry_name) {
        switch (registry_name) {
            case "minecraft:block": {
                references.TRACK_BLOCK = (RedstoneTrack.RedstoneTrackBlock)Registries.getBlock("track");
                references.BRIDGE_RELAY_BLOCK = (CircuitComponents.BridgeRelayBlock)Registries.getBlock("bridge_relay");
                references.CONTROLBOX_BLOCK = (ControlBox.ControlBoxBlock)Registries.getBlock("control_box");
            }
        }
    }

    public static MenuType<?> getMenuTypeOfBlock(String block_name) {
        return Registries.getMenuTypeOfBlock(block_name);
    }

    public static MenuType<?> getMenuTypeOfBlock(Block block) {
        return Registries.getMenuTypeOfBlock(block);
    }

    public static BlockEntityType<?> getBlockEntityTypeOfBlock(String block_name) {
        return Registries.getBlockEntityTypeOfBlock(block_name);
    }

    public static BlockEntityType<?> getBlockEntityTypeOfBlock(Block block) {
        return Registries.getBlockEntityTypeOfBlock(block);
    }

    public static final class references {
        public static RedstoneTrack.RedstoneTrackBlock TRACK_BLOCK = null;
        public static CircuitComponents.BridgeRelayBlock BRIDGE_RELAY_BLOCK = null;
        public static ControlBox.ControlBoxBlock CONTROLBOX_BLOCK = null;
    }
}

