/*
 * Decompiled with CFR 0.152.
 */
package de.sarenor.arsinstrumentum.items.curios.armarium;

import de.sarenor.arsinstrumentum.items.curios.armarium.ArmariumSlot;
import de.sarenor.arsinstrumentum.items.curios.armarium.Slots;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ArmariumStorage {
    public static final String ARMARIUM_STORAGE_TAG_ID = "ars_instrumentum_armarium_storage_tag";
    public static final MutableComponent WILL_SWITCH_HOTBAR = Component.m_237115_((String)"instrumentum.armarium.hotbar_switch");
    public static final MutableComponent WONT_SWITCH_HOTBAR = Component.m_237115_((String)"instrumentum.armarium.hotbar_no_switch");
    private static final String CURRENT_SLOT = "current_slot";
    private static final String FLAVORTEXT = "flavortext";
    private static final String IS_HOTBAR_SWITCH = "is_hotbar_switch";
    private final Map<Slots, ArmariumSlot> armariumSlots = new HashMap<Slots, ArmariumSlot>();
    private final String flavorText;
    private Slots currentSlot;
    private ItemStack armarium;
    private boolean isHotbarSwitch;

    public ArmariumStorage(ItemStack armarium) {
        this(armarium.m_41784_());
        this.armarium = armarium;
    }

    private ArmariumStorage(CompoundTag itemTag) {
        CompoundTag tag = itemTag.m_128469_(ARMARIUM_STORAGE_TAG_ID);
        this.currentSlot = tag.m_128441_(CURRENT_SLOT) ? Slots.valueOf(tag.m_128461_(CURRENT_SLOT)) : Slots.SLOT_ONE;
        this.flavorText = tag.m_128461_(FLAVORTEXT);
        for (Slots slot : Slots.values()) {
            if (!tag.m_128441_(slot.name())) continue;
            this.armariumSlots.put(slot, ArmariumSlot.deserialize(tag.m_128469_(slot.name())));
        }
        this.isHotbarSwitch = tag.m_128441_(IS_HOTBAR_SWITCH) ? tag.m_128471_(IS_HOTBAR_SWITCH) : true;
    }

    public void switchIsHotbarSwitch(Player player) {
        this.isHotbarSwitch = !this.isHotbarSwitch;
        ArrayList itemStacksToDrop = new ArrayList();
        this.armariumSlots.forEach((slots, armariumSlot) -> {
            if (!slots.equals((Object)this.currentSlot)) {
                itemStacksToDrop.addAll(armariumSlot.getHotbar());
            }
            armariumSlot.setHotbar(Collections.emptyList());
        });
        itemStacksToDrop.forEach(itemStack -> this.spawnItem(player, (ItemStack)itemStack));
        this.writeArmariumStorageToArmariumItem();
    }

    private void spawnItem(Player player, ItemStack itemStack) {
        Random rand = new Random();
        float rx = rand.nextFloat() * 0.8f + 0.1f;
        float ry = rand.nextFloat() * 0.8f + 0.1f;
        float rz = rand.nextFloat() * 0.8f + 0.1f;
        ItemEntity entityItem = new ItemEntity(player.m_9236_(), player.m_20182_().f_82479_ + (double)rx, player.m_20182_().f_82480_ + (double)ry, player.m_20182_().f_82481_ + (double)rz, itemStack.m_41777_());
        if (itemStack.m_41782_()) {
            entityItem.m_32055_().m_41751_(itemStack.m_41783_().m_6426_());
        }
        player.m_9236_().m_7967_((Entity)entityItem);
        itemStack.m_41764_(0);
    }

    public boolean isHotbarSwitch() {
        return this.isHotbarSwitch;
    }

    public ArmariumSlot storeAndGet(List<ItemStack> armorItems, List<ItemStack> hotbarItems, List<ItemStack> spellfocus, ResourceLocation familiarId, Slots slotsToGet) {
        ArmariumSlot armariumSlot = this.armariumSlots.getOrDefault((Object)this.currentSlot, new ArmariumSlot());
        armariumSlot.setArmor(armorItems);
        if (this.isHotbarSwitch) {
            armariumSlot.setHotbar(hotbarItems);
        }
        armariumSlot.setSpellfoci(spellfocus);
        armariumSlot.setFamiliarId(familiarId);
        this.armariumSlots.put(this.currentSlot, armariumSlot);
        this.currentSlot = slotsToGet != null ? slotsToGet : Slots.getNextSlot(this.currentSlot);
        this.writeArmariumStorageToArmariumItem();
        return this.armariumSlots.getOrDefault((Object)this.currentSlot, new ArmariumSlot());
    }

    public List<Component> getTooltip() {
        if (!this.armariumSlots.isEmpty()) {
            return List.of(this.isHotbarSwitch ? WILL_SWITCH_HOTBAR : WONT_SWITCH_HOTBAR, Component.m_237113_((String)("Next slots armor is: " + this.armariumSlots.get((Object)Slots.getNextSlot(this.currentSlot)).listArmor())));
        }
        return List.of(this.isHotbarSwitch ? WILL_SWITCH_HOTBAR : WONT_SWITCH_HOTBAR);
    }

    public Map<Slots, ArmariumSlot> getArmariumSlots() {
        return this.armariumSlots;
    }

    private void writeArmariumStorageToArmariumItem() {
        if (this.armarium == null || this.armarium.m_41619_()) {
            return;
        }
        CompoundTag tag = this.armarium.m_41784_();
        tag.m_128365_(ARMARIUM_STORAGE_TAG_ID, (Tag)this.writeTag());
        this.armarium.m_41751_(tag);
    }

    private CompoundTag writeTag() {
        CompoundTag armariumTag = new CompoundTag();
        armariumTag.m_128359_(CURRENT_SLOT, this.currentSlot.name());
        armariumTag.m_128359_(FLAVORTEXT, this.flavorText);
        armariumTag.m_128379_(IS_HOTBAR_SWITCH, this.isHotbarSwitch);
        for (Slots slot : Slots.values()) {
            armariumTag.m_128365_(slot.name(), (Tag)this.armariumSlots.getOrDefault((Object)slot, new ArmariumSlot()).serialize());
        }
        return armariumTag;
    }
}

