/*
 * Decompiled with CFR 0.152.
 */
package de.canitzp.feederhelmet;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class NBTHelper {
    public static boolean anyModulePresent(ItemStack stack) {
        return !NBTHelper.getModulesList(stack).isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isModulePresent(String module, ItemStack stack) {
        if (!stack.m_41782_()) return false;
        if (stack.m_41783_().m_128425_("modules", 9)) {
            if (!stack.m_41783_().m_128437_("modules", 8).stream().map(Tag::m_7916_).anyMatch(module::equals)) return false;
            return true;
        } else if (!stack.m_41783_().m_128471_(module)) return false;
        return true;
    }

    private static ListTag getModulesList(ItemStack stack) {
        CompoundTag nbt = stack.m_41782_() ? stack.m_41783_() : new CompoundTag();
        return nbt.m_128425_("modules", 9) ? nbt.m_128437_("modules", 8) : new ListTag();
    }

    private static void setModulesList(ItemStack stack, ListTag listNBT) {
        CompoundTag nbt = stack.m_41782_() ? stack.m_41783_() : new CompoundTag();
        nbt.m_128365_("modules", (Tag)listNBT);
        stack.m_41751_(nbt);
    }

    public static void addModule(String module, ItemStack stack) {
        ListTag listNBT = NBTHelper.getModulesList(stack);
        if (listNBT.stream().map(Tag::m_7916_).noneMatch(module::equals)) {
            listNBT.add((Object)StringTag.m_129297_((String)module));
        }
        NBTHelper.setModulesList(stack, listNBT);
    }

    public static void removeModule(String module, ItemStack stack) {
        ListTag newListNBT = new ListTag();
        ListTag currentListNBT = NBTHelper.getModulesList(stack);
        for (Tag inbt : currentListNBT) {
            if (module.equals(inbt.m_7916_())) continue;
            newListNBT.add((Object)inbt);
        }
        NBTHelper.setModulesList(stack, newListNBT);
    }
}

