/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.block;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.block.AbstractSixWayFrameBlock;
import mod.pianomanu.blockcarpentry.item.BaseFrameItem;
import mod.pianomanu.blockcarpentry.item.BaseIllusionItem;
import mod.pianomanu.blockcarpentry.setup.Registration;
import mod.pianomanu.blockcarpentry.setup.config.BCModConfig;
import mod.pianomanu.blockcarpentry.tileentity.TwoBlocksFrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BCBlockStateProperties;
import mod.pianomanu.blockcarpentry.util.BlockSavingHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SixWaySlabFrameBlock
extends AbstractSixWayFrameBlock
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty CONTAINS_BLOCK = BCBlockStateProperties.CONTAINS_BLOCK;
    public static final BooleanProperty CONTAINS_2ND_BLOCK = BCBlockStateProperties.CONTAINS_2ND_BLOCK;
    public static final IntegerProperty LIGHT_LEVEL = BCBlockStateProperties.LIGHT_LEVEL;
    public static final BooleanProperty DOUBLE_SLAB = BCBlockStateProperties.DOUBLE;
    protected static final VoxelShape BOTTOM = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape TOP = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape WEST = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape CUBE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public SixWaySlabFrameBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.DOWN)).m_61124_((Property)CONTAINS_BLOCK, (Comparable)Boolean.FALSE)).m_61124_((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOUBLE_SLAB, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CONTAINS_2ND_BLOCK, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED, DOUBLE_SLAB, CONTAINS_2ND_BLOCK});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)DOUBLE_SLAB)).booleanValue()) {
            return CUBE;
        }
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.EAST -> EAST;
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            case Direction.UP -> TOP;
            default -> BOTTOM;
        };
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        FluidState fluidstate = context.m_43725_().m_6425_(blockpos);
        BlockState blockState = context.m_43725_().m_8055_(blockpos);
        if (blockState.m_60713_((Block)this)) {
            return (BlockState)((BlockState)blockState.m_61124_((Property)DOUBLE_SLAB, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        if (Objects.requireNonNull(context.m_43723_()).m_6047_() && ((Boolean)BCModConfig.SNEAK_FOR_VERTICAL_SLABS.get()).booleanValue() || !Objects.requireNonNull(context.m_43723_()).m_6047_() && !((Boolean)BCModConfig.SNEAK_FOR_VERTICAL_SLABS.get()).booleanValue()) {
            if (fluidstate.m_76152_() == Fluids.f_76193_) {
                return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_7820_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76170_()));
            }
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_7820_().m_122424_());
        }
        BlockState blockstate1 = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        Direction direction = context.m_43719_();
        return !(direction == Direction.DOWN || direction != Direction.UP && context.m_43720_().f_82480_ - (double)blockpos.m_123342_() > 0.5) ? blockstate1 : (BlockState)blockstate1.m_61124_((Property)FACING, (Comparable)Direction.DOWN);
    }

    @Override
    public VoxelShape m_5909_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return this.m_5940_(state, getter, pos, context);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        ItemStack itemstack = useContext.m_43722_();
        boolean slabType = (Boolean)state.m_61143_((Property)DOUBLE_SLAB);
        if (!slabType && itemstack.m_150930_(this.m_5456_())) {
            if (useContext.m_7058_()) {
                Direction direction = useContext.m_43719_();
                return switch ((Direction)state.m_61143_((Property)FACING)) {
                    case Direction.EAST -> {
                        if (direction == Direction.EAST) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.SOUTH -> {
                        if (direction == Direction.SOUTH) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.WEST -> {
                        if (direction == Direction.WEST) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.NORTH -> {
                        if (direction == Direction.NORTH) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.UP -> {
                        if (direction == Direction.UP) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> direction == Direction.DOWN;
                };
            }
            return true;
        }
        return false;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TwoBlocksFrameBlockTile(pos, state);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitresult) {
        return this.frameUse(state, level, pos, player, hand, hitresult);
    }

    @Override
    public boolean changeMimic(BlockState state, Level level, BlockPos pos, Player player, ItemStack itemStack) {
        boolean isDouble = (Boolean)state.m_61143_((Property)DOUBLE_SLAB);
        if (isDouble && (Boolean)state.m_61143_((Property)BCBlockStateProperties.CONTAINS_2ND_BLOCK) != false || !isDouble && (Boolean)state.m_61143_((Property)BCBlockStateProperties.CONTAINS_BLOCK) != false || itemStack.m_41720_() instanceof BaseFrameItem || itemStack.m_41720_() instanceof BaseIllusionItem) {
            return false;
        }
        BlockEntity tileEntity = level.m_7702_(pos);
        int count = itemStack.m_41613_();
        Block heldBlock = ((BlockItem)itemStack.m_41720_()).m_40614_();
        if (tileEntity instanceof TwoBlocksFrameBlockTile && !itemStack.m_41619_() && BlockSavingHelper.isValidBlock(heldBlock, level.f_46443_) && !((Boolean)state.m_61143_((Property)CONTAINS_2ND_BLOCK)).booleanValue()) {
            BlockState handBlockState = ((BlockItem)itemStack.m_41720_()).m_40614_().m_49966_();
            this.insertBlock(level, pos, state, handBlockState);
            if (!player.m_7500_()) {
                itemStack.m_41764_(count - 1);
            }
        }
        return true;
    }

    @Override
    public boolean removeBlock(Level level, BlockPos pos, BlockState state, ItemStack itemStack, Player player) {
        if (itemStack.m_41720_() == Registration.HAMMER.get() || !((Boolean)BCModConfig.HAMMER_NEEDED.get()).booleanValue() && player.m_6047_()) {
            if (!player.m_7500_()) {
                this.dropContainedBlock(level, pos);
            } else {
                this.clearTile(level, pos);
            }
            state = (BlockState)((BlockState)state.m_61124_((Property)CONTAINS_BLOCK, (Comparable)Boolean.FALSE)).m_61124_((Property)CONTAINS_2ND_BLOCK, (Comparable)Boolean.FALSE);
            level.m_7731_(pos, state, 2);
            return true;
        }
        return false;
    }

    @Override
    public void clearTile(Level level, BlockPos pos) {
        BlockEntity tileentity;
        if (!level.f_46443_ && (tileentity = level.m_7702_(pos)) instanceof TwoBlocksFrameBlockTile) {
            TwoBlocksFrameBlockTile frameBlockEntity = (TwoBlocksFrameBlockTile)tileentity;
            frameBlockEntity.clear();
        }
    }

    @Override
    public void dropContainedBlock(Level levelIn, BlockPos pos) {
        BlockEntity tileentity;
        if (!levelIn.f_46443_ && (tileentity = levelIn.m_7702_(pos)) instanceof TwoBlocksFrameBlockTile) {
            TwoBlocksFrameBlockTile frameBlockEntity = (TwoBlocksFrameBlockTile)tileentity;
            BlockState blockState = frameBlockEntity.getMimic();
            if (blockState != null) {
                this.dropItemStackInWorld(levelIn, pos, blockState);
            }
            if ((blockState = frameBlockEntity.getMimic_2()) != null) {
                this.dropItemStackInWorld(levelIn, pos, blockState);
            }
            frameBlockEntity.clear();
        }
    }

    @Override
    public void insertBlock(Level levelIn, BlockPos pos, BlockState state, BlockState handBlock) {
        BlockEntity tileentity = levelIn.m_7702_(pos);
        if (tileentity instanceof TwoBlocksFrameBlockTile) {
            if (!((Boolean)state.m_61143_((Property)CONTAINS_BLOCK)).booleanValue()) {
                TwoBlocksFrameBlockTile frameBlockEntity = (TwoBlocksFrameBlockTile)tileentity;
                frameBlockEntity.clear();
                frameBlockEntity.setMimic(handBlock);
                levelIn.m_7731_(pos, (BlockState)state.m_61124_((Property)CONTAINS_BLOCK, (Comparable)Boolean.TRUE), 2);
            } else if (((Boolean)state.m_61143_((Property)DOUBLE_SLAB)).booleanValue()) {
                TwoBlocksFrameBlockTile frameBlockEntity = (TwoBlocksFrameBlockTile)tileentity;
                frameBlockEntity.setMimic_2(handBlock);
                levelIn.m_7731_(pos, (BlockState)state.m_61124_((Property)CONTAINS_2ND_BLOCK, (Comparable)Boolean.TRUE), 2);
            }
        }
    }

    public void m_6810_(BlockState state, @Nonnull Level levelIn, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            this.dropContainedBlock(levelIn, pos);
            super.m_6810_(state, levelIn, pos, newState, isMoving);
        }
    }

    @Override
    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        if ((Integer)state.m_61143_((Property)LIGHT_LEVEL) > 15) {
            return 15;
        }
        return (Integer)state.m_61143_((Property)LIGHT_LEVEL);
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nonnull
    public BlockState m_7417_(BlockState stateIn, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor levelIn, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelIn));
        }
        return super.m_7417_(stateIn, facing, facingState, levelIn, currentPos, facingPos);
    }
}

