/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.block.IFrameBlock;
import mod.pianomanu.blockcarpentry.setup.Registration;
import mod.pianomanu.blockcarpentry.tileentity.DaylightDetectorFrameTileEntity;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.BlockModificationHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DaylightDetectorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class DaylightDetectorFrameBlock
extends DaylightDetectorBlock
implements IFrameBlock {
    public DaylightDetectorFrameBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)CONTAINS_BLOCK, (Comparable)Boolean.FALSE)).m_61124_((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_((Property)f_52377_, (Comparable)Integer.valueOf(0))).m_61124_((Property)f_52378_, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{CONTAINS_BLOCK, LIGHT_LEVEL});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DaylightDetectorFrameTileEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitresult) {
        ItemStack itemStack = player.m_21120_(hand);
        if (hand == InteractionHand.MAIN_HAND) {
            if (!level.f_46443_) {
                if (this.shouldCallFrameUse(state, itemStack)) {
                    return this.frameUseServer(state, level, pos, player, itemStack, hitresult);
                }
                return super.m_6227_(state, level, pos, player, hand, hitresult);
            }
            return this.frameUseClient(state, level, pos, player, itemStack, hitresult);
        }
        return InteractionResult.FAIL;
    }

    public void m_6810_(BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            this.dropContainedBlock(level, pos);
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return IFrameBlock.getLightEmission(state);
    }

    @Override
    public boolean isCorrectTileInstance(BlockEntity blockEntity) {
        return blockEntity instanceof DaylightDetectorFrameTileEntity;
    }

    @Override
    public void fillBlockEntity(Level levelIn, BlockPos pos, BlockState state, BlockState handBlock, BlockEntity blockEntity) {
        DaylightDetectorFrameTileEntity frameBlockEntity = (DaylightDetectorFrameTileEntity)blockEntity;
        frameBlockEntity.clear();
        frameBlockEntity.setMimic(handBlock);
        levelIn.m_7731_(pos, (BlockState)state.m_61124_((Property)CONTAINS_BLOCK, (Comparable)Boolean.TRUE), 2);
    }

    private static void updateSignalStrength(BlockState state, Level level, BlockPos pos) {
        int i = level.m_45517_(LightLayer.SKY, pos) - level.m_7445_();
        float f = level.m_46490_(1.0f);
        boolean inverted = (Boolean)state.m_61143_((Property)f_52378_);
        if (inverted) {
            i = 15 - i;
        } else if (i > 0) {
            float f1 = f < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            f += (f1 - f) * 0.2f;
            i = Math.round((float)i * Mth.m_14089_((float)f));
        }
        i = Mth.m_14045_((int)i, (int)0, (int)15);
        if ((Integer)state.m_61143_((Property)f_52377_) != i) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_52377_, (Comparable)Integer.valueOf(i)), 3);
        }
    }

    private static void tickEntity(Level level, BlockPos pos, BlockState state, DaylightDetectorFrameTileEntity detectorEntity) {
        if (level.m_46467_() % 20L == 0L) {
            DaylightDetectorFrameBlock.updateSignalStrength(state, level, pos);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> entityType) {
        if (this.m_49954_().equals((Object)((DaylightDetectorFrameBlock)Registration.DAYLIGHT_DETECTOR_FRAMEBLOCK.get()).m_49954_())) {
            return !level.f_46443_ && level.m_6042_().f_223549_() ? DaylightDetectorFrameBlock.m_152132_(entityType, (BlockEntityType)((BlockEntityType)Registration.DAYLIGHT_DETECTOR_FRAME_TILE.get()), DaylightDetectorFrameBlock::tickEntity) : null;
        }
        if (this.m_49954_().equals((Object)((DaylightDetectorFrameBlock)Registration.DAYLIGHT_DETECTOR_ILLUSIONBLOCK.get()).m_49954_())) {
            return !level.f_46443_ && level.m_6042_().f_223549_() ? DaylightDetectorFrameBlock.m_152132_(entityType, (BlockEntityType)((BlockEntityType)Registration.DAYLIGHT_DETECTOR_ILLUSION_TILE.get()), DaylightDetectorFrameBlock::tickEntity) : null;
        }
        throw new IllegalStateException("Block " + this.m_49954_() + " is neither frame or illusion block! BlockState: " + state);
    }

    @Override
    public boolean executeModifications(BlockState state, Level level, BlockPos pos, Player player, ItemStack itemStack) {
        return BlockAppearanceHelper.setAll(itemStack, state, level, pos, player) || this.getTile((BlockGetter)level, pos) != null && BlockModificationHelper.setAll(itemStack, this.getTile((BlockGetter)level, pos), player, false, false);
    }
}

