/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import mod.pianomanu.blockcarpentry.util.MathUtils;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.pipeline.QuadBakingVertexConsumer;

public class QuadUtils {
    private static void putVertex(VertexConsumer builder, Vec3 normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite, float r, float g, float b, float a) {
        float iu = sprite.m_118367_((double)u);
        float iv = sprite.m_118393_((double)v);
        builder.m_5483_(x, y, z).m_7421_(iu, iv).m_7120_(0, 0).m_85950_(r, g, b, a).m_5601_((float)normal.m_7096_(), (float)normal.m_7098_(), (float)normal.m_7094_()).m_5752_();
    }

    private static QuadBakingVertexConsumer prepare(BakedQuad[] quad, TextureAtlasSprite sprite, Vec3 normal, int tintIndex) {
        QuadBakingVertexConsumer builder = new QuadBakingVertexConsumer(q -> {
            quad[0] = q;
        });
        builder.setSprite(sprite);
        builder.setDirection(Direction.m_122366_((double)normal.f_82479_, (double)normal.f_82480_, (double)normal.f_82481_));
        builder.setTintIndex(tintIndex);
        builder.setShade(true);
        return builder;
    }

    private static Vec3[] rotateFace(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, int rotation) {
        for (int i = 0; i < rotation; ++i) {
            Vec3 tmp = v4;
            v4 = v3;
            v3 = v2;
            v2 = v1;
            v1 = tmp;
        }
        return new Vec3[]{v1, v2, v3, v4};
    }

    public static float[] rotateUV(float v1u, float v1v, float v2u, float v2v, float v3u, float v3v, float v4u, float v4v, int rotation) {
        for (int i = 0; i < rotation; ++i) {
            float tmpU = v1u;
            float tmpV = v1v;
            v1u = v2u;
            v1v = v2v;
            v2u = v3u;
            v2v = v3v;
            v3u = v4u;
            v3v = v4v;
            v4u = tmpU;
            v4v = tmpV;
        }
        return new float[]{v1u, v1v, v2u, v2v, v3u, v3v, v4u, v4v};
    }

    public static BakedQuad createQuad(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, TextureAtlasSprite sprite, float ulow, float uhigh, float vlow, float vhigh, int tintIndex) {
        return QuadUtils.createQuad(v1, v2, v3, v4, sprite, ulow, uhigh, vlow, vhigh, tintIndex, false);
    }

    public static BakedQuad createQuad(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, TextureAtlasSprite sprite, int tintIndex, int rotation) {
        return QuadUtils.createQuad(v1, v2, v3, v4, sprite, 0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, 0.0f, tintIndex, false, rotation);
    }

    public static BakedQuad createQuad(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, TextureAtlasSprite sprite, float ulow, float uhigh, float vlow, float vhigh, int tintIndex, int rotation) {
        Vec3[] vs = QuadUtils.rotateFace(v1, v2, v3, v4, rotation);
        v1 = vs[0];
        v2 = vs[1];
        v3 = vs[2];
        v4 = vs[3];
        return QuadUtils.createQuad(v1, v2, v3, v4, sprite, ulow, uhigh, vlow, vhigh, tintIndex, false);
    }

    public static BakedQuad createQuad(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, TextureAtlasSprite sprite, int tintIndex) {
        return QuadUtils.createQuad(v1, v2, v3, v4, sprite, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex);
    }

    public static BakedQuad createQuad(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, TextureAtlasSprite sprite, Direction direction, int tintIndex, int rotation, boolean keepUV, boolean invert) {
        return QuadUtils.createQuad(v1, v2, v3, v4, sprite, direction, tintIndex, rotation, keepUV, invert, false);
    }

    public static BakedQuad createQuad(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, TextureAtlasSprite sprite, Direction direction, int tintIndex, int rotation, boolean keepUV, boolean invert, boolean moveVertically) {
        int verticalOffset;
        int n = verticalOffset = moveVertically ? 16 : 0;
        if (keepUV) {
            return QuadUtils.createQuad(v1, v2, v3, v4, sprite, 0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, 0.0f, tintIndex, invert, rotation);
        }
        Vec3[] vs = QuadUtils.rotateFace(v1, v2, v3, v4, rotation);
        v1 = vs[0];
        v2 = vs[1];
        v3 = vs[2];
        v4 = vs[3];
        float[] uvs = QuadUtils.rotateUVcomplex(v1, v2, v3, v4, direction, rotation, verticalOffset);
        return QuadUtils.createQuad(v1, v2, v3, v4, sprite, uvs[0], uvs[1], uvs[2], uvs[3], uvs[4], uvs[5], uvs[6], uvs[7], tintIndex, invert, 0);
    }

    public static BakedQuad createQuad(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, TextureAtlasSprite sprite, float ulow, float uhigh, float vlow, float vhigh, int tintIndex, boolean invert) {
        return QuadUtils.createQuad(v1, v2, v3, v4, sprite, ulow, vlow, ulow, vhigh, uhigh, vhigh, uhigh, vlow, tintIndex, invert, 0);
    }

    public static BakedQuad createQuad(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, TextureAtlasSprite sprite, float v1u, float v1v, float v2u, float v2v, float v3u, float v3v, float v4u, float v4v, int tintIndex, boolean invert, int rotation) {
        Vec3[] vs = QuadUtils.rotateFace(v1, v2, v3, v4, rotation);
        v1 = vs[0];
        v2 = vs[1];
        v3 = vs[2];
        v4 = vs[3];
        Vec3 normal = v3.m_82546_(v2).m_82537_(v1.m_82546_(v2)).m_82541_();
        BakedQuad[] quad = new BakedQuad[1];
        QuadBakingVertexConsumer builder = QuadUtils.prepare(quad, sprite, normal, tintIndex);
        if (invert) {
            normal = normal.m_82548_();
            QuadUtils.putVertex((VertexConsumer)builder, normal, v4.f_82479_, v4.f_82480_, v4.f_82481_, v4u, v4v, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
            QuadUtils.putVertex((VertexConsumer)builder, normal, v3.f_82479_, v3.f_82480_, v3.f_82481_, v3u, v3v, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
            QuadUtils.putVertex((VertexConsumer)builder, normal, v2.f_82479_, v2.f_82480_, v2.f_82481_, v2u, v2v, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
            QuadUtils.putVertex((VertexConsumer)builder, normal, v1.f_82479_, v1.f_82480_, v1.f_82481_, v1u, v1v, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            QuadUtils.putVertex((VertexConsumer)builder, normal, v1.f_82479_, v1.f_82480_, v1.f_82481_, v1u, v1v, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
            QuadUtils.putVertex((VertexConsumer)builder, normal, v2.f_82479_, v2.f_82480_, v2.f_82481_, v2u, v2v, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
            QuadUtils.putVertex((VertexConsumer)builder, normal, v3.f_82479_, v3.f_82480_, v3.f_82481_, v3u, v3v, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
            QuadUtils.putVertex((VertexConsumer)builder, normal, v4.f_82479_, v4.f_82480_, v4.f_82481_, v4u, v4v, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        return quad[0];
    }

    public static BakedQuad createQuadInverted(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, TextureAtlasSprite sprite, float ulow, float uhigh, float vlow, float vhigh, int tintIndex) {
        return QuadUtils.createQuad(v1, v2, v3, v4, sprite, tintIndex);
    }

    public static List<BakedQuad> createQuadComplex(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, TextureAtlasSprite sprite, Direction direction, int tintIndex, int rotation, boolean keepUV, boolean invert) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Vec3 COGVec = QuadUtils.centerOfGravityVec(v1, v2, v3, v4);
        Vec3[] vs = QuadUtils.rotateFace(v1, v2, v3, v4, rotation);
        v1 = vs[0];
        v2 = vs[1];
        v3 = vs[2];
        v4 = vs[3];
        if (!keepUV) {
            float[] uvs = QuadUtils.rotateUVcomplex(v1, v2, v3, v4, direction, rotation);
            float cogU = (float)(direction.m_122434_() == Direction.Axis.X ? COGVec.f_82481_ * 16.0 : COGVec.f_82479_ * 16.0);
            float cogV = (float)(direction.m_122434_().m_122479_() ? COGVec.f_82480_ * 16.0 : COGVec.f_82479_ * 16.0);
            quads.add(QuadUtils.createQuad(v1, v2, COGVec, COGVec, sprite, uvs[0], uvs[1], uvs[2], uvs[3], cogU, cogV, cogU, cogV, tintIndex, invert, 0));
            quads.add(QuadUtils.createQuad(v2, v3, COGVec, COGVec, sprite, uvs[2], uvs[3], uvs[4], uvs[5], cogU, cogV, cogU, cogV, tintIndex, invert, 0));
            quads.add(QuadUtils.createQuad(v3, v4, COGVec, COGVec, sprite, uvs[4], uvs[5], uvs[6], uvs[7], cogU, cogV, cogU, cogV, tintIndex, invert, 0));
            quads.add(QuadUtils.createQuad(COGVec, v4, v1, COGVec, sprite, cogU, cogV, uvs[6], uvs[7], uvs[0], uvs[1], cogU, cogV, tintIndex, invert, 0));
        } else {
            quads.add(QuadUtils.createQuad(v1, v2, COGVec, COGVec, sprite, 0.0f, 0.0f, 0.0f, 16.0f, 8.0f, 8.0f, 8.0f, 8.0f, tintIndex, invert, 0));
            quads.add(QuadUtils.createQuad(v2, v3, COGVec, COGVec, sprite, 0.0f, 16.0f, 16.0f, 16.0f, 8.0f, 8.0f, 8.0f, 8.0f, tintIndex, invert, 0));
            quads.add(QuadUtils.createQuad(v3, v4, COGVec, COGVec, sprite, 16.0f, 16.0f, 16.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f, tintIndex, invert, 0));
            quads.add(QuadUtils.createQuad(COGVec, v4, v1, COGVec, sprite, 8.0f, 8.0f, 16.0f, 0.0f, 0.0f, 0.0f, 8.0f, 8.0f, tintIndex, invert, 0));
        }
        return quads;
    }

    public static float[] rotateUVcomplex(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, Direction direction, int rotation) {
        return QuadUtils.rotateUVcomplex(v1, v2, v3, v4, direction, rotation, 0);
    }

    public static float[] rotateUVcomplex(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, Direction direction, int rotation, int verticalOffset) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> QuadUtils.rotateUV((float)v1.f_82479_ * 16.0f, (float)v1.f_82481_ * 16.0f, (float)v2.f_82479_ * 16.0f, (float)v2.f_82481_ * 16.0f, (float)v3.f_82479_ * 16.0f, (float)v3.f_82481_ * 16.0f, (float)v4.f_82479_ * 16.0f, (float)v4.f_82481_ * 16.0f, rotation);
            case Direction.DOWN -> QuadUtils.rotateUV((float)v1.f_82479_ * 16.0f, 16.0f - (float)v1.f_82481_ * 16.0f, (float)v2.f_82479_ * 16.0f, 16.0f - (float)v2.f_82481_ * 16.0f, (float)v3.f_82479_ * 16.0f, 16.0f - (float)v3.f_82481_ * 16.0f, (float)v4.f_82479_ * 16.0f, 16.0f - (float)v4.f_82481_ * 16.0f, rotation);
            case Direction.WEST -> QuadUtils.rotateUV((float)v1.f_82481_ * 16.0f, 16.0f - (float)v1.f_82480_ * 16.0f + (float)verticalOffset, (float)v2.f_82481_ * 16.0f, 16.0f - (float)v2.f_82480_ * 16.0f + (float)verticalOffset, (float)v3.f_82481_ * 16.0f, 16.0f - (float)v3.f_82480_ * 16.0f + (float)verticalOffset, (float)v4.f_82481_ * 16.0f, 16.0f - (float)v4.f_82480_ * 16.0f + (float)verticalOffset, rotation);
            case Direction.EAST -> QuadUtils.rotateUV(16.0f - (float)v1.f_82481_ * 16.0f, 16.0f - (float)v1.f_82480_ * 16.0f + (float)verticalOffset, 16.0f - (float)v2.f_82481_ * 16.0f, 16.0f - (float)v2.f_82480_ * 16.0f + (float)verticalOffset, 16.0f - (float)v3.f_82481_ * 16.0f, 16.0f - (float)v3.f_82480_ * 16.0f + (float)verticalOffset, 16.0f - (float)v4.f_82481_ * 16.0f, 16.0f - (float)v4.f_82480_ * 16.0f + (float)verticalOffset, rotation);
            case Direction.SOUTH -> QuadUtils.rotateUV((float)v1.f_82479_ * 16.0f, 16.0f - (float)v1.f_82480_ * 16.0f + (float)verticalOffset, (float)v2.f_82479_ * 16.0f, 16.0f - (float)v2.f_82480_ * 16.0f + (float)verticalOffset, (float)v3.f_82479_ * 16.0f, 16.0f - (float)v3.f_82480_ * 16.0f + (float)verticalOffset, (float)v4.f_82479_ * 16.0f, 16.0f - (float)v4.f_82480_ * 16.0f + (float)verticalOffset, rotation);
            case Direction.NORTH -> QuadUtils.rotateUV(16.0f - (float)v1.f_82479_ * 16.0f, 16.0f - (float)v1.f_82480_ * 16.0f + (float)verticalOffset, 16.0f - (float)v2.f_82479_ * 16.0f, 16.0f - (float)v2.f_82480_ * 16.0f + (float)verticalOffset, 16.0f - (float)v3.f_82479_ * 16.0f, 16.0f - (float)v3.f_82480_ * 16.0f + (float)verticalOffset, 16.0f - (float)v4.f_82479_ * 16.0f, 16.0f - (float)v4.f_82480_ * 16.0f + (float)verticalOffset, rotation);
        };
    }

    private static Vec3 centerOfGravityVec(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4) {
        Vec3 interpol13 = MathUtils.interpolate(v1, v3, 0.5, false);
        Vec3 interpol24 = MathUtils.interpolate(v2, v4, 0.5, false);
        return MathUtils.interpolate(interpol13, interpol24, 0.5, false);
    }
}

