/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.SimpleBox;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class FrameBakedModel
implements IDynamicBakedModel {
    public static final ResourceLocation TEXTURE = new ResourceLocation("minecraft", "block/oak_planks");

    private TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TEXTURE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, RenderType renderType) {
        BlockState mimic = (BlockState)extraData.get(FrameBlockTile.MIMIC);
        if (side == null) {
            return Collections.emptyList();
        }
        if (mimic != null) {
            ModelResourceLocation location = BlockModelShaper.m_110895_((BlockState)mimic);
            if (state != null) {
                Vec3 SED;
                Vec3 NED;
                Vec3 SEU;
                Vec3 NEU;
                Vec3 SWD;
                Vec3 NWD;
                Vec3 SWU;
                Vec3 NWU;
                BakedModel model = Minecraft.m_91087_().m_91304_().m_119422_(location);
                TextureAtlasSprite texture = TextureHelper.getTexture(model, rand, extraData, FrameBlockTile.TEXTURE);
                int tintIndex = BlockAppearanceHelper.setTintIndex(mimic);
                try {
                    NWU = new Vec3(0.0, 1.0, 0.0).m_82549_(((Vec3)extraData.get(FrameBlockTile.NWU_prop)).m_82542_(0.0625, 0.0625, 0.0625));
                    SWU = new Vec3(0.0, 1.0, 1.0).m_82549_(((Vec3)extraData.get(FrameBlockTile.SWU_prop)).m_82542_(0.0625, 0.0625, 0.0625));
                    NWD = new Vec3(0.0, 0.0, 0.0).m_82549_(((Vec3)extraData.get(FrameBlockTile.NWD_prop)).m_82542_(0.0625, 0.0625, 0.0625));
                    SWD = new Vec3(0.0, 0.0, 1.0).m_82549_(((Vec3)extraData.get(FrameBlockTile.SWD_prop)).m_82542_(0.0625, 0.0625, 0.0625));
                    NEU = new Vec3(1.0, 1.0, 0.0).m_82549_(((Vec3)extraData.get(FrameBlockTile.NEU_prop)).m_82542_(0.0625, 0.0625, 0.0625));
                    SEU = new Vec3(1.0, 1.0, 1.0).m_82549_(((Vec3)extraData.get(FrameBlockTile.SEU_prop)).m_82542_(0.0625, 0.0625, 0.0625));
                    NED = new Vec3(1.0, 0.0, 0.0).m_82549_(((Vec3)extraData.get(FrameBlockTile.NED_prop)).m_82542_(0.0625, 0.0625, 0.0625));
                    SED = new Vec3(1.0, 0.0, 1.0).m_82549_(((Vec3)extraData.get(FrameBlockTile.SED_prop)).m_82542_(0.0625, 0.0625, 0.0625));
                }
                catch (NullPointerException e) {
                    NWU = new Vec3(0.0, 1.0, 0.0);
                    SWU = new Vec3(0.0, 1.0, 1.0);
                    NWD = new Vec3(0.0, 0.0, 0.0);
                    SWD = new Vec3(0.0, 0.0, 1.0);
                    NEU = new Vec3(1.0, 1.0, 0.0);
                    SEU = new Vec3(1.0, 1.0, 1.0);
                    NED = new Vec3(1.0, 0.0, 0.0);
                    SED = new Vec3(1.0, 0.0, 1.0);
                }
                List directions = (List)extraData.get(FrameBlockTile.DIRECTIONS);
                List rotations = (List)extraData.get(FrameBlockTile.ROTATIONS);
                boolean keepUV = (Boolean)extraData.get(FrameBlockTile.KEEP_UV);
                SimpleBox box = SimpleBox.create(NWU, NWD, NEU, NED, SWU, SWD, SEU, SED, extraData, model, rand, texture, directions, rotations, tintIndex, keepUV);
                return box.getQuads();
            }
        }
        return Collections.emptyList();
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return this.getTexture();
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110466_()});
    }
}

