/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.endertrigon.common.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import nonamecrackers2.endertrigon.common.entity.goal.BabyEnderDragonAttackStrategyGoal;
import nonamecrackers2.endertrigon.common.entity.goal.BabyEnderDragonMoveAnchorGoal;
import nonamecrackers2.endertrigon.common.entity.goal.BabyEnderDragonSweepGoal;

public class BabyEnderDragon
extends FlyingMob
implements Enemy {
    public float flapTime;
    public float oFlapTime;
    public final double[][] latencyYs = new double[64][3];
    public int latencyPointer = -1;
    private Vec3 moveTarget = Vec3.f_82478_;
    private BlockPos anchor = BlockPos.f_121853_;
    private AttackPhase phase = AttackPhase.CIRCLE;

    public BabyEnderDragon(EntityType<? extends BabyEnderDragon> type, Level level) {
        super(type, level);
        this.f_21365_ = new DragonLookControl(this);
        this.f_21342_ = new DragonMoveControl(this);
    }

    protected BodyRotationControl m_7560_() {
        return new DragonBodyControl(this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22281_, 6.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new BabyEnderDragonAttackStrategyGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new BabyEnderDragonSweepGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new BabyEnderDragonMoveAnchorGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new TargetGoal(this));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("Anchor", (Tag)NbtUtils.m_129224_((BlockPos)this.getAnchor()));
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setAnchor(NbtUtils.m_129239_((CompoundTag)tag.m_128469_("Anchor")));
    }

    public boolean m_142039_() {
        float f = Mth.m_14089_((float)(this.flapTime * ((float)Math.PI * 2)));
        float f1 = Mth.m_14089_((float)(this.oFlapTime * ((float)Math.PI * 2)));
        return f1 <= -0.3f && f >= -0.3f;
    }

    public void m_142043_() {
        if (this.f_19853_.f_46443_ && !this.m_20067_()) {
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11893_, this.m_5720_(), 5.0f, 1.7f + this.f_19796_.m_188501_() * 0.3f, false);
        }
    }

    public double[] getLatency(int pointer, float partialTicks) {
        if (this.m_21224_()) {
            partialTicks = 0.0f;
        }
        partialTicks = 1.0f - partialTicks;
        int i = this.latencyPointer - pointer & 0x3F;
        int j = this.latencyPointer - pointer - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.latencyYs[i][0];
        double d1 = Mth.m_14175_((double)(this.latencyYs[j][0] - d0));
        adouble[0] = d0 + d1 * (double)partialTicks;
        d0 = this.latencyYs[i][1];
        d1 = this.latencyYs[j][1] - d0;
        adouble[1] = d0 + d1 * (double)partialTicks;
        adouble[2] = Mth.m_14139_((double)partialTicks, (double)this.latencyYs[i][2], (double)this.latencyYs[j][2]);
        return adouble;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_21224_()) {
            if (this.latencyPointer < 0) {
                for (int i = 0; i < this.latencyYs.length; ++i) {
                    this.latencyYs[i][0] = this.m_146908_();
                    this.latencyYs[i][1] = this.m_20186_();
                }
            }
            if (++this.latencyPointer == this.latencyYs.length) {
                this.latencyPointer = 0;
            }
            this.latencyYs[this.latencyPointer][0] = this.m_146908_();
            this.latencyYs[this.latencyPointer][1] = this.m_20186_();
        }
        this.oFlapTime = this.flapTime;
        Vec3 delta = this.m_20184_();
        float flapPower = 0.2f / ((float)delta.m_165924_() * 2.0f + 1.0f);
        this.flapTime += flapPower;
        if (this.f_19853_.f_46443_) {
            this.m_146874_();
        }
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11890_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_11895_;
    }

    public float m_6100_() {
        return (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.5f;
    }

    public Vec3 getMoveTarget() {
        return this.moveTarget;
    }

    public void setMoveTarget(Vec3 moveTarget) {
        this.moveTarget = moveTarget;
    }

    public BlockPos getAnchor() {
        return this.anchor;
    }

    public void setAnchor(BlockPos anchor) {
        this.anchor = anchor;
    }

    public AttackPhase getPhase() {
        return this.phase;
    }

    public void setPhase(AttackPhase phase) {
        this.phase = phase;
    }

    protected boolean m_8028_() {
        return true;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType type, SpawnGroupData groupData, CompoundTag data) {
        this.setAnchor(this.m_20183_().m_6630_(5));
        return super.m_6518_(level, difficulty, type, groupData, data);
    }

    public static enum AttackPhase {
        CIRCLE,
        SWOOP;

    }

    private static class DragonLookControl
    extends LookControl {
        public DragonLookControl(BabyEnderDragon dragon) {
            super((Mob)dragon);
        }

        public void m_8128_() {
        }
    }

    private static class DragonMoveControl
    extends MoveControl {
        private final BabyEnderDragon dragon;
        private float speed;

        public DragonMoveControl(BabyEnderDragon dragon) {
            super((Mob)dragon);
            this.dragon = dragon;
        }

        public void m_8126_() {
            double d0 = this.dragon.moveTarget.f_82479_ - this.dragon.m_20185_();
            double d1 = this.dragon.moveTarget.f_82480_ - this.dragon.m_20186_();
            double d2 = this.dragon.moveTarget.f_82481_ - this.dragon.m_20189_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            if (Math.abs(d3) > (double)1.0E-5f) {
                double d4 = 1.0 - Math.abs(d1 * (double)0.7f) / d3;
                d3 = Math.sqrt((d0 *= d4) * d0 + (d2 *= d4) * d2);
                double d5 = Math.sqrt(d0 * d0 + d2 * d2 + d1 * d1);
                float f = this.dragon.m_146908_();
                float f1 = (float)Mth.m_14136_((double)d2, (double)d0);
                float f2 = Mth.m_14177_((float)(this.dragon.m_146908_() + 90.0f)) + (this.dragon.f_19862_ ? 25.0f : 0.0f);
                float f3 = Mth.m_14177_((float)(f1 * 57.295776f));
                this.dragon.m_146922_(Mth.m_14148_((float)f2, (float)f3, (float)4.0f) - 90.0f);
                this.dragon.f_20883_ = this.dragon.m_146908_();
                this.speed = Mth.m_14145_((float)f, (float)this.dragon.m_146908_()) < 3.0f ? Mth.m_14121_((float)this.speed, (float)1.8f, (float)(0.005f * (1.8f / this.speed))) : Mth.m_14121_((float)this.speed, (float)0.8f, (float)0.25f);
                float f4 = (float)(-(Mth.m_14136_((double)(-d1), (double)d3) * 57.2957763671875));
                this.dragon.m_146926_(f4);
                float f5 = this.dragon.m_146908_() + 90.0f;
                double d6 = (double)(this.speed * Mth.m_14089_((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(d0 / d5);
                double d7 = (double)(this.speed * Mth.m_14031_((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(d2 / d5);
                double d8 = (double)(this.speed * Mth.m_14031_((float)(f4 * ((float)Math.PI / 180)))) * Math.abs(d1 / d5);
                Vec3 vec3 = this.dragon.m_20184_();
                this.dragon.m_20256_(vec3.m_82549_(new Vec3(d6, d8, d7).m_82546_(vec3).m_82490_(0.2)));
            }
        }
    }

    private static class DragonBodyControl
    extends BodyRotationControl {
        private final BabyEnderDragon dragon;

        public DragonBodyControl(BabyEnderDragon dragon) {
            super((Mob)dragon);
            this.dragon = dragon;
        }

        public void m_8121_() {
            this.dragon.f_20885_ = this.dragon.f_20883_;
            this.dragon.f_20883_ = this.dragon.m_146908_();
        }
    }

    private static class TargetGoal
    extends NearestAttackableTargetGoal<Player> {
        public TargetGoal(BabyEnderDragon dragon) {
            super((Mob)dragon, Player.class, false);
        }

        protected AABB m_7255_(double reach) {
            return this.f_26135_.m_20191_().m_82400_(reach);
        }
    }
}

