/*
 * Decompiled with CFR 0.152.
 */
package cofh.archersparadox.entity.projectile;

import cofh.archersparadox.init.APEffects;
import cofh.archersparadox.init.APEntities;
import cofh.archersparadox.init.APItems;
import cofh.lib.item.ArrowItemCoFH;
import cofh.lib.util.Utils;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class ChallengeArrow
extends AbstractArrow {
    private static final float defaultDamage = 0.0f;
    private static final int DISTANCE_FACTOR = 4;
    private static final int MAX_DISTANCE = 10;
    private static final int DURATION = 200;
    private static final int MISS_DURATION = 600;
    public boolean discharged;
    private Vec3 origin;
    public static final ArrowItemCoFH.IArrowFactory<AbstractArrow> FACTORY = new ArrowItemCoFH.IArrowFactory<AbstractArrow>(){

        public AbstractArrow createArrow(Level world, LivingEntity living) {
            return new ChallengeArrow(world, living);
        }

        public AbstractArrow createArrow(Level world, double posX, double posY, double posZ) {
            return new ChallengeArrow(world, posX, posY, posZ);
        }
    };

    public ChallengeArrow(EntityType<? extends ChallengeArrow> entityIn, Level worldIn) {
        super(entityIn, worldIn);
        this.f_36698_ = 0.0;
    }

    public ChallengeArrow(Level worldIn, LivingEntity shooter) {
        super((EntityType)APEntities.CHALLENGE_ARROW.get(), shooter, worldIn);
        this.f_36698_ = 0.0;
        this.origin = shooter.m_20182_();
    }

    public ChallengeArrow(Level worldIn, double x, double y, double z) {
        super((EntityType)APEntities.CHALLENGE_ARROW.get(), x, y, z, worldIn);
        this.f_36698_ = 0.0;
        this.origin = new Vec3(x, y, z);
    }

    protected ItemStack m_7941_() {
        return this.discharged ? new ItemStack((ItemLike)APItems.TRAINING_ARROW_ITEM.get()) : new ItemStack((ItemLike)APItems.CHALLENGE_ARROW_ITEM.get());
    }

    protected void m_6532_(HitResult raytraceResultIn) {
        Entity entity;
        if (raytraceResultIn.m_6662_() == HitResult.Type.BLOCK && (entity = this.m_37282_()) instanceof Player) {
            Player shooter = (Player)entity;
            if (!Utils.isFakePlayer((Entity)this.m_37282_()) && shooter.m_21023_((MobEffect)APEffects.CHALLENGE_STREAK.get())) {
                MobEffectInstance effect = shooter.m_21124_((MobEffect)APEffects.CHALLENGE_STREAK.get());
                shooter.m_7285_(effect);
                shooter.m_6234_((MobEffect)APEffects.CHALLENGE_STREAK.get());
                shooter.m_7292_(new MobEffectInstance((MobEffect)APEffects.CHALLENGE_MISS.get(), 600, 0, false, false));
                shooter.f_19853_.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), SoundEvents.f_11983_, shooter.m_5720_(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
            }
        }
        super.m_6532_(raytraceResultIn);
    }

    protected void m_5790_(EntityHitResult raytraceResultIn) {
        Entity entity = raytraceResultIn.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            Entity entity2 = this.m_37282_();
            if (entity2 instanceof Player) {
                Player shooter = (Player)entity2;
                if (!(Utils.isFakePlayer((Entity)this.m_37282_()) || shooter == target || shooter.m_21023_((MobEffect)APEffects.CHALLENGE_MISS.get()) || shooter.m_21023_((MobEffect)APEffects.CHALLENGE_COMPLETE.get()))) {
                    Vec3 originVec;
                    double distance;
                    int challengeCount = 0;
                    if (shooter.m_21023_((MobEffect)APEffects.CHALLENGE_STREAK.get())) {
                        challengeCount = shooter.m_21124_((MobEffect)APEffects.CHALLENGE_STREAK.get()).m_19564_() + 1;
                    }
                    if ((distance = (originVec = this.origin == null ? shooter.m_20182_() : this.origin).m_82554_(this.m_20182_())) >= (double)Math.min(10, challengeCount)) {
                        int distanceBonus = (int)(4.0 * distance);
                        shooter.m_7292_(new MobEffectInstance((MobEffect)APEffects.CHALLENGE_STREAK.get(), 200 + distanceBonus, challengeCount, false, false));
                        shooter.m_5496_(SoundEvents.f_12211_, 1.0f, Math.min(0.6f + 0.05f * (float)challengeCount, 1.1f));
                        shooter.f_19853_.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), SoundEvents.f_12211_, shooter.m_5720_(), 1.0f, Math.min(0.6f + 0.05f * (float)challengeCount, 1.1f));
                        this.discharged = true;
                    }
                }
            }
        }
        if (this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
            this.m_5552_(this.m_7941_(), 0.1f);
        }
        this.m_146870_();
        this.m_5496_(SoundEvents.f_12333_, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
    }

    public void m_20254_(int seconds) {
    }

    public void m_36735_(int knockbackStrengthIn) {
    }

    public void m_36767_(byte level) {
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

