/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.itemfilters.gui;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.latvian.mods.itemfilters.api.IStringValueFilter;
import dev.latvian.mods.itemfilters.api.StringValueFilterVariant;
import dev.latvian.mods.itemfilters.item.StringValueFilterItem;
import dev.latvian.mods.itemfilters.net.MessageUpdateFilterItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.ComponentRenderUtils;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class StringValueFilterScreen
extends Screen {
    public final IStringValueFilter filter;
    public final ItemStack stack;
    public final InteractionHand hand;
    private final Map<String, StringValueFilterVariant> variants;
    private final ArrayList<StringValueFilterVariant> visibleVariants;
    private EditBox nameField;
    private int selectedVariant = 0;

    public StringValueFilterScreen(IStringValueFilter f, ItemStack is, InteractionHand h) {
        super(is.m_41611_());
        this.filter = f;
        this.stack = is;
        this.hand = h;
        this.variants = new HashMap<String, StringValueFilterVariant>();
        for (StringValueFilterVariant variant : this.filter.getValueVariants(this.stack)) {
            this.variants.put(variant.id, variant);
        }
        this.visibleVariants = new ArrayList<StringValueFilterVariant>(this.variants.values());
        this.visibleVariants.sort(null);
    }

    public void m_7856_() {
        super.m_7856_();
        this.f_96541_.f_91068_.m_90926_(true);
        int i = this.f_96543_ / 2;
        int j = this.f_96544_ / 2;
        int w = this.f_96543_ * 3 / 4;
        this.nameField = new EditBox(this.f_96547_, i - w / 2, j - 6, w, 12, (Component)Component.m_237119_());
        this.nameField.m_94202_(-1);
        this.nameField.m_94205_(-1);
        this.nameField.m_94151_(this::updateVariants);
        this.nameField.m_94199_(4096);
        this.nameField.m_94144_(this.filter.getValue(this.stack));
        this.nameField.m_94178_(true);
        this.m_142416_((GuiEventListener)this.nameField);
    }

    public void m_7379_() {
        super.m_7379_();
        this.f_96541_.f_91068_.m_90926_(true);
    }

    private void updateVariants(String txt) {
        if (!this.variants.isEmpty()) {
            this.visibleVariants.clear();
            txt = this.nameField.m_94155_().toLowerCase();
            if (txt.isEmpty()) {
                this.visibleVariants.addAll(this.variants.values());
            } else {
                for (StringValueFilterVariant variant : this.variants.values()) {
                    if (!variant.id.toLowerCase().contains(txt) && !variant.title.getString().toLowerCase().contains(txt)) continue;
                    this.visibleVariants.add(variant);
                }
            }
            this.visibleVariants.sort(null);
            this.selectedVariant = 0;
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257) {
            String text = !this.variants.isEmpty() && !this.visibleVariants.isEmpty() && this.selectedVariant >= 0 && this.selectedVariant < this.visibleVariants.size() ? this.visibleVariants.get((int)this.selectedVariant).id : this.nameField.m_94155_();
            if (this.variants.isEmpty() || text.isEmpty() || this.variants.containsKey(text)) {
                ItemStack newStack = this.stack.m_41777_();
                this.filter.setValue(newStack, text);
                if (newStack.m_41782_() || text.isEmpty()) {
                    this.f_96541_.m_91152_(null);
                    StringValueFilterVariant variant = this.variants.get(text);
                    this.f_96541_.m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.TUTORIAL_HINT, (Component)Component.m_237113_((String)"Value changed!"), text.isEmpty() ? null : (variant == null ? Component.m_237113_((String)text) : variant.title.m_6881_())));
                    this.f_96541_.f_91074_.m_21008_(this.hand, newStack);
                    new MessageUpdateFilterItem(this.hand, newStack).send();
                } else {
                    this.f_96541_.m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.TUTORIAL_HINT, (Component)Component.m_237113_((String)"Invalid string!"), null));
                }
            } else {
                this.f_96541_.m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.TUTORIAL_HINT, (Component)Component.m_237113_((String)"Invalid string!"), null));
            }
            return true;
        }
        if (keyCode == 258) {
            this.adjustSelected(!Screen.m_96638_());
            return true;
        }
        if (keyCode == 264) {
            this.adjustSelected(true);
            return true;
        }
        if (keyCode == 265) {
            this.adjustSelected(false);
            return true;
        }
        if (this.nameField.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private void adjustSelected(boolean forward) {
        this.selectedVariant += forward ? 1 : -1;
        if (this.selectedVariant < 0) {
            this.selectedVariant = this.visibleVariants.size() - 1;
        } else if (this.selectedVariant >= this.visibleVariants.size()) {
            this.selectedVariant = 0;
        }
    }

    public boolean m_5534_(char typedChar, int keyCode) {
        if (this.nameField.m_5534_(typedChar, keyCode)) {
            return true;
        }
        return super.m_5534_(typedChar, keyCode);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (super.m_6375_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (mouseButton == 1) {
            this.nameField.m_94144_("");
        } else {
            this.nameField.m_6375_(mouseX, mouseY, mouseButton);
            this.nameField.m_94178_(true);
        }
        return true;
    }

    public boolean m_6050_(double d, double e, double delta) {
        this.adjustSelected(delta < 0.0);
        return true;
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        RenderSystem.m_69461_();
        if (!this.variants.isEmpty()) {
            int first;
            Objects.requireNonNull(this.f_96547_);
            int drawY = 4 + 9;
            Objects.requireNonNull(this.f_96547_);
            int nLines = (this.f_96544_ - drawY) / 9;
            StringValueFilterScreen.m_93243_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)Component.m_237110_((String)"itemfilters.variants", (Object[])new Object[]{this.visibleVariants.size()}).m_130940_(ChatFormatting.AQUA), (int)4, (int)4, (int)-1);
            List lines = ComponentRenderUtils.m_94005_((FormattedText)Component.m_237115_((String)"itemfilters.help_text.variants").m_130940_(ChatFormatting.DARK_AQUA), (int)(this.f_96543_ / 2), (Font)this.f_96547_);
            for (int i = 0; i < lines.size(); ++i) {
                FormattedCharSequence line = (FormattedCharSequence)lines.get(i);
                int n = this.f_96543_ - this.f_96547_.m_92724_(line) - 4;
                Objects.requireNonNull(this.f_96547_);
                StringValueFilterScreen.m_168756_((PoseStack)matrixStack, (Font)this.f_96547_, (FormattedCharSequence)line, (int)n, (int)(4 + i * 9), (int)-1);
            }
            for (int i = first = this.visibleVariants.size() < nLines ? 0 : Math.max(0, this.selectedVariant - nLines / 2); i < this.visibleVariants.size(); ++i) {
                Objects.requireNonNull(this.f_96547_);
                if (drawY >= this.f_96544_ - 9) break;
                StringValueFilterVariant variant = this.visibleVariants.get(i);
                StringValueFilterScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)variant.title.getString(), (int)(variant.icon.m_41619_() ? 4 : 14), (int)drawY, (int)(i == this.selectedVariant ? -256 : -1));
                if (!variant.icon.m_41619_()) {
                    PoseStack modelViewStack = RenderSystem.m_157191_();
                    modelViewStack.m_85836_();
                    modelViewStack.m_85837_(4.0, (double)drawY, 0.0);
                    modelViewStack.m_85841_(0.5f, 0.5f, 1.0f);
                    RenderSystem.m_157182_();
                    this.f_96542_.f_115093_ = 100.0f;
                    RenderSystem.m_69482_();
                    Lighting.m_84931_();
                    this.f_96542_.m_115203_(variant.icon, 0, 0);
                    this.f_96542_.m_115174_(this.f_96547_, variant.icon, 0, 0, "");
                    this.f_96542_.f_115093_ = 0.0f;
                    modelViewStack.m_85849_();
                    RenderSystem.m_157182_();
                }
                Objects.requireNonNull(this.f_96547_);
                drawY += 9;
            }
            this.nameField.f_93620_ = this.f_96543_ / 2;
            this.nameField.m_93674_(this.f_96543_ / 3);
            MutableComponent mutableComponent = Component.m_237115_((String)"itemfilters.help_text.filter");
            int n = this.nameField.f_93620_;
            int n2 = this.nameField.f_93621_;
            Objects.requireNonNull(this.f_96547_);
            StringValueFilterScreen.m_93243_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)mutableComponent, (int)n, (int)(n2 - 9 - 2), (int)-1);
        } else {
            int w = this.f_96543_ * 3 / 4;
            this.nameField.f_93620_ = (this.f_96543_ - w) / 2;
            this.nameField.m_93674_(w);
            Object lines = this.stack.m_41720_();
            if (lines instanceof StringValueFilterItem) {
                StringValueFilterItem filterItem = (StringValueFilterItem)lines;
                lines = ComponentRenderUtils.m_94005_((FormattedText)Component.m_237115_((String)filterItem.getHelpKey()), (int)this.nameField.m_5711_(), (Font)this.f_96547_);
                int n = this.nameField.f_93621_ - 3;
                Objects.requireNonNull(this.f_96547_);
                int textY = n - 9 * lines.size();
                int color = -1;
                Iterator iterator = lines.iterator();
                while (iterator.hasNext()) {
                    FormattedCharSequence line = (FormattedCharSequence)iterator.next();
                    StringValueFilterScreen.m_168756_((PoseStack)matrixStack, (Font)this.f_96547_, (FormattedCharSequence)line, (int)this.nameField.f_93620_, (int)textY, (int)color);
                    color = -6710887;
                    Objects.requireNonNull(this.f_96547_);
                    textY += 9;
                }
            }
        }
    }
}

