/*
 * Decompiled with CFR 0.152.
 */
package me.duquee.createutilities.blocks.voidtypes.motor;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.simibubi.create.content.redstone.link.RedstoneLinkNetworkHandler;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.WorldHelper;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import me.duquee.createutilities.CreateUtilities;
import me.duquee.createutilities.blocks.voidtypes.motor.VoidMotorLinkBehaviour;
import me.duquee.createutilities.blocks.voidtypes.motor.VoidMotorTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;

public class VoidMotorNetworkHandler {
    static final Map<LevelAccessor, Map<NetworkKey, Set<BlockPos>>> connections = new IdentityHashMap<LevelAccessor, Map<NetworkKey, Set<BlockPos>>>();

    public Set<BlockPos> getNetworkOf(LevelAccessor world, VoidMotorLinkBehaviour actor) {
        NetworkKey key;
        Map<NetworkKey, Set<BlockPos>> networksInWorld = this.networksIn(world);
        if (!networksInWorld.containsKey(key = actor.getNetworkKey())) {
            networksInWorld.put(key, new LinkedHashSet());
        }
        return networksInWorld.get(key);
    }

    public Map<NetworkKey, Set<BlockPos>> networksIn(LevelAccessor world) {
        if (!connections.containsKey(world)) {
            CreateUtilities.LOGGER.warn("Tried to Access unprepared network space of " + WorldHelper.getDimensionID((LevelAccessor)world));
            return new HashMap<NetworkKey, Set<BlockPos>>();
        }
        return connections.get(world);
    }

    public void onLoadWorld(LevelAccessor world) {
        connections.put(world, new HashMap());
        CreateUtilities.LOGGER.debug("Prepared Void Motor Network Space for " + WorldHelper.getDimensionID((LevelAccessor)world));
    }

    public void onUnloadWorld(LevelAccessor world) {
        connections.remove(world);
        CreateUtilities.LOGGER.debug("Removed Void Motor Network Space for " + WorldHelper.getDimensionID((LevelAccessor)world));
    }

    public void addToNetwork(LevelAccessor world, VoidMotorLinkBehaviour actor) {
        this.getNetworkOf(world, actor).add(actor.getPos());
        SmartBlockEntity smartBlockEntity = actor.blockEntity;
        if (smartBlockEntity instanceof VoidMotorTileEntity) {
            VoidMotorTileEntity voidMotor = (VoidMotorTileEntity)smartBlockEntity;
            voidMotor.onConnectToVoidNetwork();
        }
    }

    public void removeFromNetwork(LevelAccessor world, VoidMotorLinkBehaviour actor) {
        SmartBlockEntity smartBlockEntity = actor.blockEntity;
        if (smartBlockEntity instanceof VoidMotorTileEntity) {
            VoidMotorTileEntity voidMotor = (VoidMotorTileEntity)smartBlockEntity;
            voidMotor.onDisconnectFromVoidNetwork();
        }
        Set<BlockPos> network = this.getNetworkOf(world, actor);
        network.remove(actor.getPos());
        if (network.isEmpty()) {
            this.networksIn(world).remove(actor.getNetworkKey());
        }
    }

    public static class NetworkKey {
        @Nullable
        public final GameProfile owner;
        public final Couple<RedstoneLinkNetworkHandler.Frequency> frequencies;

        public NetworkKey(@Nullable GameProfile owner, RedstoneLinkNetworkHandler.Frequency frequencyFirst, RedstoneLinkNetworkHandler.Frequency frequencySecond) {
            this.owner = owner;
            this.frequencies = Couple.create((Object)frequencyFirst, (Object)frequencySecond);
        }

        public void writeToBuffer(FriendlyByteBuf buffer) {
            buffer.m_130055_(((RedstoneLinkNetworkHandler.Frequency)this.frequencies.get(true)).getStack());
            buffer.m_130055_(((RedstoneLinkNetworkHandler.Frequency)this.frequencies.get(false)).getStack());
            buffer.writeBoolean(this.owner != null);
            if (this.owner != null) {
                buffer.m_236803_(this.owner);
            }
        }

        public static NetworkKey fromBuffer(FriendlyByteBuf buffer) {
            ItemStack frequencyFirst = buffer.m_130267_();
            ItemStack frequencyLast = buffer.m_130267_();
            GameProfile owner = null;
            if (buffer.readBoolean()) {
                owner = buffer.m_236875_();
            }
            return new NetworkKey(owner, RedstoneLinkNetworkHandler.Frequency.of((ItemStack)frequencyFirst), RedstoneLinkNetworkHandler.Frequency.of((ItemStack)frequencyLast));
        }

        public int hashCode() {
            return Objects.hash(this.owner, this.frequencies);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            NetworkKey other = (NetworkKey)obj;
            return Objects.equals(this.owner, other.owner) && this.frequencies.equals(other.frequencies);
        }

        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            if (this.owner != null) {
                CompoundTag tag_ = new CompoundTag();
                NbtUtils.m_129230_((CompoundTag)tag_, (GameProfile)this.owner);
                tag.m_128365_("Owner", (Tag)tag_);
            }
            tag.m_128365_("FrequencyFirst", (Tag)((RedstoneLinkNetworkHandler.Frequency)this.frequencies.get(true)).getStack().m_41739_(new CompoundTag()));
            tag.m_128365_("FrequencyLast", (Tag)((RedstoneLinkNetworkHandler.Frequency)this.frequencies.get(false)).getStack().m_41739_(new CompoundTag()));
            return tag;
        }

        public static NetworkKey deserialize(CompoundTag tag) {
            RedstoneLinkNetworkHandler.Frequency frequencyFirst = RedstoneLinkNetworkHandler.Frequency.of((ItemStack)ItemStack.m_41712_((CompoundTag)tag.m_128469_("FrequencyFirst")));
            RedstoneLinkNetworkHandler.Frequency frequencyLast = RedstoneLinkNetworkHandler.Frequency.of((ItemStack)ItemStack.m_41712_((CompoundTag)tag.m_128469_("FrequencyLast")));
            GameProfile owner = tag.m_128425_("Owner", 10) ? NbtUtils.m_129228_((CompoundTag)tag.m_128469_("Owner")) : null;
            return new NetworkKey(owner, frequencyFirst, frequencyLast);
        }

        public String toString() {
            return this.serialize().toString();
        }

        public static NetworkKey fromString(String json) {
            CompoundTag tag;
            try {
                tag = TagParser.m_129359_((String)json);
            }
            catch (CommandSyntaxException e) {
                CreateUtilities.LOGGER.error("Tried to load invalid NetworkKey '" + json + "'");
                return null;
            }
            return NetworkKey.deserialize(tag);
        }
    }
}

