/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.energeticsheep.capability.energystorage;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyStorageItem
implements IEnergyStorage {
    private final int capacity;
    private final ItemStack itemStack;

    public EnergyStorageItem(int capacity, ItemStack itemStack) {
        this.capacity = capacity;
        this.itemStack = itemStack;
    }

    public int getEnergyStored() {
        CompoundTag tag = this.itemStack.m_41783_();
        return tag == null ? 0 : tag.m_128451_("energy");
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    public int receiveEnergy(int energy, boolean simulate) {
        int stored = this.getEnergyStored();
        int energyReceived = Math.min(this.getMaxEnergyStored() - stored, energy);
        if (!simulate) {
            this.setEnergy(this.itemStack, stored + energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(int energy, boolean simulate) {
        int stored = this.getEnergyStored();
        int newEnergy = Math.max(stored - energy, 0);
        if (!simulate) {
            this.setEnergy(this.itemStack, newEnergy);
        }
        return stored - newEnergy;
    }

    protected void setEnergy(ItemStack itemStack, int energy) {
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128405_("energy", energy);
    }
}

