/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat;

import com.almostreliable.unified.recipe.ClientRecipeTracker;
import com.almostreliable.unified.utils.Utils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public final class RecipeIndicator {
    public static final int RENDER_SIZE = 10;
    private static final int TEXTURE_SIZE = 16;
    private static final ResourceLocation TEXTURE = Utils.getRL("textures/ingot.png");

    private RecipeIndicator() {
    }

    static List<Component> constructTooltip(ClientRecipeTracker.ClientRecipeLink link) {
        MutableComponent unified = Component.m_237115_((String)Utils.prefix("unified")).m_130946_(": ").m_130938_(c -> c.m_131140_(ChatFormatting.AQUA));
        unified.m_7220_((Component)Component.m_237115_((String)Utils.prefix(link.isUnified() ? "yes" : "no")).m_130938_(c -> c.m_131140_(ChatFormatting.WHITE)));
        MutableComponent duplicate = Component.m_237115_((String)Utils.prefix("duplicate")).m_130946_(": ").m_130938_(c -> c.m_131140_(ChatFormatting.AQUA));
        duplicate.m_7220_((Component)Component.m_237115_((String)Utils.prefix(link.isDuplicate() ? "yes" : "no")).m_130938_(c -> c.m_131140_(ChatFormatting.WHITE)));
        return List.of(Component.m_237115_((String)Utils.prefix("description")).m_130938_(c -> c.m_131140_(ChatFormatting.GOLD)), Component.m_237113_((String)""), unified, duplicate, Component.m_237113_((String)""), Component.m_237115_((String)Utils.prefix("warning")).m_130938_(c -> c.m_131140_(ChatFormatting.RED)));
    }

    static void renderTooltip(PoseStack poseStack, ClientRecipeTracker.ClientRecipeLink link, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        Screen screen = mc.f_91080_;
        if (screen == null) {
            return;
        }
        List tooltip = RecipeIndicator.constructTooltip(link).stream().map(c -> font.m_92923_((FormattedText)c, screen.f_96543_ - (int)mouseX - 200)).flatMap(Collection::stream).toList();
        screen.m_96617_(poseStack, tooltip, (int)mouseX, (int)mouseY);
    }

    static void renderIndicator(PoseStack poseStack, Rect2i area) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)area.m_110085_(), (double)area.m_110086_(), 0.0);
        float scale = (float)area.m_110090_() / 16.0f;
        poseStack.m_85841_(scale, scale, scale);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        poseStack.m_85849_();
    }
}

