/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.toolbelt.inventory;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.impl.toolbelt.ModularToolbeltItem;
import se.mickelus.tetra.items.modular.impl.toolbelt.SlotType;

@ParametersAreNonnullByDefault
public class ToolbeltInventory
implements Container {
    protected static final String slotKey = "slot";
    protected final String inventoryKey;
    protected ItemStack toolbeltItemStack;
    protected SlotType inventoryType;
    protected NonNullList<ItemStack> inventoryContents;
    protected int numSlots = 0;
    protected int maxSize = 0;
    protected Predicate<ItemStack> predicate = itemStack -> true;

    public ToolbeltInventory(String inventoryKey, ItemStack stack, int maxSize, SlotType inventoryType) {
        this.inventoryKey = inventoryKey;
        this.toolbeltItemStack = stack;
        this.inventoryType = inventoryType;
        this.maxSize = maxSize;
        this.inventoryContents = NonNullList.m_122780_((int)maxSize, (Object)ItemStack.f_41583_);
    }

    protected static Predicate<ItemStack> getPredicate(String inventory) {
        TagKey acceptKey = ItemTags.create((ResourceLocation)new ResourceLocation("tetra", "toolbelt/" + inventory + "_accept"));
        TagKey rejectKey = ItemTags.create((ResourceLocation)new ResourceLocation("tetra", "toolbelt/" + inventory + "_reject"));
        ITag acceptTag = ForgeRegistries.ITEMS.tags().getTag(acceptKey);
        return itemStack -> (acceptTag.isEmpty() || itemStack.m_204117_(acceptKey)) && !itemStack.m_204117_(rejectKey);
    }

    public void readFromNBT(CompoundTag compound) {
        ListTag items = compound.m_128437_(this.inventoryKey, 10);
        for (int i = 0; i < items.size(); ++i) {
            CompoundTag itemTag = items.m_128728_(i);
            int slot = itemTag.m_128445_(slotKey) & 0xFF;
            if (0 > slot || slot >= this.maxSize) continue;
            this.inventoryContents.set(slot, (Object)ItemStack.m_41712_((CompoundTag)itemTag));
        }
    }

    public void writeToNBT(CompoundTag tagcompound) {
        ListTag items = new ListTag();
        for (int i = 0; i < this.maxSize; ++i) {
            if (this.m_8020_(i) == null) continue;
            CompoundTag compound = new CompoundTag();
            this.m_8020_(i).m_41739_(compound);
            compound.m_128344_(slotKey, (byte)i);
            items.add((Object)compound);
        }
        tagcompound.m_128365_(this.inventoryKey, (Tag)items);
    }

    public int m_6643_() {
        return this.numSlots;
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            if (this.m_8020_(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.inventoryContents.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        ItemStack itemstack = ContainerHelper.m_18969_(this.inventoryContents, (int)index, (int)count);
        if (!itemstack.m_41619_()) {
            this.m_6596_();
        }
        return itemstack;
    }

    public ItemStack m_8016_(int index) {
        ItemStack itemStack = (ItemStack)this.inventoryContents.get(index);
        if (itemStack.m_41619_()) {
            return itemStack;
        }
        this.inventoryContents.set(index, (Object)ItemStack.f_41583_);
        return itemStack;
    }

    public void m_6836_(int index, ItemStack stack) {
        this.inventoryContents.set(index, (Object)stack);
        if (!stack.m_41619_() && stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public int m_6893_() {
        return 64;
    }

    public void m_6596_() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            if (this.m_8020_(i).m_41613_() != 0) continue;
            this.inventoryContents.set(i, (Object)ItemStack.f_41583_);
        }
        this.writeToNBT(this.toolbeltItemStack.m_41784_());
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_5856_(Player player) {
    }

    public void m_5785_(Player player) {
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return this.isItemValid(stack);
    }

    public void m_6211_() {
        this.inventoryContents.clear();
    }

    public ItemStack takeItemStack(int index) {
        ItemStack itemStack = this.m_8020_(index);
        this.m_6836_(index, ItemStack.f_41583_);
        return itemStack;
    }

    public void emptyOverflowSlots(Player player) {
        for (int i = this.m_6643_(); i < this.maxSize; ++i) {
            this.moveStackToPlayer(this.m_8016_(i), player);
        }
        this.m_6596_();
    }

    protected void moveStackToPlayer(ItemStack itemStack, Player player) {
        if (!itemStack.m_41619_() && !player.m_150109_().m_36054_(itemStack)) {
            player.m_36176_(itemStack, false);
        }
    }

    public boolean isItemValid(ItemStack itemStack) {
        return !((ModularToolbeltItem)ModularToolbeltItem.instance.get()).equals(itemStack.m_41720_()) && this.predicate.test(itemStack);
    }

    public boolean storeItemInInventory(ItemStack itemStack) {
        int i;
        if (!this.isItemValid(itemStack)) {
            return false;
        }
        for (i = 0; i < this.m_6643_(); ++i) {
            ItemStack storedStack = this.m_8020_(i);
            if (!ItemStack.m_41746_((ItemStack)itemStack, (ItemStack)storedStack) || !ItemStack.m_41658_((ItemStack)itemStack, (ItemStack)storedStack) || storedStack.m_41613_() >= storedStack.m_41741_()) continue;
            int moveCount = Math.min(itemStack.m_41613_(), storedStack.m_41741_() - storedStack.m_41613_());
            storedStack.m_41769_(moveCount);
            this.m_6836_(i, storedStack);
            itemStack.m_41774_(moveCount);
            if (!itemStack.m_41619_()) continue;
            return true;
        }
        for (i = 0; i < this.m_6643_(); ++i) {
            if (!this.m_8020_(i).m_41619_()) continue;
            this.m_6836_(i, itemStack);
            return true;
        }
        return false;
    }

    public int getFirstIndexForItem(Item item) {
        for (int i = 0; i < this.inventoryContents.size(); ++i) {
            if (((ItemStack)this.inventoryContents.get(i)).m_41619_() || !((ItemStack)this.inventoryContents.get(i)).m_41720_().equals(item)) continue;
            return i;
        }
        return -1;
    }

    public List<Collection<ItemEffect>> getSlotEffects() {
        return ((ModularToolbeltItem)ModularToolbeltItem.instance.get()).getSlotEffects(this.toolbeltItemStack, this.inventoryType);
    }
}

