/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.cell;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;
import se.mickelus.tetra.blocks.forged.ForgedBlockCommon;
import se.mickelus.tetra.items.TetraItem;
import se.mickelus.tetra.items.TetraItemGroup;

@ParametersAreNonnullByDefault
public class ThermalCellItem
extends TetraItem {
    public static final int maxCharge = 128;
    public static final String identifier = "thermal_cell";
    public static RegistryObject<ThermalCellItem> instance;
    private final String chargedPropKey = "tetra:charged";

    public ThermalCellItem() {
        super(new Item.Properties().m_41487_(1).m_41503_(128).m_41491_((CreativeModeTab)TetraItemGroup.instance));
    }

    public static int getCharge(ItemStack itemStack) {
        return itemStack.m_41776_() - itemStack.m_41773_();
    }

    public static int drainCharge(ItemStack itemStack, int amount) {
        if (itemStack.m_41773_() + amount < itemStack.m_41776_()) {
            itemStack.m_41721_(itemStack.m_41773_() + amount);
            return amount;
        }
        int actualAmount = itemStack.m_41776_() - itemStack.m_41773_();
        itemStack.m_41721_(itemStack.m_41776_());
        return actualAmount;
    }

    public static int recharge(ItemStack itemStack, int amount) {
        if (itemStack.m_41773_() - amount >= 0) {
            itemStack.m_41721_(itemStack.m_41773_() - amount);
            return 0;
        }
        int overfill = amount - itemStack.m_41773_();
        itemStack.m_41721_(0);
        return overfill;
    }

    @Override
    public void clientInit() {
        ItemProperties.register((Item)this, (ResourceLocation)new ResourceLocation("tetra:charged"), (itemStack, world, livingEntity, i) -> ThermalCellItem.getCharge(itemStack) > 0 ? 1.0f : 0.0f);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag advanced) {
        int charge = ThermalCellItem.getCharge(stack);
        MutableComponent chargeLine = Component.m_237115_((String)"item.tetra.thermal_cell.charge");
        if (charge == 128) {
            chargeLine.m_7220_((Component)Component.m_237115_((String)"item.tetra.thermal_cell.charge_full"));
        } else if ((double)charge > 51.2) {
            chargeLine.m_7220_((Component)Component.m_237115_((String)"item.tetra.thermal_cell.charge_good"));
        } else if (charge > 0) {
            chargeLine.m_7220_((Component)Component.m_237115_((String)"item.tetra.thermal_cell.charge_low"));
        } else {
            chargeLine.m_7220_((Component)Component.m_237115_((String)"item.tetra.thermal_cell.charge_empty"));
        }
        tooltip.add((Component)chargeLine);
        tooltip.add((Component)Component.m_237113_((String)" "));
        tooltip.add((Component)Component.m_237113_((String)" "));
        tooltip.add(ForgedBlockCommon.locationTooltip);
    }

    public void m_6787_(CreativeModeTab itemGroup, NonNullList<ItemStack> itemList) {
        if (this.m_220152_(itemGroup)) {
            itemList.add((Object)new ItemStack((ItemLike)this));
            ItemStack emptyStack = new ItemStack((ItemLike)this);
            emptyStack.m_41721_(128);
            itemList.add((Object)emptyStack);
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }
}

