/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.forge.datagen.xplat;

import at.petrak.hexcasting.common.items.ItemFocus;
import at.petrak.hexcasting.common.items.ItemScroll;
import at.petrak.hexcasting.common.items.ItemSlate;
import at.petrak.hexcasting.common.items.ItemStaff;
import at.petrak.hexcasting.common.items.colorizer.ItemPrideColorizer;
import at.petrak.hexcasting.common.items.magic.ItemMediaBattery;
import at.petrak.hexcasting.common.items.magic.ItemPackagedHex;
import at.petrak.hexcasting.common.lib.HexBlocks;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.paucal.api.forge.datagen.PaucalItemModelProvider;
import java.util.Objects;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class HexItemModels
extends PaucalItemModelProvider {
    private static final String[] PHIAL_SIZES = new String[]{"small", "medium", "large"};

    public HexItemModels(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "hexcasting", existingFileHelper);
    }

    private static String getPath(Item item) {
        return Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item)).m_135815_();
    }

    private static String getPath(Block block) {
        return Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_();
    }

    /*
     * WARNING - void declaration
     */
    protected void registerModels() {
        void var2_5;
        this.simpleItem(HexItems.AMETHYST_DUST);
        this.simpleItem(HexItems.CHARGED_AMETHYST);
        this.simpleItem(HexItems.SUBMARINE_SANDWICH);
        this.simpleItem(HexItems.ABACUS);
        this.brandishedItem((Item)HexItems.JEWELER_HAMMER);
        this.simpleItem(HexItems.CREATIVE_UNLOCKER);
        this.simpleItem(HexItems.LORE_FRAGMENT);
        this.singleTexture(HexItemModels.getPath(HexBlocks.CONJURED_BLOCK), new ResourceLocation("item/generated"), "layer0", new ResourceLocation("item/amethyst_shard"));
        this.singleTexture(HexItemModels.getPath(HexBlocks.CONJURED_LIGHT), new ResourceLocation("item/generated"), "layer0", new ResourceLocation("item/amethyst_shard"));
        for (String age : new String[]{"pristine", "ancient"}) {
            for (String size : new String[]{"small", "medium", "large"}) {
                this.simpleItem(this.modLoc("scroll_" + age + "_" + size));
            }
        }
        this.buildScroll(HexItems.SCROLL_SMOL, "small");
        this.buildScroll(HexItems.SCROLL_MEDIUM, "medium");
        this.buildScroll(HexItems.SCROLL_LARGE, "large");
        this.simpleItem(HexItems.SCRYING_LENS);
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath(HexItems.SCRYING_LENS))).transforms().transform(ItemTransforms.TransformType.HEAD).rotation(0.0f, 0.0f, 0.0f).translation(-2.5f, 0.0f, -8.0f).scale(0.4f);
        this.singleTexture("old_staff", new ResourceLocation("item/handheld_rod"), "layer0", this.modLoc("item/staves/old"));
        this.singleTexture("bosnia_staff", new ResourceLocation("item/handheld_rod"), "layer0", this.modLoc("item/staves/bosnia"));
        this.buildStaff(HexItems.STAFF_OAK, "oak");
        this.buildStaff(HexItems.STAFF_BIRCH, "birch");
        this.buildStaff(HexItems.STAFF_SPRUCE, "spruce");
        this.buildStaff(HexItems.STAFF_JUNGLE, "jungle");
        this.buildStaff(HexItems.STAFF_DARK_OAK, "dark_oak");
        this.buildStaff(HexItems.STAFF_ACACIA, "acacia");
        this.buildStaff(HexItems.STAFF_CRIMSON, "crimson");
        this.buildStaff(HexItems.STAFF_WARPED, "warped");
        this.buildStaff(HexItems.STAFF_EDIFIED, "edified");
        this.simpleItem(this.modLoc("patchouli_book"));
        this.buildSealableIotaHolder(HexItems.FOCUS, "focus");
        this.buildSealableIotaHolder(HexItems.SPELLBOOK, "spellbook");
        this.buildPackagedSpell(HexItems.CYPHER, "cypher");
        this.buildPackagedSpell(HexItems.TRINKET, "trinket");
        this.buildPackagedSpell(HexItems.ARTIFACT, "artifact");
        int maxFill = 4;
        boolean bl = false;
        while (var2_5 < PHIAL_SIZES.length) {
            for (int fill = 0; fill <= maxFill; ++fill) {
                String name = "phial_" + PHIAL_SIZES[var2_5] + "_" + fill;
                this.singleTexture(name, new ResourceLocation("item/generated"), "layer0", this.modLoc("item/phial/" + name));
                float f = (float)fill / (float)maxFill;
                ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath(HexItems.BATTERY))).override().predicate(ItemMediaBattery.MEDIA_PREDICATE, f).predicate(ItemMediaBattery.MAX_MEDIA_PREDICATE, (float)var2_5).model((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/" + name))).end();
            }
            ++var2_5;
        }
        for (DyeColor dyeColor : DyeColor.values()) {
            this.singleTexture(HexItemModels.getPath(HexItems.DYE_COLORIZERS.get(dyeColor)), new ResourceLocation("item/generated"), "layer0", this.modLoc("item/colorizer/dye_" + dyeColor.m_41065_()));
        }
        for (ItemPrideColorizer.Type type : ItemPrideColorizer.Type.values()) {
            this.singleTexture(HexItemModels.getPath(HexItems.PRIDE_COLORIZERS.get((Object)type)), new ResourceLocation("item/generated"), "layer0", this.modLoc("item/colorizer/pride_" + type.getName()));
        }
        this.singleTexture(HexItemModels.getPath(HexItems.UUID_COLORIZER), new ResourceLocation("item/generated"), "layer0", this.modLoc("item/colorizer/uuid"));
        this.simpleItem(this.modLoc("slate_blank"));
        this.simpleItem(this.modLoc("slate_written"));
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath((Item)HexItems.SLATE))).override().predicate(ItemSlate.WRITTEN_PRED, 0.0f).model((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/slate_blank"))).end().override().predicate(ItemSlate.WRITTEN_PRED, 1.0f).model((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/slate_written"))).end();
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath(HexBlocks.AKASHIC_RECORD))).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/akashic_record")));
        this.simpleItem(this.modLoc("edified_door"));
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath((Block)HexBlocks.EDIFIED_TRAPDOOR))).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/edified_trapdoor_bottom")));
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath((Block)HexBlocks.EDIFIED_LOG))).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/edified_log")));
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath((Block)HexBlocks.STRIPPED_EDIFIED_LOG))).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/stripped_edified_log")));
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath((Block)HexBlocks.EDIFIED_WOOD))).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/edified_wood")));
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath((Block)HexBlocks.STRIPPED_EDIFIED_WOOD))).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/stripped_edified_wood")));
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath((Block)HexBlocks.EDIFIED_STAIRS))).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/edified_stairs")));
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath((Block)HexBlocks.EDIFIED_SLAB))).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/edified_slab")));
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(HexItemModels.getPath((Block)HexBlocks.EDIFIED_BUTTON))).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("block/button_inventory")))).texture("texture", this.modLoc("block/edified_planks"));
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath((Block)HexBlocks.EDIFIED_PRESSURE_PLATE))).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/edified_pressure_plate")));
    }

    private void buildSealableIotaHolder(Item item, String stub) {
        String name = HexItemModels.getPath(item);
        ItemModelBuilder plain = (ItemModelBuilder)this.singleTexture(name, new ResourceLocation("item/generated"), "layer0", this.modLoc("item/" + stub + "_empty"));
        ItemModelBuilder unsealed = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name + "_filled", new ResourceLocation("item/generated"))).texture("layer0", this.modLoc("item/" + stub + "_base"))).texture("layer1", this.modLoc("item/" + stub) + "_overlay");
        ItemModelBuilder sealed = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name + "_sealed", new ResourceLocation("item/generated"))).texture("layer0", this.modLoc("item/" + stub + "_base_sealed"))).texture("layer1", this.modLoc("item/" + stub) + "_overlay_sealed");
        ((ItemModelBuilder)this.getBuilder(name)).override().predicate(ItemFocus.OVERLAY_PRED, 0.0f).model((ModelFile)plain).end().override().predicate(ItemFocus.OVERLAY_PRED, 1.0f).model((ModelFile)unsealed).end().override().predicate(ItemFocus.OVERLAY_PRED, 2.0f).model((ModelFile)sealed).end();
    }

    private void buildScroll(Item item, String size) {
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath(item))).override().predicate(ItemScroll.ANCIENT_PREDICATE, 0.0f).model((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/scroll_pristine_" + size))).end().override().predicate(ItemScroll.ANCIENT_PREDICATE, 1.0f).model((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/scroll_ancient_" + size))).end();
    }

    private void buildStaff(Item item, String name) {
        this.singleTexture(HexItemModels.getPath(item), new ResourceLocation("item/handheld_rod"), "layer0", this.modLoc("item/staves/" + name));
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath(item))).override().predicate(ItemStaff.FUNNY_LEVEL_PREDICATE, 0.0f).model((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/" + name + "_staff"))).end().override().predicate(ItemStaff.FUNNY_LEVEL_PREDICATE, 1.0f).model((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/old_staff"))).end().override().predicate(ItemStaff.FUNNY_LEVEL_PREDICATE, 2.0f).model((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/bosnia_staff"))).end();
    }

    private void buildPackagedSpell(Item item, String name) {
        this.simpleItem(this.modLoc(name));
        this.simpleItem(this.modLoc(name + "_filled"));
        ((ItemModelBuilder)this.getBuilder(HexItemModels.getPath(item))).override().predicate(ItemPackagedHex.HAS_PATTERNS_PRED, -0.01f).model((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/" + name))).end().override().predicate(ItemPackagedHex.HAS_PATTERNS_PRED, 0.99f).model((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/" + name + "_filled"))).end();
    }
}

