/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.command;

import at.petrak.hexcasting.api.PatternRegistry;
import at.petrak.hexcasting.api.spell.math.HexDir;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class PatternResLocArgument
extends ResourceLocationArgument {
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_PATTERN = new DynamicCommandExceptionType(errorer -> Component.m_237110_((String)"hexcasting.pattern.unknown", (Object[])new Object[]{errorer}));

    public static PatternResLocArgument id() {
        return new PatternResLocArgument();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82981_(PatternRegistry.getAllPerWorldPatternNames().stream().map(Object::toString), (SuggestionsBuilder)builder);
    }

    public static HexPattern getPattern(CommandContext<CommandSourceStack> ctx, String pName) throws CommandSyntaxException {
        ResourceLocation targetId = (ResourceLocation)ctx.getArgument(pName, ResourceLocation.class);
        Map<String, Pair<ResourceLocation, HexDir>> lookup = PatternRegistry.getPerWorldPatterns(((CommandSourceStack)ctx.getSource()).m_81372_());
        HexPattern foundPat = null;
        for (String sig : lookup.keySet()) {
            Pair<ResourceLocation, HexDir> rhs = lookup.get(sig);
            if (!((ResourceLocation)rhs.getFirst()).equals((Object)targetId)) continue;
            foundPat = HexPattern.fromAngles(sig, (HexDir)((Object)rhs.getSecond()));
            break;
        }
        if (foundPat == null) {
            throw ERROR_UNKNOWN_PATTERN.create((Object)targetId);
        }
        return foundPat;
    }
}

