/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.misc;

import at.petrak.hexcasting.api.addldata.ADMediaHolder;
import at.petrak.hexcasting.api.spell.casting.CastingContext;
import at.petrak.hexcasting.api.spell.casting.CastingHarness;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class DiscoveryHandlers {
    private static final List<Predicate<Player>> HAS_LENS_PREDICATE = new ArrayList<Predicate<Player>>();
    private static final List<Function<CastingHarness, List<ADMediaHolder>>> MEDIA_HOLDER_DISCOVERY = new ArrayList<Function<CastingHarness, List<ADMediaHolder>>>();
    private static final List<FunctionToFloat<Player>> GRID_SCALE_MODIFIERS = new ArrayList<FunctionToFloat<Player>>();
    private static final List<Function<CastingContext, List<ItemStack>>> ITEM_SLOT_DISCOVERER = new ArrayList<Function<CastingContext, List<ItemStack>>>();
    private static final List<Function<CastingContext, List<ItemStack>>> OPERATIVE_SLOT_DISCOVERER = new ArrayList<Function<CastingContext, List<ItemStack>>>();
    private static final List<BiFunction<Player, String, ItemStack>> DEBUG_DISCOVERER = new ArrayList<BiFunction<Player, String, ItemStack>>();

    public static boolean hasLens(Player player) {
        for (Predicate<Player> predicate : HAS_LENS_PREDICATE) {
            if (!predicate.test(player)) continue;
            return true;
        }
        return false;
    }

    public static List<ADMediaHolder> collectMediaHolders(CastingHarness harness) {
        ArrayList holders = Lists.newArrayList();
        for (Function<CastingHarness, List<ADMediaHolder>> discoverer : MEDIA_HOLDER_DISCOVERY) {
            holders.addAll((Collection)discoverer.apply(harness));
        }
        return holders;
    }

    public static float gridScaleModifier(Player player) {
        float mod = 1.0f;
        for (FunctionToFloat<Player> modifier : GRID_SCALE_MODIFIERS) {
            mod *= modifier.apply(player);
        }
        return mod;
    }

    public static List<ItemStack> collectItemSlots(CastingContext ctx) {
        ArrayList stacks = Lists.newArrayList();
        for (Function<CastingContext, List<ItemStack>> discoverer : ITEM_SLOT_DISCOVERER) {
            stacks.addAll((Collection)discoverer.apply(ctx));
        }
        return stacks;
    }

    public static List<ItemStack> collectOperableSlots(CastingContext ctx) {
        ArrayList stacks = Lists.newArrayList();
        for (Function<CastingContext, List<ItemStack>> discoverer : OPERATIVE_SLOT_DISCOVERER) {
            stacks.addAll((Collection)discoverer.apply(ctx));
        }
        return stacks;
    }

    public static ItemStack findDebugItem(Player player, String type) {
        for (BiFunction<Player, String, ItemStack> discoverer : DEBUG_DISCOVERER) {
            ItemStack stack = discoverer.apply(player, type);
            if (stack.m_41619_()) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static void addLensPredicate(Predicate<Player> predicate) {
        HAS_LENS_PREDICATE.add(predicate);
    }

    public static void addMediaHolderDiscoverer(Function<CastingHarness, List<ADMediaHolder>> discoverer) {
        MEDIA_HOLDER_DISCOVERY.add(discoverer);
    }

    public static void addGridScaleModifier(FunctionToFloat<Player> modifier) {
        GRID_SCALE_MODIFIERS.add(modifier);
    }

    public static void addItemSlotDiscoverer(Function<CastingContext, List<ItemStack>> discoverer) {
        ITEM_SLOT_DISCOVERER.add(discoverer);
    }

    public static void addOperativeSlotDiscoverer(Function<CastingContext, List<ItemStack>> discoverer) {
        OPERATIVE_SLOT_DISCOVERER.add(discoverer);
    }

    public static void addDebugItemDiscoverer(BiFunction<Player, String, ItemStack> discoverer) {
        DEBUG_DISCOVERER.add(discoverer);
    }

    @FunctionalInterface
    public static interface FunctionToFloat<T> {
        public float apply(T var1);
    }
}

