/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.travelerstitles.module;

import com.google.common.collect.Lists;
import com.yungnickyoung.minecraft.travelerstitles.TravelersTitlesCommon;
import com.yungnickyoung.minecraft.travelerstitles.config.TTConfigForge;
import com.yungnickyoung.minecraft.travelerstitles.module.ConfigModule;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ConfigModuleForge {
    public static void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)TTConfigForge.SPEC, "travelerstitles-forge-1_19.toml");
        MinecraftForge.EVENT_BUS.addListener(ConfigModuleForge::onWorldLoad);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ConfigModuleForge::configChanged);
    }

    public static void onWorldLoad(LevelEvent.Load event) {
        ConfigModuleForge.bakeConfig();
        ConfigModule.updateRenderersFromConfig();
    }

    public static void configChanged(ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == TTConfigForge.SPEC) {
            ConfigModuleForge.bakeConfig();
            ConfigModule.updateRenderersFromConfig();
        }
    }

    public static void bakeConfig() {
        TravelersTitlesCommon.CONFIG.biomes.enabled = (Boolean)TTConfigForge.biomes.enabled.get();
        TravelersTitlesCommon.CONFIG.biomes.textFadeInTime = (Integer)TTConfigForge.biomes.textFadeInTime.get();
        TravelersTitlesCommon.CONFIG.biomes.textDisplayTime = (Integer)TTConfigForge.biomes.textDisplayTime.get();
        TravelersTitlesCommon.CONFIG.biomes.textFadeOutTime = (Integer)TTConfigForge.biomes.textFadeOutTime.get();
        TravelersTitlesCommon.CONFIG.biomes.textCooldownTime = (Integer)TTConfigForge.biomes.textCooldownTime.get();
        TravelersTitlesCommon.CONFIG.biomes.textColor = (String)TTConfigForge.biomes.textColor.get();
        TravelersTitlesCommon.CONFIG.biomes.textSize = (Double)TTConfigForge.biomes.textSize.get();
        TravelersTitlesCommon.CONFIG.biomes.renderShadow = (Boolean)TTConfigForge.biomes.renderShadow.get();
        TravelersTitlesCommon.CONFIG.biomes.textYOffset = (Double)TTConfigForge.biomes.textYOffset.get();
        TravelersTitlesCommon.CONFIG.biomes.textXOffset = (Double)TTConfigForge.biomes.textXOffset.get();
        TravelersTitlesCommon.CONFIG.biomes.recentBiomeCacheSize = (Integer)TTConfigForge.biomes.recentBiomeCacheSize.get();
        TravelersTitlesCommon.CONFIG.biomes.centerText = (Boolean)TTConfigForge.biomes.centerText.get();
        TravelersTitlesCommon.CONFIG.biomes.resetBiomeCacheOnDimensionChange = (Boolean)TTConfigForge.biomes.resetBiomeCacheOnDimensionChange.get();
        TravelersTitlesCommon.CONFIG.biomes.onlyUpdateAtSurface = (Boolean)TTConfigForge.biomes.onlyUpdateAtSurface.get();
        TravelersTitlesCommon.CONFIG.biomes.biomeBlacklist = ConfigModuleForge.parseList((String)TTConfigForge.biomes.biomeBlacklist.get(), "Blacklisted Biomes");
        TravelersTitlesCommon.CONFIG.dimensions.enabled = (Boolean)TTConfigForge.dimensions.enabled.get();
        TravelersTitlesCommon.CONFIG.dimensions.textFadeInTime = (Integer)TTConfigForge.dimensions.textFadeInTime.get();
        TravelersTitlesCommon.CONFIG.dimensions.textDisplayTime = (Integer)TTConfigForge.dimensions.textDisplayTime.get();
        TravelersTitlesCommon.CONFIG.dimensions.textFadeOutTime = (Integer)TTConfigForge.dimensions.textFadeOutTime.get();
        TravelersTitlesCommon.CONFIG.dimensions.textColor = (String)TTConfigForge.dimensions.textColor.get();
        TravelersTitlesCommon.CONFIG.dimensions.textSize = (Double)TTConfigForge.dimensions.textSize.get();
        TravelersTitlesCommon.CONFIG.dimensions.renderShadow = (Boolean)TTConfigForge.dimensions.renderShadow.get();
        TravelersTitlesCommon.CONFIG.dimensions.textYOffset = (Double)TTConfigForge.dimensions.textYOffset.get();
        TravelersTitlesCommon.CONFIG.dimensions.textXOffset = (Double)TTConfigForge.dimensions.textXOffset.get();
        TravelersTitlesCommon.CONFIG.dimensions.centerText = (Boolean)TTConfigForge.dimensions.centerText.get();
        TravelersTitlesCommon.CONFIG.dimensions.onlyUpdateAtSurface = (Boolean)TTConfigForge.dimensions.onlyUpdateAtSurface.get();
        TravelersTitlesCommon.CONFIG.dimensions.dimensionBlacklist = ConfigModuleForge.parseList((String)TTConfigForge.dimensions.dimensionBlacklist.get(), "Blacklisted Dimensions");
        TravelersTitlesCommon.CONFIG.sound.biomeVolume = (Double)TTConfigForge.sound.biomeVolume.get();
        TravelersTitlesCommon.CONFIG.sound.biomePitch = (Double)TTConfigForge.sound.biomePitch.get();
        TravelersTitlesCommon.CONFIG.sound.dimensionVolume = (Double)TTConfigForge.sound.dimensionVolume.get();
        TravelersTitlesCommon.CONFIG.sound.dimensionPitch = (Double)TTConfigForge.sound.dimensionPitch.get();
        TravelersTitlesCommon.CONFIG.sound.waystoneVolume = (Double)TTConfigForge.sound.waystoneVolume.get();
        TravelersTitlesCommon.CONFIG.sound.waystonePitch = (Double)TTConfigForge.sound.waystonePitch.get();
        TravelersTitlesCommon.CONFIG.waystones.enabled = (Boolean)TTConfigForge.waystones.enabled.get();
        TravelersTitlesCommon.CONFIG.waystones.textFadeInTime = (Integer)TTConfigForge.waystones.textFadeInTime.get();
        TravelersTitlesCommon.CONFIG.waystones.textDisplayTime = (Integer)TTConfigForge.waystones.textDisplayTime.get();
        TravelersTitlesCommon.CONFIG.waystones.textFadeOutTime = (Integer)TTConfigForge.waystones.textFadeOutTime.get();
        TravelersTitlesCommon.CONFIG.waystones.textCooldownTime = (Integer)TTConfigForge.waystones.textCooldownTime.get();
        TravelersTitlesCommon.CONFIG.waystones.textColor = (String)TTConfigForge.waystones.textColor.get();
        TravelersTitlesCommon.CONFIG.waystones.textSize = (Double)TTConfigForge.waystones.textSize.get();
        TravelersTitlesCommon.CONFIG.waystones.renderShadow = (Boolean)TTConfigForge.waystones.renderShadow.get();
        TravelersTitlesCommon.CONFIG.waystones.textYOffset = (Double)TTConfigForge.waystones.textYOffset.get();
        TravelersTitlesCommon.CONFIG.waystones.textXOffset = (Double)TTConfigForge.waystones.textXOffset.get();
        TravelersTitlesCommon.CONFIG.waystones.recentWaystoneCacheSize = (Integer)TTConfigForge.waystones.recentWaystoneCacheSize.get();
        TravelersTitlesCommon.CONFIG.waystones.centerText = (Boolean)TTConfigForge.waystones.centerText.get();
        TravelersTitlesCommon.CONFIG.waystones.resetWaystoneCacheOnDimensionChange = (Boolean)TTConfigForge.waystones.resetWaystoneCacheOnDimensionChange.get();
        TravelersTitlesCommon.CONFIG.waystones.range = (Integer)TTConfigForge.waystones.range.get();
        TravelersTitlesCommon.CONFIG.waystones.waystonesOverrideBiomeTitle = (Boolean)TTConfigForge.waystones.waystonesOverrideBiomeTitle.get();
        TravelersTitlesCommon.CONFIG.waystones.onlyUpdateAtSurface = (Boolean)TTConfigForge.waystones.onlyUpdateAtSurface.get();
    }

    private static List<String> parseList(String rawStringOfList, String settingName) {
        int strLen = rawStringOfList.length();
        if (strLen < 2 || rawStringOfList.charAt(0) != '[' || rawStringOfList.charAt(strLen - 1) != ']') {
            TravelersTitlesCommon.LOGGER.error("INVALID VALUE FOR SETTING '" + settingName + "'. Using empty list instead...");
            return new ArrayList<String>();
        }
        return Lists.newArrayList((Object[])rawStringOfList.substring(1, strLen - 1).split(",\\s*"));
    }
}

