/*
 * Decompiled with CFR 0.152.
 */
package tfar.unstabletools.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ObjectHolder;
import tfar.unstabletools.crafting.Config;
import tfar.unstabletools.init.ModItems;
import tfar.unstabletools.item.StableDivisionSignItem;

@Mod.EventBusSubscriber
public class DivisionSignItem
extends StableDivisionSignItem {
    @ObjectHolder(registryName="minecraft:block", value="cursedearth:cursed_earth")
    public static final Block cursed_earth = null;

    public DivisionSignItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nonnull
    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        return this.damage(stack.m_41777_());
    }

    public ItemStack damage(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        int d = nbt.m_128451_("d");
        if (--d > 0) {
            nbt.m_128405_("d", d);
            return stack;
        }
        return new ItemStack((ItemLike)ModItems.inactive_division_sign);
    }

    public int m_142158_(ItemStack stack) {
        return (int)((double)(13 * ((Integer)Config.ServerConfig.uses.get() - stack.m_41784_().m_128451_("d"))) / (double)((Integer)Config.ServerConfig.uses.get()).intValue());
    }

    public boolean m_142522_(ItemStack stack) {
        return this == ModItems.division_sign;
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext ctx) {
        boolean skyVisible;
        Player player = ctx.m_43723_();
        InteractionHand hand = ctx.m_43724_();
        Level world = player.f_19853_;
        BlockPos pos = ctx.m_8083_();
        if (hand == InteractionHand.OFF_HAND || world.f_46443_) {
            return InteractionResult.FAIL;
        }
        Block block = world.m_8055_(pos).m_60734_();
        if (block != Blocks.f_50201_) {
            return InteractionResult.FAIL;
        }
        long time = world.m_6106_().m_6792_() % 24000L;
        boolean correctTime = false;
        if (time <= 17500L) {
            DivisionSignItem.message(player, (Component)Component.m_237115_((String)"unstabletools.early"));
        } else if (time <= 18500L) {
            DivisionSignItem.message(player, (Component)Component.m_237115_((String)"unstabletools.ontime"));
            correctTime = true;
        } else {
            DivisionSignItem.message(player, (Component)Component.m_237115_((String)"unstabletools.late"));
        }
        boolean circle = true;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                BlockPos pos1;
                if (i == 0 && j == 0 || world.m_8055_(pos1 = new BlockPos(pos.m_123341_() + i, pos.m_123342_(), pos.m_123343_() + j)).m_60734_() == Blocks.f_50088_) continue;
                circle = false;
            }
        }
        if (!circle) {
            DivisionSignItem.message(player, (Component)Component.m_237115_((String)"unstabletools.incomplete"));
        }
        if (!(skyVisible = world.m_46861_(pos.m_7494_()))) {
            DivisionSignItem.message(player, (Component)Component.m_237115_((String)"unstabletools.nosky"));
        }
        if (correctTime && circle && skyVisible) {
            DivisionSignItem.message(player, (Component)Component.m_237115_((String)"unstabletools.ready"));
        }
        return InteractionResult.PASS;
    }

    private static void message(Player player, Component component) {
        player.m_213846_(component);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (Screen.m_96638_() && this == ModItems.inactive_division_sign) {
            tooltip.add((Component)Component.m_237113_((String)"Drops from Wither").m_130940_(ChatFormatting.AQUA));
        }
        if (this != ModItems.division_sign || !stack.m_41782_()) {
            return;
        }
        tooltip.add((Component)Component.m_237113_((String)("Uses Left: " + stack.m_41783_().m_128451_("d"))));
    }

    @SubscribeEvent
    public static void onSacrifice(LivingDeathEvent e) {
        Entity entity = e.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        LivingEntity sacrifice = e.getEntity();
        Level world = sacrifice.f_19853_;
        BlockPos pos = sacrifice.m_20183_();
        if (!world.m_46861_(pos)) {
            return;
        }
        Block block = world.m_8055_(pos).m_60734_();
        if (block != Blocks.f_50201_) {
            return;
        }
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                BlockPos pos1;
                if (i == 0 && j == 0 || world.m_8055_(pos1 = new BlockPos(pos.m_123341_() + i, pos.m_123342_(), pos.m_123343_() + j)).m_60734_() == Blocks.f_50088_) continue;
                return;
            }
        }
        long time = world.m_6106_().m_6792_() % 24000L;
        if (time <= 17500L || time > 18500L) {
            return;
        }
        NonNullList mainInventory = player.m_150109_().f_35974_;
        for (int i = 0; i < mainInventory.size(); ++i) {
            ItemStack stack = (ItemStack)mainInventory.get(i);
            if (stack.m_41720_() != ModItems.inactive_division_sign && stack.m_41720_() != ModItems.division_sign) continue;
            ItemStack newStack = new ItemStack((ItemLike)ModItems.division_sign);
            newStack.m_41784_().m_128405_("d", ((Integer)Config.ServerConfig.uses.get()).intValue());
            mainInventory.set(i, (Object)newStack);
        }
        if (!world.f_46443_) {
            LightningBolt entity2 = (LightningBolt)EntityType.f_20465_.m_20615_(world);
            entity2.m_6027_(sacrifice.m_20185_(), sacrifice.m_20186_(), sacrifice.m_20189_());
            world.m_7967_((Entity)entity2);
        }
        if (ModList.get().isLoaded("cursedearth") && ((Boolean)Config.ServerConfig.cursed_earth_integration.get()).booleanValue()) {
            for (int x = pos.m_123341_() - 7; x < pos.m_123341_() + 8; ++x) {
                block4: for (int z = pos.m_123343_() - 7; z < pos.m_123343_() + 8; ++z) {
                    int y = world.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z) - 1;
                    for (int y1 = y + 7; y1 > y - 7; --y1) {
                        BlockPos pos1 = new BlockPos(x, y1, z);
                        BlockState block1 = world.m_8055_(pos1);
                        if (!block1.m_204336_(BlockTags.f_144274_)) continue;
                        world.m_46597_(pos1, cursed_earth.m_49966_());
                        continue block4;
                    }
                }
            }
        }
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        super.m_6787_(group, items);
        if (this == ModItems.division_sign && (group == this.m_41471_() || group == CreativeModeTab.f_40754_)) {
            ItemStack stack = new ItemStack((ItemLike)this);
            stack.m_41784_().m_128405_("d", ((Integer)Config.ServerConfig.uses.get()).intValue());
            items.add((Object)stack);
        }
    }

    @Override
    public int getColor(ItemStack stack, int tintIndex) {
        return this == ModItems.inactive_division_sign ? 0xFF0000 : 0xEEDD00;
    }
}

