/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.recipe;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.cyclops.everlastingabilities.RegistryEntries;
import org.cyclops.everlastingabilities.ability.AbilityHelpers;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.item.ItemAbilityTotem;
import org.cyclops.everlastingabilities.item.ItemAbilityTotemConfig;

public class TotemRecycleRecipe
extends CustomRecipe {
    private final RandomSource rand = RandomSource.m_216327_();
    private long seed = this.rand.m_188505_();

    public TotemRecycleRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingContainer invCrafting, Level world) {
        if (ItemAbilityTotemConfig.totemCraftingCount <= 0) {
            return false;
        }
        int inputCount = 0;
        for (int i = 0; i < invCrafting.m_6643_(); ++i) {
            ItemStack slot = invCrafting.m_8020_(i);
            if (slot.m_41619_()) continue;
            if (slot.m_41720_() instanceof ItemAbilityTotem) {
                ++inputCount;
                continue;
            }
            return false;
        }
        return inputCount == ItemAbilityTotemConfig.totemCraftingCount;
    }

    public ItemStack assemble(CraftingContainer invCrafting) {
        this.rand.m_188584_(this.seed);
        int inputTargetIndex = this.rand.m_188503_(ItemAbilityTotemConfig.totemCraftingCount);
        NonNullList sortedStacks = NonNullList.m_122779_();
        for (int i = 0; i < invCrafting.m_6643_(); ++i) {
            ItemStack slot = invCrafting.m_8020_(i);
            if (slot.m_41619_()) continue;
            if (slot.m_41720_() instanceof ItemAbilityTotem) {
                sortedStacks.add((Object)invCrafting.m_8020_(i));
                continue;
            }
            return ItemStack.f_41583_;
        }
        Collections.sort(sortedStacks, Comparator.comparingInt(itemStack -> itemStack.m_41783_().hashCode()));
        if (inputTargetIndex >= sortedStacks.size()) {
            return ItemStack.f_41583_;
        }
        Rarity rarity = RegistryEntries.ITEM_ABILITY_TOTEM.m_41460_((ItemStack)sortedStacks.get(inputTargetIndex));
        List<IAbilityType> abilityTypes = AbilityHelpers.getAbilityTypesCrafting(AbilityHelpers.getRegistry());
        if (this.rand.m_188503_(100) < ItemAbilityTotemConfig.totemCraftingRarityIncreasePercent) {
            Rarity newRarity = rarity;
            while (!AbilityHelpers.hasRarityAbilities(abilityTypes, newRarity = newRarity.ordinal() < Rarity.EPIC.ordinal() ? Rarity.values()[newRarity.ordinal() + 1] : rarity)) {
            }
            rarity = newRarity;
        }
        this.rand.m_188584_(this.seed + (long)sortedStacks.stream().mapToInt(itemStack -> itemStack.m_41783_().hashCode()).sum());
        return AbilityHelpers.getRandomTotem(abilityTypes, rarity, this.rand).get();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= ItemAbilityTotemConfig.totemCraftingCount;
    }

    public ItemStack m_8043_() {
        return new ItemStack((ItemLike)RegistryEntries.ITEM_ABILITY_TOTEM);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        ++this.seed;
        NonNullList nonnulllist = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack item = inv.m_8020_(i);
            if (!item.hasCraftingRemainingItem()) continue;
            nonnulllist.set(i, (Object)item.getCraftingRemainingItem());
        }
        return nonnulllist;
    }

    public RecipeSerializer<?> m_7707_() {
        return RegistryEntries.RECIPESERIALIZER_TOTEM_RECYCLE;
    }
}

