/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import com.klikli_dev.modonomicon.network.Message;
import com.klikli_dev.modonomicon.network.Networking;
import com.klikli_dev.modonomicon.network.messages.SyncMultiblockDataMessage;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.event.OnDatapackSyncEvent;

public class MultiblockDataManager
extends SimpleJsonResourceReloadListener {
    public static final String FOLDER = "modonomicon/multiblocks";
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final MultiblockDataManager instance = new MultiblockDataManager();
    private ConcurrentMap<ResourceLocation, Multiblock> multiblocks = new ConcurrentHashMap<ResourceLocation, Multiblock>();
    private boolean loaded;

    private MultiblockDataManager() {
        super(GSON, FOLDER);
    }

    public static MultiblockDataManager get() {
        return instance;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public Multiblock getMultiblock(ResourceLocation id) {
        return (Multiblock)this.multiblocks.get(id);
    }

    public Map<ResourceLocation, Multiblock> getMultiblocks() {
        return this.multiblocks;
    }

    public Message getSyncMessage() {
        return new SyncMultiblockDataMessage(this.multiblocks);
    }

    public void onDatapackSyncPacket(SyncMultiblockDataMessage message) {
        this.preLoad();
        this.multiblocks = message.multiblocks;
        this.onLoadingComplete();
    }

    public void onDatapackSync(OnDatapackSyncEvent event) {
        Message syncMessage = this.getSyncMessage();
        if (event.getPlayer() != null) {
            Networking.sendToSplit(event.getPlayer(), syncMessage);
        } else {
            for (ServerPlayer player : event.getPlayerList().m_11314_()) {
                Networking.sendToSplit(player, syncMessage);
            }
        }
    }

    public void preLoad() {
        this.loaded = false;
        this.multiblocks.clear();
    }

    protected void onLoadingComplete() {
        this.loaded = true;
    }

    protected void apply(Map<ResourceLocation, JsonElement> content, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        this.preLoad();
        for (Map.Entry<ResourceLocation, JsonElement> entry : content.entrySet()) {
            JsonObject json = GsonHelper.m_13918_((JsonElement)entry.getValue(), (String)"multiblock json file");
            ResourceLocation type = ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)json, (String)"type"));
            Multiblock multiblock = LoaderRegistry.getMultiblockJsonLoader(type).fromJson(json);
            multiblock.setId(entry.getKey());
            this.multiblocks.put(multiblock.getId(), multiblock);
        }
        this.onLoadingComplete();
    }
}

