/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.markdown;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookLinkRenderer;
import com.klikli_dev.modonomicon.client.gui.book.markdown.ColorLinkRenderer;
import com.klikli_dev.modonomicon.client.gui.book.markdown.CommandLinkRenderer;
import com.klikli_dev.modonomicon.client.gui.book.markdown.ComponentRenderer;
import com.klikli_dev.modonomicon.client.gui.book.markdown.ItemLinkRenderer;
import com.klikli_dev.modonomicon.client.gui.book.markdown.PatchouliLinkRenderer;
import com.klikli_dev.modonomicon.client.gui.book.markdown.ext.ComponentStrikethroughExtension;
import com.klikli_dev.modonomicon.client.gui.book.markdown.ext.ComponentUnderlineExtension;
import com.klikli_dev.relocated.commonmark.Extension;
import com.klikli_dev.relocated.commonmark.node.Node;
import com.klikli_dev.relocated.commonmark.parser.Parser;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;

public class BookTextRenderer {
    private final Parser markdownParser;
    private final List<Extension> extensions = List.of(ComponentStrikethroughExtension.create(), ComponentUnderlineExtension.create());
    private final Book book;

    public BookTextRenderer(Book book) {
        this.markdownParser = Parser.builder().extensions(this.extensions).build();
        this.book = book;
    }

    public List<MutableComponent> render(String markdown) {
        return this.render(markdown, Style.f_131099_);
    }

    public List<MutableComponent> render(String markdown, Style defaultStyle) {
        ComponentRenderer renderer = new ComponentRenderer.Builder().renderSoftLineBreaks(false).replaceSoftLineBreaksWithSpace(true).linkColor(TextColor.m_131266_((int)0x5555FF)).linkRenderers(List.of(new ColorLinkRenderer(), new BookLinkRenderer(), new ItemLinkRenderer(), new PatchouliLinkRenderer(), new CommandLinkRenderer())).style(defaultStyle).extensions(this.extensions).build();
        Node document = this.markdownParser.parse(markdown);
        return renderer.render(document, this.book);
    }
}

