/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mrbysco.forcecraft.recipe.ForceRecipes;
import com.mrbysco.forcecraft.recipe.MultipleOutputFurnaceRecipe;
import com.mrbysco.forcecraft.registry.ForceRecipeSerializers;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;

public class FreezingRecipe
extends MultipleOutputFurnaceRecipe {
    public FreezingRecipe(ResourceLocation idIn, String groupIn, Ingredient ingredientIn, NonNullList<ItemStack> results, float experienceIn, int cookTimeIn) {
        super((RecipeType)ForceRecipes.FREEZING.get(), idIn, groupIn, ingredientIn, results, 1.0f, experienceIn, cookTimeIn);
    }

    @Override
    public boolean m_5598_() {
        return true;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ForceRegistry.FREEZING_CORE.get());
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ForceRecipeSerializers.FREEZING_SERIALIZER.get();
    }

    public static class SerializerFreezingRecipe
    implements RecipeSerializer<FreezingRecipe> {
        public FreezingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String s = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            JsonArray jsonelement = GsonHelper.m_13885_((JsonObject)json, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)json, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)json, (String)"ingredient");
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonelement);
            if (!json.has("results")) {
                throw new JsonSyntaxException("Missing results, expected to find a string or object");
            }
            NonNullList<ItemStack> nonnulllist = SerializerFreezingRecipe.readItemStacks(GsonHelper.m_13933_((JsonObject)json, (String)"results"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No results for freezing recipe");
            }
            if (nonnulllist.size() > MultipleOutputFurnaceRecipe.MAX_OUTPUT) {
                throw new JsonParseException("Too many results for freezing recipe the max is " + MultipleOutputFurnaceRecipe.MAX_OUTPUT);
            }
            float f = GsonHelper.m_13820_((JsonObject)json, (String)"experience", (float)0.0f);
            int i = GsonHelper.m_13824_((JsonObject)json, (String)"processtime", (int)200);
            return new FreezingRecipe(recipeId, s, ingredient, nonnulllist, f, i);
        }

        private static NonNullList<ItemStack> readItemStacks(JsonArray resultArray) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < resultArray.size(); ++i) {
                if (!resultArray.get(i).isJsonObject()) continue;
                ItemStack stack = ShapedRecipe.m_151274_((JsonObject)resultArray.get(i).getAsJsonObject());
                nonnulllist.add((Object)stack);
            }
            return nonnulllist;
        }

        @Nullable
        public FreezingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String s = buffer.m_130136_(Short.MAX_VALUE);
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int size = buffer.m_130242_();
            NonNullList resultList = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
            for (int j = 0; j < resultList.size(); ++j) {
                resultList.set(j, (Object)buffer.m_130267_());
            }
            float f = buffer.readFloat();
            int i = buffer.m_130242_();
            return new FreezingRecipe(recipeId, s, ingredient, (NonNullList<ItemStack>)resultList, f, i);
        }

        public void toNetwork(FriendlyByteBuf buffer, FreezingRecipe recipe) {
            buffer.m_130070_(recipe.f_43728_);
            recipe.f_43729_.m_43923_(buffer);
            buffer.m_130130_(recipe.resultItems.size());
            for (ItemStack stack : recipe.resultItems) {
                buffer.m_130055_(stack);
            }
            buffer.writeFloat(recipe.f_43731_);
            buffer.m_130130_(recipe.f_43732_);
        }
    }
}

