/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.networking.message;

import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PackChangeMessage {
    public InteractionHand hand;
    public String customName;
    public int color;

    public PackChangeMessage(InteractionHand hand, String customName, int color) {
        this.hand = hand;
        this.customName = customName;
        this.color = color;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.hand == InteractionHand.MAIN_HAND ? 0 : 1);
        buf.m_130070_(this.customName);
        buf.writeInt(this.color);
    }

    public static PackChangeMessage decode(FriendlyByteBuf packetBuffer) {
        return new PackChangeMessage(packetBuffer.readInt() == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, packetBuffer.m_130136_(Short.MAX_VALUE), packetBuffer.readInt());
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ItemStack stack;
            if (ctx.getDirection().getReceptionSide().isServer() && ctx.getSender() != null && ((stack = ctx.getSender().m_21120_(this.hand)).m_41720_() == ForceRegistry.FORCE_PACK.get() || stack.m_41720_() == ForceRegistry.FORCE_BELT.get())) {
                CompoundTag tag = stack.m_41784_();
                tag.m_128405_("Color", this.color);
                stack.m_41751_(tag);
                if (this.customName.isEmpty()) {
                    stack.m_41787_();
                } else if (!stack.m_41786_().getString().equals(this.customName)) {
                    stack.m_41714_((Component)Component.m_237113_((String)this.customName).m_130940_(ChatFormatting.YELLOW));
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

