/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.menu.infuser;

import com.mrbysco.forcecraft.blockentities.InfuserBlockEntity;
import com.mrbysco.forcecraft.menu.slot.SlotForceGems;
import com.mrbysco.forcecraft.registry.ForceMenus;
import com.mrbysco.forcecraft.util.AdvancementUtil;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class InfuserMenu
extends AbstractContainerMenu {
    private InfuserBlockEntity tile;
    private Player player;
    public final int[] validRecipe = new int[1];

    public InfuserMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, InfuserMenu.getTileEntity(playerInventory, data));
    }

    private static InfuserBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.f_35978_.f_19853_.m_7702_(data.m_130135_());
        if (tileAtPos instanceof InfuserBlockEntity) {
            return (InfuserBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileAtPos);
    }

    public InfuserMenu(int id, Inventory playerInventoryIn, InfuserBlockEntity te) {
        super((MenuType)ForceMenus.INFUSER.get(), id);
        this.tile = te;
        this.player = playerInventoryIn.f_35978_;
        this.m_38897_((Slot)new UnlockableSlot((IItemHandler)te.handler, 0, 80, 20));
        this.m_38897_((Slot)new UnlockableSlot((IItemHandler)te.handler, 1, 104, 32));
        this.m_38897_((Slot)new UnlockableSlot((IItemHandler)te.handler, 2, 116, 57));
        this.m_38897_((Slot)new UnlockableSlot((IItemHandler)te.handler, 3, 104, 81));
        this.m_38897_((Slot)new UnlockableSlot((IItemHandler)te.handler, 4, 80, 93));
        this.m_38897_((Slot)new UnlockableSlot((IItemHandler)te.handler, 5, 56, 81));
        this.m_38897_((Slot)new UnlockableSlot((IItemHandler)te.handler, 6, 44, 57));
        this.m_38897_((Slot)new UnlockableSlot((IItemHandler)te.handler, 7, 56, 32));
        this.m_38897_((Slot)new MatrixUpdatingSlot((IItemHandler)te.handler, 8, 80, 57));
        this.m_38897_((Slot)new SlotForceGems((IItemHandler)te.handler, 9, 8, 23));
        this.m_38897_((Slot)new MatrixUpdatingSlot((IItemHandler)te.handler, 10, 8, 5));
        int xPos = 8;
        int yPos = 127;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)playerInventoryIn, x + y * 9 + 9, xPos + x * 18, yPos + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)playerInventoryIn, x, xPos + x * 18, yPos + 58));
        }
        this.trackPower();
        this.trackFluid();
        this.validRecipe[0] = this.tile.hasValidRecipe() ? 1 : 0;
        this.m_38895_(DataSlot.m_39406_((int[])this.validRecipe, (int)0));
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return InfuserMenu.this.tile.processTime;
            }

            public void m_6422_(int value) {
                InfuserMenu.this.tile.processTime = value;
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return InfuserMenu.this.tile.maxProcessTime;
            }

            public void m_6422_(int value) {
                InfuserMenu.this.tile.maxProcessTime = value;
            }
        });
        AdvancementUtil.unlockTierAdvancements(this.player, this.tile.getBookTier());
    }

    private void trackFluid() {
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return InfuserMenu.this.tile.getFluidAmount() & 0xFFFF;
            }

            public void m_6422_(int value) {
                int fluidStored = InfuserMenu.this.tile.getFluidAmount() & 0xFFFF0000;
                InfuserMenu.this.tile.setFluidAmount(fluidStored + (value & 0xFFFF));
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return InfuserMenu.this.tile.getFluidAmount() >> 16 & 0xFFFF;
            }

            public void m_6422_(int value) {
                int fluidStored = InfuserMenu.this.tile.getFluidAmount() & 0xFFFF;
                InfuserMenu.this.tile.setFluidAmount(fluidStored | value << 16);
            }
        });
    }

    private void trackPower() {
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return InfuserMenu.this.tile.getEnergyStored() & 0xFFFF;
            }

            public void m_6422_(int value) {
                int energyStored = InfuserMenu.this.tile.getEnergyStored() & 0xFFFF0000;
                InfuserMenu.this.tile.setEnergyStored(energyStored + (value & 0xFFFF));
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return InfuserMenu.this.tile.getEnergyStored() >> 16 & 0xFFFF;
            }

            public void m_6422_(int value) {
                int energyStored = InfuserMenu.this.tile.getEnergyStored() & 0xFFFF;
                InfuserMenu.this.tile.setEnergyStored(energyStored | value << 16);
            }
        });
    }

    public boolean m_6875_(Player playerIn) {
        return this.tile.m_6542_(playerIn) && !playerIn.m_5833_();
    }

    @Nonnull
    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            int tileSize = 11;
            if (index < 11 ? !this.m_38903_(itemstack1, 11, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, 11, true)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        this.m_6199_(null);
        return itemstack;
    }

    public boolean isWorkAllowed() {
        return this.tile.isWorkAllowed();
    }

    public InfuserBlockEntity getTile() {
        return this.tile;
    }

    public void m_38946_() {
        super.m_38946_();
    }

    public boolean m_6366_(Player player, int id) {
        if (id == 0) {
            this.getTile().startWork();
        }
        return super.m_6366_(player, id);
    }

    public void m_6199_(Container inventoryIn) {
        if (inventoryIn != null) {
            super.m_6199_(inventoryIn);
        }
        this.getTile().m_6596_();
        this.validRecipe[0] = this.tile.updateValidRecipe() ? 1 : 0;
        AdvancementUtil.unlockTierAdvancements(this.player, this.tile.getBookTier());
    }

    public class UnlockableSlot
    extends MatrixUpdatingSlot {
        public UnlockableSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean m_6659_() {
            return this.f_40217_ <= InfuserMenu.this.tile.getBookTier();
        }

        public boolean m_5857_(@Nonnull ItemStack stack) {
            return this.f_40217_ <= InfuserMenu.this.tile.getBookTier() && super.m_5857_(stack);
        }

        @Override
        public int m_6641_() {
            return 1;
        }
    }

    public class MatrixUpdatingSlot
    extends SlotItemHandler {
        public MatrixUpdatingSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public void m_6654_() {
            super.m_6654_();
            InfuserMenu.this.m_6199_(null);
        }

        public int m_6641_() {
            return 1;
        }
    }
}

