/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.tools;

import com.mrbysco.forcecraft.Reference;
import com.mrbysco.forcecraft.capabilities.CapabilityHandler;
import com.mrbysco.forcecraft.capabilities.toolmodifier.IToolModifier;
import com.mrbysco.forcecraft.capabilities.toolmodifier.ToolModCapability;
import com.mrbysco.forcecraft.items.infuser.ForceToolData;
import com.mrbysco.forcecraft.items.infuser.IForceChargingTool;
import com.mrbysco.forcecraft.registry.material.ModToolTiers;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ForceShovelItem
extends ShovelItem
implements IForceChargingTool {
    public List<Reference.MODIFIERS> applicableModifers = new ArrayList<Reference.MODIFIERS>();

    public ForceShovelItem(Item.Properties properties) {
        super(ModToolTiers.FORCE, -7.0f, -3.0f, properties);
        this.setApplicableModifiers();
    }

    public void setApplicableModifiers() {
        this.applicableModifers.add(Reference.MODIFIERS.MOD_CHARGE);
        this.applicableModifers.add(Reference.MODIFIERS.MOD_CHARGEII);
        this.applicableModifers.add(Reference.MODIFIERS.MOD_HEAT);
        this.applicableModifers.add(Reference.MODIFIERS.MOD_LUCK);
        this.applicableModifers.add(Reference.MODIFIERS.MOD_GRINDING);
        this.applicableModifers.add(Reference.MODIFIERS.MOD_TOUCH);
        this.applicableModifers.add(Reference.MODIFIERS.MOD_STURDY);
        this.applicableModifers.add(Reference.MODIFIERS.MOD_REPAIR);
        this.applicableModifers.add(Reference.MODIFIERS.MOD_SPEED);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (CapabilityHandler.CAPABILITY_TOOLMOD == null) {
            return null;
        }
        return new ToolModCapability();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> lores, TooltipFlag flagIn) {
        ForceToolData fd = new ForceToolData(stack);
        fd.attachInformation(lores);
        ToolModCapability.attachInformation(stack, lores);
        super.m_7373_(stack, level, lores, flagIn);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return this.damageItem(stack, amount);
    }

    public int m_6473_() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag nbt = super.getShareTag(stack);
        IToolModifier cap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
        if (cap != null) {
            CompoundTag shareTag = ToolModCapability.writeNBT(cap);
            nbt.m_128365_("forcecraft", (Tag)shareTag);
        }
        return nbt;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        if (nbt == null || !nbt.m_128441_("forcecraft")) {
            return;
        }
        IToolModifier cap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
        if (cap != null) {
            CompoundTag shareTag = nbt.m_128469_("forcecraft");
            ToolModCapability.readNBT(cap, shareTag);
        }
        super.readShareTag(stack, nbt);
    }
}

