/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.tunnel;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;

public class TunnelHelper {
    @Nonnull
    public static Direction getNextDirection(Direction in) {
        return switch (in) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> Direction.DOWN;
            case Direction.DOWN -> Direction.NORTH;
            case Direction.NORTH -> Direction.SOUTH;
            case Direction.SOUTH -> Direction.WEST;
            case Direction.WEST -> Direction.EAST;
            case Direction.EAST -> Direction.UP;
        };
    }

    public static Stream<Direction> getOrderedSides() {
        return Stream.of(Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST);
    }

    public static Optional<Direction> getNextDirection(Direction current, Set<Direction> used) {
        List<Direction> ordered = TunnelHelper.getOrderedSides().toList();
        int found = ordered.indexOf(current);
        Stream stream = Stream.generate(() -> ordered).flatMap(Collection::stream);
        return stream.skip(found + 1).filter(dir -> !used.contains(dir)).findFirst();
    }
}

