/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.command.subcommand;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.compactmods.machines.api.core.CMCommands;
import dev.compactmods.machines.command.argument.RoomPositionArgument;
import dev.compactmods.machines.config.ServerConfig;
import dev.compactmods.machines.i18n.TranslationUtil;
import dev.compactmods.machines.room.Rooms;
import dev.compactmods.machines.room.exceptions.NonexistentRoomException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.ChunkPos;

public class SpawnSubcommand {
    public static ArgumentBuilder<CommandSourceStack, ?> make() {
        LiteralArgumentBuilder spawnRoot = Commands.m_82127_((String)"spawn");
        LiteralArgumentBuilder resetSpawn = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"reset").requires(cs -> cs.m_6761_(ServerConfig.changeRoomSpawn()))).then(Commands.m_82129_((String)"room", (ArgumentType)RoomPositionArgument.room()).executes(SpawnSubcommand::resetRoomSpawn));
        spawnRoot.then((ArgumentBuilder)resetSpawn);
        return spawnRoot;
    }

    private static int resetRoomSpawn(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        MinecraftServer serv = src.m_81377_();
        ChunkPos roomPos = RoomPositionArgument.get(ctx, "room");
        try {
            Rooms.resetSpawn(serv, roomPos);
            src.m_81354_((Component)TranslationUtil.command(CMCommands.SPAWN_CHANGED_SUCCESSFULLY, "%s, %s".formatted(roomPos.f_45578_, roomPos.f_45579_)), true);
            return 0;
        }
        catch (NonexistentRoomException e) {
            src.m_81352_((Component)TranslationUtil.command(CMCommands.ROOM_NOT_FOUND, "%s, %s".formatted(roomPos.f_45578_, roomPos.f_45579_)));
            return -1;
        }
    }
}

