/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsba.tools.integration.jade;

import dev.ftb.ftbsba.tools.content.autohammer.AutoHammerBlock;
import dev.ftb.ftbsba.tools.content.autohammer.AutoHammerBlockEntity;
import java.util.ArrayList;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.minecraftforge.registries.ForgeRegistries;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

@WailaPlugin
public class SBCJadePlugin
implements IWailaPlugin {
    private static final ResourceLocation ID = new ResourceLocation("ftbsba", "blocks");

    public void register(IWailaCommonRegistration registration) {
        registration.registerBlockDataProvider((IServerDataProvider)AutoHammerComponentProvider.INSTANCE, AutoHammerBlockEntity.class);
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent((IBlockComponentProvider)AutoHammerComponentProvider.INSTANCE, AutoHammerBlock.class);
    }

    static enum AutoHammerComponentProvider implements IBlockComponentProvider,
    IServerDataProvider<BlockEntity>
    {
        INSTANCE;


        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            ITooltip tooltip;
            CompoundTag serverData = blockAccessor.getServerData();
            if (!serverData.m_128441_("progress")) {
                return;
            }
            IElementHelper helper = iTooltip.getElementHelper();
            int timeout = serverData.m_128451_("timeout");
            int maxTimeout = serverData.m_128451_("maxTimeout");
            if (timeout == 0) {
                iTooltip.add(helper.progress((float)serverData.m_128451_("progress") / (float)serverData.m_128451_("maxProgress"), null, helper.progressStyle().color(-1392443648), helper.borderStyle().color(0xFFFFFFF)));
            } else {
                iTooltip.add(helper.progress((float)timeout / (float)maxTimeout, null, helper.progressStyle().color(-1375797248), helper.borderStyle().color(0xFFFFFFF)));
            }
            ItemStack inputStack = LightItem.deserialize(serverData.m_128469_("input")).toStack();
            ArrayList<ItemStack> outputItems = new ArrayList<ItemStack>();
            if (serverData.m_128441_("output")) {
                ListTag items = serverData.m_128437_("output", 10);
                for (Tag item : items) {
                    outputItems.add(LightItem.deserialize((CompoundTag)item).toStack());
                }
            }
            if (!inputStack.m_41619_()) {
                iTooltip.add(helper.item(inputStack));
                tooltip = helper.tooltip();
                tooltip.append(helper.text((Component)Component.m_237115_((String)"ftbsba.jade.input")));
                iTooltip.append(helper.box(tooltip, helper.borderStyle().width(0)).align(IElement.Align.RIGHT));
            }
            if (!outputItems.isEmpty()) {
                iTooltip.add(helper.spacer(-5, 0));
                tooltip = helper.tooltip();
                int count = 0;
                float scale = outputItems.size() > 5 ? 0.8f : 1.0f;
                for (ItemStack outputItem : outputItems) {
                    if (count != 0 && count % 5 == 0) {
                        tooltip.add(helper.item(outputItem, scale));
                        count = 0;
                        continue;
                    }
                    tooltip.append(helper.item(outputItem, scale));
                    ++count;
                }
                iTooltip.append(helper.box(tooltip, helper.borderStyle().width(0)));
                ITooltip text = helper.tooltip();
                text.append(helper.text((Component)Component.m_237115_((String)"ftbsba.jade.buffer")));
                iTooltip.append(helper.box(text, helper.borderStyle().width(0)).align(IElement.Align.RIGHT));
            }
        }

        public void appendServerData(CompoundTag compoundTag, ServerPlayer serverPlayer, Level level, BlockEntity blockEntity, boolean b) {
            if (!(blockEntity instanceof AutoHammerBlockEntity)) {
                return;
            }
            AutoHammerBlockEntity autoHammerEntity = (AutoHammerBlockEntity)blockEntity;
            compoundTag.m_128405_("progress", autoHammerEntity.getProgress());
            compoundTag.m_128405_("maxProgress", autoHammerEntity.getMaxProgress());
            compoundTag.m_128405_("timeout", autoHammerEntity.getTimeOut());
            compoundTag.m_128405_("maxTimeout", autoHammerEntity.getTimeoutDuration());
            Direction direction = (Direction)autoHammerEntity.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
            ItemStack inputStack = autoHammerEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, AutoHammerBlockEntity.getInputDirection(direction)).map(h -> h.getStackInSlot(0)).orElse(ItemStack.f_41583_);
            compoundTag.m_128365_("input", (Tag)LightItem.create(inputStack).serialize());
            LazyOptional capability = autoHammerEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, AutoHammerBlockEntity.getOutputDirection(direction));
            IItemHandler inventory = (IItemHandler)capability.orElse((Object)EmptyHandler.INSTANCE);
            ListTag tagItems = new ListTag();
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack stackInSlot = inventory.getStackInSlot(i);
                if (stackInSlot.m_41619_()) continue;
                tagItems.add((Object)new LightItem(ForgeRegistries.ITEMS.getKey((Object)stackInSlot.m_41720_()), stackInSlot.m_41613_()).serialize());
            }
            compoundTag.m_128365_("output", (Tag)tagItems);
        }

        public ResourceLocation getUid() {
            return ID;
        }
    }

    record LightItem(ResourceLocation location, int count) {
        public static LightItem create(ItemStack stack) {
            return new LightItem(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()), stack.m_41613_());
        }

        public static LightItem deserialize(CompoundTag compound) {
            if (!compound.m_128441_("name")) {
                return new LightItem(new ResourceLocation("minecraft:air"), 0);
            }
            return new LightItem(new ResourceLocation(compound.m_128461_("name")), compound.m_128441_("count") ? compound.m_128451_("count") : 1);
        }

        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("count", this.count);
            tag.m_128359_("name", this.location.toString());
            return tag;
        }

        public ItemStack toStack() {
            Item value = (Item)ForgeRegistries.ITEMS.getValue(this.location);
            if (value == null) {
                return ItemStack.f_41583_;
            }
            return new ItemStack((ItemLike)value, this.count);
        }
    }
}

