/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsba.tools.content.fusion;

import com.google.common.collect.Sets;
import dev.ftb.ftbsba.tools.ToolsRegistry;
import dev.ftb.ftbsba.tools.content.core.AbstractMachineBlockEntity;
import dev.ftb.ftbsba.tools.content.core.EmittingEnergy;
import dev.ftb.ftbsba.tools.content.core.EmittingFluidTank;
import dev.ftb.ftbsba.tools.content.core.EmittingStackHandler;
import dev.ftb.ftbsba.tools.content.core.FluidEnergyProcessorContainerData;
import dev.ftb.ftbsba.tools.content.core.RecipeCaches;
import dev.ftb.ftbsba.tools.content.fusion.FusingMachineContainer;
import dev.ftb.ftbsba.tools.recipies.FusingMachineRecipe;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FusingMachineBlockEntity
extends AbstractMachineBlockEntity {
    private final EmittingEnergy energyHandler = new EmittingEnergy(1000000, 10000, 10000, energy -> this.m_6596_());
    private final ExtractOnlyFluidTank fluidHandler = new ExtractOnlyFluidTank(10000, tank -> this.m_6596_());
    private final EmittingStackHandler itemHandler = new EmittingStackHandler(2, contents -> this.onItemHandlerChange());
    private final LazyOptional<EmittingEnergy> energy = LazyOptional.of(() -> this.energyHandler);
    private final LazyOptional<ExtractOnlyFluidTank> tank = LazyOptional.of(() -> this.fluidHandler);
    private final LazyOptional<EmittingStackHandler> input = LazyOptional.of(() -> this.itemHandler);
    private int progress = 0;
    private int progressRequired = 0;
    private boolean recheckRecipe = false;
    private FusingMachineRecipe currentRecipe = null;
    private final FluidEnergyProcessorContainerData containerData = new FluidEnergyProcessorContainerData(this, this);

    public FusingMachineBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ToolsRegistry.FUSING_MACHINE_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void tickServer() {
        if (!this.hasEnoughEnergy() || !this.hasOccupiedInputSlots()) {
            return;
        }
        if (this.recheckRecipe || this.progress == 0) {
            this.recheckRecipe = false;
            this.currentRecipe = RecipeCaches.FUSING_MACHINE.getCachedRecipe(this::findValidRecipe, (IItemHandler)this.itemHandler, null).orElse(null);
            if (this.currentRecipe == null || !this.fluidHandler.isEmpty() && !this.fluidHandler.getFluid().isFluidEqual(this.currentRecipe.fluidResult)) {
                this.progress = 0;
                this.setActive(false);
                return;
            }
            this.progress = Math.max(1, this.progress);
            this.progressRequired = this.currentRecipe.energyComponent.ticksToProcess();
        }
        if (this.currentRecipe != null) {
            if (this.progress == this.progressRequired && this.canAcceptOutput()) {
                this.executeRecipe();
            } else if (this.progress < this.progressRequired) {
                this.setActive(true);
                this.useEnergy();
                ++this.progress;
            }
        }
    }

    private void onItemHandlerChange() {
        if (!this.f_58857_.f_46443_) {
            this.m_6596_();
            this.recheckRecipe = true;
        }
    }

    private boolean canAcceptOutput() {
        return this.currentRecipe != null && this.currentRecipe.fluidResult.getAmount() + this.fluidHandler.getFluidAmount() <= this.fluidHandler.getCapacity();
    }

    private void executeRecipe() {
        Set requiredItems = Sets.newIdentityHashSet();
        requiredItems.addAll(this.currentRecipe.ingredients);
        BitSet extractingSlots = new BitSet(this.itemHandler.getSlots());
        for (Ingredient ingredient : requiredItems) {
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                if (extractingSlots.get(i) || !ingredient.test(this.itemHandler.getStackInSlot(i))) continue;
                if (this.itemHandler.extractItem(i, 1, true).m_41619_()) {
                    this.breakProgress();
                    this.currentRecipe = null;
                    return;
                }
                extractingSlots.set(i);
            }
        }
        if (extractingSlots.cardinality() == this.currentRecipe.ingredients.size()) {
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                if (!extractingSlots.get(i)) continue;
                this.itemHandler.extractItem(i, 1, false);
            }
            this.fluidHandler.forceFill(this.currentRecipe.fluidResult, IFluidHandler.FluidAction.EXECUTE);
        }
        this.breakProgress();
    }

    private void useEnergy() {
        if (this.currentRecipe == null) {
            return;
        }
        int result = this.energyHandler.extractEnergy(this.currentRecipe.energyComponent.fePerTick(), true);
        if (result < this.currentRecipe.energyComponent.fePerTick()) {
            this.breakProgress();
            return;
        }
        this.energyHandler.extractEnergy(this.currentRecipe.energyComponent.fePerTick(), false);
    }

    private void breakProgress() {
        this.progress = 0;
        this.progressRequired = 0;
    }

    private boolean hasEnoughEnergy() {
        return this.energyHandler.getEnergyStored() > (this.currentRecipe == null ? 0 : this.currentRecipe.energyComponent.fePerTick());
    }

    private boolean hasOccupiedInputSlots() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    private Optional<FusingMachineRecipe> findValidRecipe() {
        return this.f_58857_.m_7465_().m_44013_((RecipeType)ToolsRegistry.FUSING_MACHINE_RECIPE_TYPE.get()).stream().sorted((a, b) -> b.ingredients.size() - a.ingredients.size()).filter(this::recipeMatchesInput).findFirst();
    }

    private boolean recipeMatchesInput(FusingMachineRecipe recipe) {
        Set inputSet = Sets.newIdentityHashSet();
        inputSet.addAll(recipe.ingredients);
        int found = 0;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).m_41619_()) continue;
            Iterator iter = inputSet.iterator();
            while (iter.hasNext()) {
                Ingredient ingr = (Ingredient)iter.next();
                if (!ingr.test(this.itemHandler.getStackInSlot(i))) continue;
                iter.remove();
                ++found;
                break;
            }
            if (found != recipe.ingredients.size()) continue;
            return true;
        }
        return false;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.ftbsba.fusing_machine");
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.input.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energy.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.tank.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory arg, Player arg2) {
        if (arg2 instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)arg2;
            this.fluidHandler.needSync(sp);
        }
        return new FusingMachineContainer(i, arg, this.m_58899_());
    }

    public void m_142466_(CompoundTag arg) {
        super.m_142466_(arg);
        this.itemHandler.deserializeNBT(arg.m_128469_("input"));
        this.energyHandler.deserializeNBT(arg.m_128423_("energy"));
        this.fluidHandler.readFromNBT(arg.m_128469_("fluid"));
    }

    protected void m_183515_(CompoundTag arg) {
        super.m_183515_(arg);
        arg.m_128365_("input", (Tag)this.itemHandler.serializeNBT());
        arg.m_128365_("energy", this.energyHandler.serializeNBT());
        arg.m_128365_("fluid", (Tag)this.fluidHandler.writeToNBT(new CompoundTag()));
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.input.invalidate();
        this.energy.invalidate();
        this.tank.invalidate();
    }

    public CompoundTag m_5995_() {
        CompoundTag compoundTag = new CompoundTag();
        this.m_183515_(compoundTag);
        return compoundTag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Override
    public int getEnergy() {
        return this.energyHandler.getEnergyStored();
    }

    @Override
    public int getMaxEnergy() {
        return this.energyHandler.getMaxEnergyStored();
    }

    @Override
    public FluidStack getFluid() {
        return this.fluidHandler.getFluid();
    }

    @Override
    public int getMaxFluid() {
        return this.fluidHandler.getCapacity();
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.fluidHandler.overrideFluidStack(fluid);
    }

    @Override
    public void setEnergy(int energy) {
        this.energyHandler.overrideEnergy(energy);
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public int getMaxProgress() {
        return this.progressRequired;
    }

    @Override
    public void setProgress(int progress) {
        this.progress = progress;
    }

    @Override
    public void setMaxProgress(int maxProgress) {
        this.progressRequired = maxProgress;
    }

    public EmittingStackHandler getItemHandler() {
        return this.itemHandler;
    }

    @Override
    public ContainerData getContainerData() {
        return this.containerData;
    }

    @Override
    public void syncFluidTank() {
        this.fluidHandler.sync(this);
    }

    public static class ExtractOnlyFluidTank
    extends EmittingFluidTank {
        public ExtractOnlyFluidTank(int capacity, Consumer<EmittingFluidTank> listener) {
            super(capacity, listener);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        public int forceFill(FluidStack resource, IFluidHandler.FluidAction action) {
            return super.fill(resource, action);
        }

        public void overrideFluidStack(FluidStack stack) {
            this.fluid = stack;
        }
    }
}

