/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.PedestalUtils;

import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemHandlerHelper;

public class MoveToMowLibUtils {
    public static void modeBasedTextOutputPopup(Player player, int mode, boolean localized, String modid, List<String> modeTextList, List<ChatFormatting> modeColorList) {
        modeTextList.add(".error");
        modeColorList.add(ChatFormatting.DARK_RED);
        int getMode = mode >= modeTextList.size() ? modeTextList.size() - 1 : mode;
        MutableComponent type = localized ? Component.m_237115_((String)(modid + modeTextList.get(getMode))) : Component.m_237113_((String)modeTextList.get(getMode));
        type.m_130940_(modeColorList.get(getMode));
        player.m_5661_((Component)type, true);
    }

    public static void modeBasedTextOutputTooltip(int mode, boolean localized, String modid, List<String> modeTextList, ChatFormatting textColor, List<Component> comp) {
        modeTextList.add(".error");
        int getMode = mode >= modeTextList.size() ? modeTextList.size() - 1 : mode;
        MutableComponent type = localized ? Component.m_237115_((String)(modid + modeTextList.get(getMode))) : Component.m_237113_((String)modeTextList.get(getMode));
        type.m_130940_(textColor);
        comp.add((Component)type);
    }

    public static void resetCachedAbstractCooking(String modID, ItemStack stackToStoreNBT) {
        CompoundTag tag = stackToStoreNBT.m_41784_();
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)modID, (CompoundTag)tag, (String)"cook_ingredient");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)modID, (CompoundTag)tag, (String)"cook_result");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)modID, (CompoundTag)tag, (String)"cook_time");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)modID, (CompoundTag)tag, (String)"cook_xp_gain");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)modID, (CompoundTag)tag, (String)"cook_cached");
    }

    private static boolean hasCachedAbstractCooking(String modID, ItemStack stackToStoreNBT) {
        return MowLibCompoundTagUtils.readBooleanFromNBT((String)modID, (CompoundTag)stackToStoreNBT.m_41784_(), (String)"cook_cached");
    }

    private static boolean cachedAbstractCookingHasSameInput(String modID, ItemStack stackToStoreNBT, ItemStack input) {
        ItemStack cachedInput = MowLibCompoundTagUtils.readItemStackFromNBT((String)modID, (CompoundTag)stackToStoreNBT.m_41784_(), (String)"cook_ingredient");
        return ItemHandlerHelper.canItemStacksStack((ItemStack)input, (ItemStack)cachedInput) || input.m_41619_() && cachedInput.m_41619_();
    }

    private static <T extends AbstractCookingRecipe> ItemStack getAndCacheAbstractCookingResult(String modID, Level level, ItemStack stackToStoreNBT, ItemStack input, RecipeType<T> recipeType) {
        SimpleContainer container = new SimpleContainer(new ItemStack[]{input});
        RecipeManager recipeManager = level.m_7465_();
        Optional result = recipeManager.m_44015_(recipeType, (Container)container, level);
        if (result.isPresent()) {
            AbstractCookingRecipe recipe = (AbstractCookingRecipe)result.get();
            ItemStack resultItem = recipe.m_8043_();
            CompoundTag tag = stackToStoreNBT.m_41784_();
            MowLibCompoundTagUtils.writeItemStackToNBT((String)modID, (CompoundTag)tag, (ItemStack)input, (String)"cook_ingredient");
            MowLibCompoundTagUtils.writeItemStackToNBT((String)modID, (CompoundTag)tag, (ItemStack)resultItem, (String)"cook_result");
            MowLibCompoundTagUtils.writeIntegerToNBT((String)modID, (CompoundTag)tag, (int)recipe.m_43753_(), (String)"cook_time");
            MowLibCompoundTagUtils.writeIntegerToNBT((String)modID, (CompoundTag)tag, (int)Math.round(recipe.m_43750_()), (String)"cook_xp_gain");
            MowLibCompoundTagUtils.writeBooleanToNBT((String)modID, (CompoundTag)tag, (boolean)true, (String)"cook_cached");
            return resultItem;
        }
        MowLibCompoundTagUtils.writeBooleanToNBT((String)modID, (CompoundTag)stackToStoreNBT.m_41784_(), (boolean)false, (String)"cook_cached");
        return ItemStack.f_41583_;
    }

    public static <T extends AbstractCookingRecipe> ItemStack getAbstractCookingResult(String modID, Level level, ItemStack stackToStoreNBT, ItemStack ingredient, RecipeType<T> recipeType) {
        if (MoveToMowLibUtils.hasCachedAbstractCooking(modID, stackToStoreNBT) && MoveToMowLibUtils.cachedAbstractCookingHasSameInput(modID, stackToStoreNBT, ingredient)) {
            return MowLibCompoundTagUtils.readItemStackFromNBT((String)modID, (CompoundTag)stackToStoreNBT.m_41784_(), (String)"cook_result");
        }
        return MoveToMowLibUtils.getAndCacheAbstractCookingResult(modID, level, stackToStoreNBT, ingredient, recipeType);
    }

    public static int getXpGainFromCachedRecipe(String modID, ItemStack stackToStoreNBT) {
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)modID, (CompoundTag)stackToStoreNBT.m_41784_(), (String)"cook_xp_gain");
    }

    public static int getCookTimeRequired(String modID, ItemStack stackToStoreNBT) {
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)modID, (CompoundTag)stackToStoreNBT.m_41784_(), (String)"cook_time");
    }

    public static int getCookTimeElapsed(String modID, ItemStack stackToStoreNBT) {
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)modID, (CompoundTag)stackToStoreNBT.m_41784_(), (String)"cook_time_elapsed");
    }

    public static void setCookTimeElapsed(String modID, ItemStack stackToStoreNBT, int timeElapsed) {
        MowLibCompoundTagUtils.writeIntegerToNBT((String)modID, (CompoundTag)stackToStoreNBT.m_41784_(), (int)timeElapsed, (String)"cook_time_elapsed");
    }

    public static boolean arePositionsInRange(BlockPos posOne, BlockPos posTwo, int range) {
        BlockPos distanceVector = posOne.m_121996_((Vec3i)posTwo);
        return Math.abs(distanceVector.m_123341_()) <= range && Math.abs(distanceVector.m_123342_()) <= range && Math.abs(distanceVector.m_123343_()) <= range;
    }
}

