/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.Capabilities.Dust.IDustHandler;
import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.mowlib.Networking.MowLibPacketHandler;
import com.mowmaster.mowlib.Networking.MowLibPacketParticles;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import com.mowmaster.pedestals.Recipes.CobbleGenRecipe;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ItemUpgradeMaterialGenerator
extends ItemUpgradeBase {
    public ItemUpgradeMaterialGenerator(Item.Properties p_41383_) {
        super(p_41383_);
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyItemCapacity(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyRemoveDurabilityCost(ItemStack upgradeItemStack) {
        return (Boolean)PedestalConfig.COMMON.cobbleGeneratorDamageTools.get();
    }

    @Override
    public boolean canModifyRepairTool(ItemStack upgradeItemStack) {
        return (Boolean)PedestalConfig.COMMON.cobbleGeneratorDamageTools.get();
    }

    @Override
    public int getUpgradeWorkRange(ItemStack coinUpgrade) {
        return 0;
    }

    @Override
    public ItemStack getUpgradeDefaultTool() {
        if (((Boolean)PedestalConfig.COMMON.cobbleGeneratorRequireTools.get()).booleanValue()) {
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)Items.f_42427_);
    }

    @Override
    public List<String> getUpgradeHUD(BasePedestalBlockEntity pedestal) {
        List<String> messages = super.getUpgradeHUD(pedestal);
        if (messages.isEmpty()) {
            if (((Boolean)PedestalConfig.COMMON.cobbleGeneratorRequireTools.get()).booleanValue() && pedestal.getActualToolStack().m_41619_()) {
                messages.add(ChatFormatting.BLACK + "Needs Tool");
            }
            if (((Boolean)PedestalConfig.COMMON.cobbleGeneratorDamageTools.get()).booleanValue() && pedestal.hasTool() && pedestal.getDurabilityRemainingOnInsertedTool() <= 1) {
                messages.add(ChatFormatting.BLACK + "Inserted Tool");
                messages.add(ChatFormatting.RED + "Is Broken");
            }
        }
        return messages;
    }

    public List<ItemStack> getItemsToGenerate(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack blockToBreak) {
        Block generatedBlock = Block.m_49814_((Item)blockToBreak.m_41720_());
        if (generatedBlock != Blocks.f_50016_) {
            ItemStack toolStack = pedestal.getToolStack();
            LootContext.Builder builder = new LootContext.Builder((ServerLevel)level).m_230911_(level.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)new Vec3((double)pedestalPos.m_123341_(), (double)pedestalPos.m_123342_(), (double)pedestalPos.m_123343_())).m_78972_(LootContextParams.f_81463_, (Object)toolStack);
            WeakReference<FakePlayer> fakePlayerReference = pedestal.getPedestalPlayer(pedestal);
            if (fakePlayerReference != null && fakePlayerReference.get() != null) {
                builder.m_78984_(LootContextParams.f_81455_, (Object)((Entity)fakePlayerReference.get()));
            }
            return generatedBlock.m_49966_().m_60724_(builder);
        }
        return new ArrayList<ItemStack>();
    }

    public void resetCachedRecipe(ItemStack upgrade) {
        CompoundTag tag = upgrade.m_41784_();
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)tag, (String)"_cobblegen_result");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)tag, (String)"_fluidStack");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)tag, (String)"_energyNeeded");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)tag, (String)"_xpNeeded");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"mowlib", (CompoundTag)tag, (String)"_dustMagicColor");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"mowlib", (CompoundTag)tag, (String)"_dustMagicAmount");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)tag, (String)"_cobblegen_cached");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)tag, (String)"_stackList");
    }

    public void lookupAndCacheCobbleGenResult(Level level, ItemStack input, ItemStack upgrade) {
        SimpleContainer container = new SimpleContainer(new ItemStack[]{input});
        Optional result = level.m_7465_().m_44015_((RecipeType)CobbleGenRecipe.Type.INSTANCE, (Container)container, level);
        CompoundTag tag = upgrade.m_41784_();
        if (result.isPresent()) {
            CobbleGenRecipe recipe = (CobbleGenRecipe)result.get();
            MowLibCompoundTagUtils.writeItemStackToNBT((String)"pedestals", (CompoundTag)tag, (ItemStack)recipe.m_8043_(), (String)"_cobblegen_result");
            MowLibCompoundTagUtils.writeFluidStackToNBT((String)"pedestals", (CompoundTag)tag, (FluidStack)recipe.getResultFluidNeeded(), (String)"_fluidStack");
            MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)tag, (int)recipe.getResultEnergyNeeded(), (String)"_energyNeeded");
            MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)tag, (int)recipe.getResultExperienceNeeded(), (String)"_xpNeeded");
            DustMagic.setDustMagicInTag((CompoundTag)tag, (DustMagic)recipe.getResultDustNeeded());
        }
        MowLibCompoundTagUtils.writeBooleanToNBT((String)"pedestals", (CompoundTag)tag, (boolean)true, (String)"_cobblegen_cached");
    }

    @Override
    public void actionOnNeighborBelowChange(BasePedestalBlockEntity pedestal, BlockPos belowBlock) {
        this.resetCachedRecipe(pedestal.getCoinOnPedestal());
    }

    @Override
    public void actionOnRemovedFromPedestal(BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
        this.resetCachedRecipe(coinInPedestal);
    }

    private ItemStack getGeneratorRecipeResult(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack upgrade) {
        CompoundTag tag = upgrade.m_41784_();
        if (!MowLibCompoundTagUtils.readBooleanFromNBT((String)"pedestals", (CompoundTag)tag, (String)"_cobblegen_cached")) {
            BlockPos posBelow = this.getPosOfBlockBelow(level, pedestalPos, 1);
            this.lookupAndCacheCobbleGenResult(level, new ItemStack((ItemLike)level.m_8055_(posBelow).m_60734_().m_5456_()), upgrade);
        }
        return MowLibCompoundTagUtils.readItemStackFromNBT((String)"pedestals", (CompoundTag)tag, (String)"_cobblegen_result");
    }

    private int getGeneratorMultiplier(BasePedestalBlockEntity pedestal, ItemStack upgrade, FluidStack fluidStackNeeded, int energyNeeded, int experienceNeeded, DustMagic dustNeeded) {
        int multiplier = Math.max(1, this.getItemCapacityIncrease(upgrade));
        boolean damage = this.canDamageTool(pedestal.m_58904_(), pedestal, (Boolean)PedestalConfig.COMMON.cobbleGeneratorDamageTools.get());
        if (!fluidStackNeeded.isEmpty()) {
            FluidStack storedFluid = pedestal.getStoredFluid();
            multiplier = !storedFluid.isFluidEqual(fluidStackNeeded) ? 0 : Math.min(multiplier, storedFluid.getAmount() / fluidStackNeeded.getAmount());
        }
        if (energyNeeded > 0) {
            multiplier = Math.min(multiplier, pedestal.getStoredEnergy() / energyNeeded);
        }
        if (experienceNeeded > 0) {
            multiplier = Math.min(multiplier, pedestal.getStoredExperience() / experienceNeeded);
        }
        if (!dustNeeded.isEmpty()) {
            DustMagic storedDust = pedestal.getStoredDust();
            multiplier = storedDust.getDustColor() != dustNeeded.getDustColor() ? 0 : Math.min(multiplier, storedDust.getDustAmount() / dustNeeded.getDustAmount());
        }
        if (damage) {
            multiplier = Math.min(multiplier, pedestal.getDurabilityRemainingOnInsertedTool());
        }
        return multiplier;
    }

    private void consumeFuel(BasePedestalBlockEntity pedestal, FluidStack fluidStackNeeded, int energyNeeded, int experienceNeeded, DustMagic dustNeeded, int multiplier) {
        FluidStack toRemove;
        boolean damage = this.canDamageTool(pedestal.m_58904_(), pedestal, (Boolean)PedestalConfig.COMMON.cobbleGeneratorDamageTools.get());
        if (!fluidStackNeeded.isEmpty()) {
            toRemove = fluidStackNeeded.copy();
            toRemove.setAmount(fluidStackNeeded.getAmount() * multiplier);
            pedestal.removeFluid(toRemove, IFluidHandler.FluidAction.EXECUTE);
        }
        if (energyNeeded > 0) {
            pedestal.removeEnergy(energyNeeded * multiplier, false);
        }
        if (experienceNeeded > 0) {
            pedestal.removeExperience(experienceNeeded * multiplier, false);
        }
        if (!dustNeeded.isEmpty()) {
            toRemove = dustNeeded.copy();
            toRemove.setDustAmount(dustNeeded.getDustColor() * multiplier);
            pedestal.removeDust((DustMagic)toRemove, IDustHandler.DustAction.EXECUTE);
        }
        if (damage) {
            this.upgradeDamageInsertedTool(pedestal, multiplier, false);
        }
    }

    public boolean allowRun(BasePedestalBlockEntity pedestal, boolean damage) {
        if (((Boolean)PedestalConfig.COMMON.cobbleGeneratorRequireTools.get()).booleanValue()) {
            if (pedestal.hasTool()) {
                if (damage) {
                    return pedestal.damageInsertedTool(1, true);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        this.upgradeRepairTool(pedestal);
        boolean allowrun = this.allowRun(pedestal, (Boolean)PedestalConfig.COMMON.cobbleGeneratorDamageTools.get());
        if (allowrun) {
            DustMagic dustNeeded;
            int experienceNeeded;
            int energyNeeded;
            ItemStack recipeResult = this.getGeneratorRecipeResult(level, pedestal, pedestalPos, coin);
            if (recipeResult.m_41619_()) {
                if (pedestal.canSpawnParticles()) {
                    MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestalPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalPos.m_123341_(), (double)((float)pedestalPos.m_123342_() + 1.0f), (double)pedestalPos.m_123343_(), new int[]{50, 50, 50}));
                }
                return;
            }
            List<ItemStack> getCobbleGenOutputs = this.getItemsToGenerate(level, pedestal, pedestalPos, recipeResult);
            if (getCobbleGenOutputs.isEmpty()) {
                return;
            }
            FluidStack fluidStackNeeded = MowLibCompoundTagUtils.readFluidStackFromNBT((String)"pedestals", (CompoundTag)coin.m_41783_(), (String)"_fluidStack");
            int multiplier = this.getGeneratorMultiplier(pedestal, coin, fluidStackNeeded, energyNeeded = MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)coin.m_41783_(), (String)"_energyNeeded"), experienceNeeded = MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)coin.m_41783_(), (String)"_xpNeeded"), dustNeeded = DustMagic.getDustMagicInTag((CompoundTag)coin.m_41783_()));
            if (multiplier == 0) {
                if (pedestal.canSpawnParticles()) {
                    MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestalPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalPos.m_123341_(), (double)((float)pedestalPos.m_123342_() + 1.0f), (double)pedestalPos.m_123343_(), new int[]{255, 255, 255}));
                }
                return;
            }
            for (ItemStack output : getCobbleGenOutputs) {
                if (output.m_41619_() || !pedestal.hasSpaceForItem(output)) continue;
                int numToAdd = Math.min(output.m_41613_() * multiplier, output.m_41741_());
                ItemStack toAdd = output.m_41777_();
                toAdd.m_41764_(numToAdd);
                ItemStack remainder = pedestal.addItemStack(toAdd, false);
                int fuelConsumedMultiplier = (int)Math.ceil((double)(toAdd.m_41613_() - remainder.m_41613_()) / (double)output.m_41613_());
                this.consumeFuel(pedestal, fluidStackNeeded, energyNeeded, experienceNeeded, dustNeeded, fuelConsumedMultiplier);
            }
        }
    }
}

