/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.Filters.BaseFilter;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemUpgradeDrain
extends ItemUpgradeBase {
    public ItemUpgradeDrain(Item.Properties p_41383_) {
        super(new Item.Properties());
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyBlockCapacity(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyRange(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyArea(ItemStack upgradeItemStack) {
        return (Boolean)PedestalConfig.COMMON.upgrade_require_sized_selectable_area.get();
    }

    @Override
    public boolean needsWorkCard(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public int getWorkCardType() {
        return 0;
    }

    @Override
    public int baseEnergyCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_drain_baseEnergyCost.get();
    }

    @Override
    public boolean energyDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_drain_energy_distance_multiplier.get();
    }

    @Override
    public double energyCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_drain_energyMultiplier.get();
    }

    @Override
    public int baseXpCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_drain_baseXpCost.get();
    }

    @Override
    public boolean xpDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_drain_xp_distance_multiplier.get();
    }

    @Override
    public double xpCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_drain_xpMultiplier.get();
    }

    @Override
    public DustMagic baseDustCostPerDistance() {
        return new DustMagic(((Integer)PedestalConfig.COMMON.upgrade_drain_dustColor.get()).intValue(), ((Integer)PedestalConfig.COMMON.upgrade_drain_baseDustAmount.get()).intValue());
    }

    @Override
    public boolean dustDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_drain_dust_distance_multiplier.get();
    }

    @Override
    public double dustCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_drain_dustMultiplier.get();
    }

    @Override
    public boolean hasSelectedAreaModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_drain_selectedAllowed.get();
    }

    @Override
    public double selectedAreaCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_drain_selectedMultiplier.get();
    }

    @Override
    public List<String> getUpgradeHUD(BasePedestalBlockEntity pedestal) {
        List<String> messages = super.getUpgradeHUD(pedestal);
        if (messages.size() <= 0) {
            if (this.baseEnergyCostPerDistance() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.RED + "Needs Energy");
                messages.add(ChatFormatting.RED + "To Operate");
            }
            if (this.baseXpCostPerDistance() > 0 && pedestal.getStoredExperience() < this.baseXpCostPerDistance()) {
                messages.add(ChatFormatting.GREEN + "Needs Experience");
                messages.add(ChatFormatting.GREEN + "To Operate");
            }
            if (this.baseDustCostPerDistance().getDustAmount() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.LIGHT_PURPLE + "Needs Dust");
                messages.add(ChatFormatting.LIGHT_PURPLE + "To Operate");
            }
        }
        return messages;
    }

    @Override
    public void actionOnRemovedFromPedestal(BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
        super.actionOnRemovedFromPedestal(pedestal, coinInPedestal);
        this.resetCachedValidWorkCardPositions(coinInPedestal);
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_numposition");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_numdelay");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_numheight");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_boolstop");
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        List<BlockPos> allPositions = this.getValidWorkCardPositions(pedestal);
        if (allPositions.isEmpty()) {
            return;
        }
        if (pedestal.hasFluid()) {
            this.drainAction(level, pedestal, allPositions);
        }
    }

    private int getHeightIteratorValue(BasePedestalBlockEntity pedestal) {
        return (Integer)PedestalConfig.COMMON.upgrade_filler_baseBlocksPlaced.get() + this.getBlockCapacityIncrease(pedestal.getCoinOnPedestal());
    }

    private int getCurrentHeight(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        return coin.m_41784_().m_128441_("pedestals_numheight") ? MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"_numheight") : pedestal.m_58904_().m_141937_();
    }

    private void setCurrentHeight(BasePedestalBlockEntity pedestal, int num) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)num, (String)"_numheight");
    }

    private void iterateCurrentHeight(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        int current = this.getCurrentHeight(pedestal);
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)(current + this.getHeightIteratorValue(pedestal)), (String)"_numheight");
    }

    private int getCurrentDelay(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"_numdelay");
    }

    private void setCurrentDelay(BasePedestalBlockEntity pedestal, int num) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)num, (String)"_numdelay");
    }

    private void iterateCurrentDelay(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        int current = this.getCurrentDelay(pedestal);
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)(current + 1 + this.getSpeedTicksReduced(pedestal.getCoinOnPedestal())), (String)"_numdelay");
    }

    private int getCurrentPosition(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"_numposition");
    }

    private void setCurrentPosition(BasePedestalBlockEntity pedestal, int num) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)num, (String)"_numposition");
    }

    private void iterateCurrentPosition(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        int current = this.getCurrentPosition(pedestal);
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)(current + 1), (String)"_numposition");
    }

    private boolean passesFilter(BasePedestalBlockEntity pedestal, BlockState canMineBlock, BlockPos canMinePos) {
        FluidStack fluidInPed;
        BaseFilter filter;
        ItemStack filterInPedestal;
        Item item;
        if (pedestal.hasFilter() && (item = (filterInPedestal = pedestal.getFilterInPedestal()).m_41720_()) instanceof BaseFilter && (filter = (BaseFilter)item).getFilterDirection().neutral() && !(fluidInPed = pedestal.getStoredFluid()).isEmpty()) {
            return filter.canAcceptFluids(filterInPedestal, fluidInPed);
        }
        return true;
    }

    private boolean canPlace(BasePedestalBlockEntity pedestal, BlockState getBlock, BlockPos currentPos) {
        FluidStack fluidInPed = pedestal.getStoredFluid();
        if (!(fluidInPed.isEmpty() || ForgeRegistries.FLUIDS.tags().getTag(FluidTags.create((ResourceLocation)new ResourceLocation("pedestals", "pedestals_cannot_place_fluid"))).stream().toList().contains(fluidInPed.getFluid()) || getBlock.m_60734_() != Blocks.f_50016_ && getBlock.m_60819_().m_76170_() && !getBlock.m_61138_((Property)BlockStateProperties.f_61362_))) {
            if (getBlock.m_60734_() == Blocks.f_50016_) {
                return true;
            }
            if (getBlock.m_61138_((Property)BlockStateProperties.f_61362_) && fluidInPed.getFluid().equals(Fluids.f_76193_) ? (Boolean)getBlock.m_61143_((Property)BlockStateProperties.f_61362_) == false : !getBlock.m_60819_().m_76170_() && !getBlock.m_60819_().m_76178_()) {
                return true;
            }
        }
        return false;
    }

    public void drainAction(Level level, BasePedestalBlockEntity pedestal, List<BlockPos> listed) {
        WeakReference<FakePlayer> getPlayer;
        if (!level.m_5776_() && (getPlayer = pedestal.getPedestalPlayer(pedestal)) != null && getPlayer.get() != null) {
            int currentPosition = this.getCurrentPosition(pedestal);
            BlockPos currentPoint = listed.get(currentPosition);
            BlockState blockAtPoint = level.m_8055_(currentPoint);
            boolean fuelRemoved = true;
            if (pedestal.removeFluid(1000, IFluidHandler.FluidAction.SIMULATE).getAmount() == 1000) {
                if (this.removeFuelForAction(pedestal, this.getDistanceBetweenPoints(pedestal.getPos(), currentPoint), true)) {
                    UseOnContext blockContext;
                    InteractionResult result;
                    FluidStack stackInPedestal;
                    if (this.canPlace(pedestal, blockAtPoint, currentPoint) && this.passesFilter(pedestal, blockAtPoint, currentPoint) && (stackInPedestal = pedestal.getStoredFluid().copy()).getFluid().m_76145_() != null && stackInPedestal.getFluid().m_76145_().m_76188_() != null && (result = ForgeHooks.onPlaceItemIntoWorld((UseOnContext)(blockContext = new UseOnContext(level, (Player)getPlayer.get(), InteractionHand.MAIN_HAND, FluidUtil.getFilledBucket((FluidStack)stackInPedestal), new BlockHitResult(Vec3.f_82478_, this.getPedestalFacing(level, pedestal.getPos()), currentPoint, false))))) == InteractionResult.PASS) {
                        if (this.removeFuelForAction(pedestal, this.getDistanceBetweenPoints(pedestal.getPos(), currentPoint), false)) {
                            if (blockAtPoint.m_61138_((Property)BlockStateProperties.f_61362_)) {
                                if (!((Boolean)blockAtPoint.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && pedestal.removeFluid(1000, IFluidHandler.FluidAction.EXECUTE).getFluid().equals(Fluids.f_76193_)) {
                                    level.m_46597_(currentPoint, (BlockState)blockAtPoint.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)));
                                }
                            } else if (!pedestal.removeFluid(1000, IFluidHandler.FluidAction.EXECUTE).isEmpty()) {
                                level.m_46597_(currentPoint, stackInPedestal.getFluid().m_76145_().m_76188_());
                            }
                        } else {
                            fuelRemoved = false;
                        }
                    }
                } else {
                    fuelRemoved = false;
                }
            }
            if (currentPosition + 1 >= listed.size()) {
                this.setCurrentPosition(pedestal, 0);
            } else if (fuelRemoved) {
                this.iterateCurrentPosition(pedestal);
            }
        }
    }
}

