/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.Capabilities.Dust.IDustHandler;
import com.mowmaster.mowlib.MowLibUtils.MowLibContainerUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibItemUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibMultiContainer;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import com.mowmaster.pedestals.Recipes.BottlerRecipe;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ItemUpgradeBottler
extends ItemUpgradeBase {
    public ItemUpgradeBottler(Item.Properties p_41383_) {
        super(new Item.Properties());
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public int getUpgradeWorkRange(ItemStack coinUpgrade) {
        return 0;
    }

    @Override
    public void actionOnRemovedFromPedestal(BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
    }

    @Nullable
    protected BottlerRecipe getNormalRecipe(BasePedestalBlockEntity pedestal, ItemStack stackIn) {
        Level level = pedestal.m_58904_();
        MowLibMultiContainer cont = MowLibContainerUtils.getMultiContainer((int)1);
        cont.m_6836_(-1, stackIn);
        if (pedestal.hasFluid()) {
            cont.setFluidStack(pedestal.getStoredFluid());
        }
        if (pedestal.hasEnergy()) {
            cont.setEnergy(pedestal.getStoredEnergy());
        }
        if (pedestal.hasExperience()) {
            cont.setExperience(pedestal.getStoredExperience());
        }
        if (pedestal.hasDust()) {
            cont.setDustMagic(pedestal.getStoredDust());
        }
        if (level == null) {
            return null;
        }
        RecipeManager recipeManager = level.m_7465_();
        Optional optional = recipeManager.m_44015_((RecipeType)BottlerRecipe.Type.INSTANCE, (Container)cont, level);
        if (optional.isPresent()) {
            return optional.orElse(null);
        }
        return null;
    }

    protected Collection<ItemStack> getNormalResults(BottlerRecipe recipe) {
        return recipe == null ? Arrays.asList(ItemStack.f_41583_) : Collections.singleton(recipe.m_8043_());
    }

    protected FluidStack getFluidNeeded(BottlerRecipe recipe) {
        return recipe == null ? FluidStack.EMPTY : recipe.getFluidNeeded();
    }

    protected int getEnergyNeeded(BottlerRecipe recipe) {
        return recipe == null ? 0 : recipe.getEnergyNeeded();
    }

    protected int getExperienceNeeded(BottlerRecipe recipe) {
        return recipe == null ? 0 : recipe.getExperienceNeeded();
    }

    protected DustMagic getDustNeeded(BottlerRecipe recipe) {
        return recipe == null ? DustMagic.EMPTY : recipe.getDustNeeded();
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        BlockPos inventoryPos = this.getPosOfBlockBelow(level, pedestalPos, 1);
        if (level.m_7702_(inventoryPos) instanceof BasePedestalBlockEntity) {
            return;
        }
        MowLibItemUtils.findItemHandlerAtPos((Level)level, (BlockPos)inventoryPos, (Direction)this.getPedestalFacing(level, pedestalPos), (boolean)true).ifPresent(handler -> ItemUpgradeBottler.getFirstSlotWithNonMachineFilteredItems(pedestal, handler).ifPresent(slot -> {
            ItemStack itemFromInv = handler.getStackInSlot(slot.intValue());
            ItemStack copyIncoming = itemFromInv.m_41777_();
            copyIncoming.m_41764_(1);
            BottlerRecipe recipe = this.getNormalRecipe(pedestal, copyIncoming);
            ItemStack returnedStack = this.getNormalResults(recipe).stream().findFirst().orElse(ItemStack.f_41583_);
            if (!returnedStack.m_41619_()) {
                boolean hasRequiredStuff;
                boolean fluid = true;
                FluidStack getRequiredFluid = this.getFluidNeeded(recipe);
                boolean energy = true;
                int getRequiredEnergy = this.getEnergyNeeded(recipe);
                boolean exp = true;
                int getRequiredExperience = this.getExperienceNeeded(recipe);
                boolean dust = true;
                DustMagic getRequiredDust = this.getDustNeeded(recipe);
                if (!getRequiredFluid.isEmpty() && pedestal.removeFluid(getRequiredFluid, IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
                    fluid = false;
                }
                if (getRequiredEnergy > 0 && pedestal.removeEnergy(getRequiredEnergy, true) <= 0) {
                    energy = false;
                }
                if (getRequiredExperience > 0 && pedestal.removeExperience(getRequiredExperience, true) <= 0) {
                    exp = false;
                }
                if (!getRequiredDust.isEmpty() && pedestal.removeDust(getRequiredDust, IDustHandler.DustAction.SIMULATE).isEmpty()) {
                    dust = false;
                }
                boolean bl = hasRequiredStuff = fluid && energy && exp && dust;
                if (!handler.extractItem(slot.intValue(), 1, true).m_41619_() && pedestal.addItem(returnedStack, true) && hasRequiredStuff) {
                    handler.extractItem(slot.intValue(), 1, false);
                    if (!getRequiredFluid.isEmpty()) {
                        pedestal.removeFluid(getRequiredFluid, IFluidHandler.FluidAction.EXECUTE);
                    }
                    if (getRequiredEnergy > 0) {
                        pedestal.removeEnergy(getRequiredEnergy, false);
                    }
                    if (getRequiredExperience > 0) {
                        pedestal.removeExperience(getRequiredExperience, false);
                    }
                    if (!getRequiredDust.isEmpty()) {
                        pedestal.removeDust(getRequiredDust, IDustHandler.DustAction.EXECUTE);
                    }
                    pedestal.addItem(returnedStack, false);
                }
            }
        }));
    }
}

