/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.property;

import brentmaas.buildguide.common.screen.AbstractScreenHandler;
import brentmaas.buildguide.common.screen.BaseScreen;
import brentmaas.buildguide.common.screen.widget.IWidget;
import java.util.ArrayList;

public abstract class Property<T> {
    protected static final int baseX = 180;
    protected static final int baseY = 70;
    protected static final int height = 20;
    protected int x = 180;
    protected int y = 70;
    public T value;
    protected AbstractScreenHandler.Translatable name;
    public ArrayList<IWidget> widgetList = new ArrayList();
    protected boolean visible = true;

    public Property(T value, AbstractScreenHandler.Translatable name) {
        this.value = value;
        this.name = name;
    }

    public void onSelectedInGUI() {
        for (IWidget widget : this.widgetList) {
            widget.setVisibility(true);
        }
        this.visible = true;
    }

    public void onDeselectedInGUI() {
        for (IWidget widget : this.widgetList) {
            widget.setVisibility(false);
        }
        this.visible = false;
    }

    public void addToScreen(BaseScreen screen) {
        for (IWidget widget : this.widgetList) {
            screen.addWidget(widget);
        }
    }

    public void setValue(T value) {
        this.value = value;
    }

    public abstract String getStringValue();

    public abstract boolean setValueFromString(String var1);

    public void setName(AbstractScreenHandler.Translatable name) {
        this.name = name;
    }

    public void setSlot(int slot) {
        this.x = 180;
        this.y = 70 + slot * 20;
        for (IWidget widget : this.widgetList) {
            widget.setYPosition(this.y);
        }
    }

    public void render(BaseScreen screen) {
        this.drawString(screen, this.name.toString(), this.x + 5, this.y + 5, 0xFFFFFF);
    }

    public void drawString(BaseScreen screen, String text, int x, int y, int colour) {
        if (this.visible) {
            screen.drawShadowLeft(text, x, y, 0xFFFFFF);
        }
    }

    public void drawStringCentred(BaseScreen screen, String text, int x, int y, int colour) {
        if (this.visible) {
            screen.drawShadowCentred(text, x, y, 0xFFFFFF);
        }
    }
}

